/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.nav;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Button;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.client.gui.element.tcu.nav.ButtonNav;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.turret.GuiTcuRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class PageNavigation
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tcu.page_nav");
    private final Map<GuiElementInst, ResourceLocation> pages = new TreeMap<GuiElementInst, ResourceLocation>(new ComparatorTabButton());
    private GuiElementInst tabScrollL;
    private GuiElementInst tabScrollR;
    private int maxTabsShown;
    private int tabStartIdx = 0;
    Map<GuiElementInst, ResourceLocation> shownTabs = Collections.emptyMap();

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.maxTabsShown = JsonUtils.getIntVal((JsonElement)data.get("tabsShown"), (int)7);
        int currIdx = 0;
        for (ResourceLocation pageKey : GuiTcuRegistry.PAGE_KEYS) {
            GuiElementInst btn = new GuiElementInst((IGuiElement)new ButtonNav(currIdx++, pageKey), data.getAsJsonObject("buttonData")).initialize(gui);
            btn.get().bakeData(gui, btn.data, btn);
            this.pages.put(btn, pageKey);
        }
        this.tabScrollL = new GuiElementInst((IGuiElement)new ButtonTabScroll(0), data.getAsJsonObject("tabScrollLeft")).initialize(gui);
        this.tabScrollL.get().bakeData(gui, this.tabScrollL.data, this.tabScrollL);
        this.tabScrollL.setVisible(false);
        this.tabScrollR = new GuiElementInst((IGuiElement)new ButtonTabScroll(1), data.getAsJsonObject("tabScrollRight")).initialize(gui);
        this.tabScrollR.get().bakeData(gui, this.tabScrollR.data, this.tabScrollR);
        this.tabScrollR.setVisible(false);
    }

    public void update(IGui gui, JsonObject data) {
        int tabLeft;
        IGuiTcuInst tcu = (IGuiTcuInst)gui;
        ResourceLocation cPageKey = tcu.getCurrentPageKey();
        int tabScrollElemLWidth = this.tabScrollL.get().getWidth();
        int tabScrollElemRWidth = this.tabScrollR.get().getWidth();
        int cntAvailableTabs = 0;
        for (Map.Entry<GuiElementInst, ResourceLocation> entry : this.pages.entrySet()) {
            GuiElementInst btn = entry.getKey();
            ButtonNav btnNav = (ButtonNav)btn.get(ButtonNav.class);
            if (GuiTcuRegistry.INSTANCE.getPage(btnNav.pageKey).showTab(tcu)) {
                ++cntAvailableTabs;
                if (btnNav.pageIdx >= this.tabStartIdx && btnNav.pageIdx <= this.tabStartIdx + this.maxTabsShown) {
                    btn.setVisible(true);
                    btnNav.setEnabled(!cPageKey.equals((Object)btnNav.pageKey));
                    continue;
                }
            }
            btn.setVisible(false);
        }
        this.shownTabs = this.fetchShownPageButtons();
        int tabWidth = this.shownTabs.keySet().stream().map(elem -> elem.get().getWidth()).reduce((e1, e2) -> e1 + e2 + 2).orElse(2);
        this.tabScrollL.pos[0] = tabLeft = (tcu.getWidth() - tabWidth - tabScrollElemLWidth - tabScrollElemRWidth - 4) / 2;
        this.tabScrollL.setVisible(this.tabStartIdx > 0);
        this.tabScrollR.pos[0] = tabLeft + tabScrollElemLWidth + tabWidth + 4;
        this.tabScrollR.setVisible(this.tabStartIdx < cntAvailableTabs - this.shownTabs.size());
        int shownId = 0;
        for (Map.Entry<GuiElementInst, ResourceLocation> tab : this.shownTabs.entrySet()) {
            tab.getKey().pos[0] = tabLeft + tabScrollElemLWidth + 2 + shownId++ * 18;
        }
    }

    private Map<GuiElementInst, ResourceLocation> fetchShownPageButtons() {
        return this.pages.entrySet().stream().filter(e -> ((GuiElementInst)e.getKey()).isVisible()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, () -> new TreeMap(new ComparatorTabButton())));
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        GuiDefinition.renderElement((IGui)gui, (int)(x + this.tabScrollL.pos[0]), (int)y, (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.tabScrollL);
        GuiDefinition.renderElement((IGui)gui, (int)(x + this.tabScrollR.pos[0]), (int)y, (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.tabScrollR);
        this.shownTabs.forEach((btn, page) -> GuiDefinition.renderElement((IGui)gui, (int)(x + btn.pos[0]), (int)y, (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)btn));
    }

    public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        for (Map.Entry<GuiElementInst, ResourceLocation> e : this.shownTabs.entrySet()) {
            if (!e.getKey().get().mouseClicked(gui, mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        if (((ButtonTabScroll)this.tabScrollL.get(ButtonTabScroll.class)).mouseClicked(gui, mouseX, mouseY, mouseButton)) {
            return true;
        }
        return ((ButtonTabScroll)this.tabScrollR.get(ButtonTabScroll.class)).mouseClicked(gui, mouseX, mouseY, mouseButton);
    }

    public int getWidth() {
        return 18 * Math.min(this.maxTabsShown, this.pages.size()) - 2;
    }

    public int getHeight() {
        return 16;
    }

    private final class ButtonTabScroll
    extends Button {
        private final int direction;

        private ButtonTabScroll(int direction) {
            this.direction = direction;
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{16, 16});
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"uvSize", (int[])new int[]{16, 16});
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"texture", (String)Resources.GUI_TCU_BUTTONS.toString());
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"buttonFunction", (Number)-1);
            super.bakeData(gui, data, inst);
        }

        public void performAction(IGui gui, int id) {
            if (PageNavigation.this.tabStartIdx > 0 && this.direction == 0) {
                PageNavigation.this.tabStartIdx--;
            } else if (PageNavigation.this.tabStartIdx < PageNavigation.this.pages.size() - PageNavigation.this.maxTabsShown && this.direction == 1) {
                PageNavigation.this.tabStartIdx++;
            }
        }
    }

    private static final class ComparatorTabButton
    implements Comparator<GuiElementInst> {
        private ComparatorTabButton() {
        }

        @Override
        public int compare(GuiElementInst o1, GuiElementInst o2) {
            return Integer.compare(((ButtonNav)o1.get(ButtonNav.class)).pageIdx, ((ButtonNav)o2.get(ButtonNav.class)).pageIdx);
        }
    }
}

