/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.shieldcolor;

import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.function.Procedure;
import de.sanandrew.mods.turretmod.client.gui.element.tcu.shieldcolor.Slider;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;

public class ColorPicker
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("color_picker");
    private Slider hue;
    private Slider sat;
    private Slider lum;
    private Slider alp;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.hue = Slider.load(gui, data.getAsJsonObject("hueSlider"), 360.0f, 1.0f);
        this.sat = Slider.load(gui, data.getAsJsonObject("saturationSlider"), 1.0f, 100.0f);
        this.lum = Slider.load(gui, data.getAsJsonObject("luminanceSlider"), 1.0f, 100.0f);
        this.alp = Slider.load(gui, data.getAsJsonObject("alphaSlider"), 1.0f, 100.0f);
    }

    public void update(IGui gui, JsonObject data) {
        this.hue.update(gui);
        this.sat.update(gui);
        this.lum.update(gui);
        this.alp.update(gui);
    }

    public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        return this.hue.mouseClicked(gui, mouseX, mouseY, mouseButton) || this.sat.mouseClicked(gui, mouseX, mouseY, mouseButton) || this.lum.mouseClicked(gui, mouseX, mouseY, mouseButton) || this.alp.mouseClicked(gui, mouseX, mouseY, mouseButton);
    }

    public boolean keyTyped(IGui gui, char typedChar, int keyCode) throws IOException {
        return this.hue.keyTyped(gui, typedChar, keyCode) || this.sat.keyTyped(gui, typedChar, keyCode) || this.lum.keyTyped(gui, typedChar, keyCode) || this.alp.keyTyped(gui, typedChar, keyCode);
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        int c1;
        float h = this.hue.getValue();
        float s = this.sat.getValue();
        float l = this.lum.getValue();
        int max = this.hue.size[0];
        for (int i = 0; i < max; ++i) {
            c1 = ColorObj.fromHSLA((float)((float)i / (float)max * 360.0f), (float)1.0f, (float)0.5f, (float)1.0f).getColorInt();
            GuiUtils.drawGradientRect((int)(x + i + this.hue.pos[0]), (int)(y + this.hue.pos[1]), (int)1, (int)this.hue.size[1], (int)c1, (int)c1, (boolean)true);
        }
        c1 = ColorObj.fromHSLA((float)h, (float)0.0f, (float)l, (float)1.0f).getColorInt();
        int c2 = ColorObj.fromHSLA((float)h, (float)1.0f, (float)l, (float)1.0f).getColorInt();
        GuiUtils.drawGradientRect((int)(x + this.sat.pos[0]), (int)(y + this.sat.pos[1]), (int)this.sat.size[0], (int)this.sat.size[1], (int)c1, (int)c2, (boolean)false);
        c1 = ColorObj.fromHSLA((float)h, (float)s, (float)0.0f, (float)1.0f).getColorInt();
        c2 = ColorObj.fromHSLA((float)h, (float)s, (float)0.5f, (float)1.0f).getColorInt();
        GuiUtils.drawGradientRect((int)(x + this.lum.pos[0]), (int)(y + this.lum.pos[1]), (int)(this.lum.size[0] / 2), (int)this.lum.size[1], (int)c1, (int)c2, (boolean)false);
        c1 = ColorObj.fromHSLA((float)h, (float)s, (float)1.0f, (float)1.0f).getColorInt();
        GuiUtils.drawGradientRect((int)(x + this.lum.pos[0] + this.lum.size[0] / 2), (int)(y + this.lum.pos[1]), (int)(this.lum.size[0] / 2), (int)this.lum.size[1], (int)c2, (int)c1, (boolean)false);
        c1 = ColorObj.fromHSLA((float)h, (float)s, (float)l, (float)0.0f).getColorInt();
        c2 = ColorObj.fromHSLA((float)h, (float)s, (float)l, (float)1.0f).getColorInt();
        GuiUtils.drawGradientRect((int)(x + this.alp.pos[0]), (int)(y + this.alp.pos[1]), (int)this.alp.size[0], (int)this.alp.size[1], (int)c1, (int)c2, (boolean)false);
        this.hue.render(gui, partTicks, x, y, mouseX, mouseY);
        this.sat.render(gui, partTicks, x, y, mouseX, mouseY);
        this.lum.render(gui, partTicks, x, y, mouseX, mouseY);
        this.alp.render(gui, partTicks, x, y, mouseX, mouseY);
    }

    public int getColor() {
        return ColorObj.fromHSLA((float)this.hue.getValue(), (float)this.sat.getValue(), (float)this.lum.getValue(), (float)this.alp.getValue()).getColorInt();
    }

    public void setColor(int clr) {
        ColorObj newClr = new ColorObj(clr);
        float[] hsl = newClr.calcHSL();
        this.hue.setValue(hsl[0]);
        this.sat.setValue(hsl[1]);
        this.lum.setValue(hsl[2]);
        this.alp.setValue(newClr.fAlpha());
    }

    public void setOnChangeCallback(Procedure callback) {
        this.hue.setCallback(callback);
        this.sat.setCallback(callback);
        this.lum.setCallback(callback);
        this.alp.setCallback(callback);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }
}

