/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.shieldcolor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.TextField;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.function.Procedure;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.io.IOException;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.GlStateManager;
import org.apache.commons.lang3.Range;
import org.lwjgl.input.Mouse;

class Slider {
    int[] size;
    int[] pos;
    private static boolean prevMouseDownAll;
    private boolean prevMouseDown;
    private float value;
    private GuiElementInst valueTxt;
    private GuiElementInst marker;
    private float valueBase;
    private Procedure callback;
    private BiFunction<Slider, Float, String> toTextConverter;

    Slider() {
    }

    static Slider load(IGui gui, JsonObject data, float valueBase, float scale) {
        Slider sd = new Slider();
        sd.valueBase = valueBase;
        sd.size = JsonUtils.getIntArray((JsonElement)data.get("size"), (Range)Range.is((Comparable)Integer.valueOf(2)));
        sd.pos = JsonUtils.getIntArray((JsonElement)data.get("pos"), (Range)Range.is((Comparable)Integer.valueOf(2)));
        JsonObject tfData = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("textfield"), JsonObject::new);
        if (JsonUtils.getBoolVal((JsonElement)tfData.get("visible"), (boolean)true)) {
            BiFunction<Slider, String, Float> toValueConverter = (sl, s) -> {
                try {
                    return Float.valueOf(Math.max(0.0f, Math.min((float)(sl.size[0] - 1), Float.parseFloat(s) / scale / valueBase) * (float)(sl.size[0] - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            };
            JsonUtils.addDefaultJsonProperty((JsonObject)tfData, (String)"size", (int[])new int[]{40, sd.size[1]});
            sd.toTextConverter = (sl, f) -> String.format("%.1f", Float.valueOf(f.floatValue() / (float)(sl.size[0] - 1) * valueBase * scale));
            TextField tf = new TextField();
            sd.valueTxt = new GuiElementInst(JsonUtils.getIntArray((JsonElement)tfData.get("offset"), (int[])new int[]{3, 0}, (Range)Range.is((Comparable)Integer.valueOf(2))), (IGuiElement)tf, tfData).initialize(gui);
            tf.bakeData(gui, sd.valueTxt.data, sd.valueTxt);
            tf.setValidator(s -> toValueConverter.apply(sd, (String)s) != null);
            tf.setResponder(s -> {
                sd.value = ((Float)toValueConverter.apply(sd, (String)s)).floatValue();
                if (sd.callback != null) {
                    sd.callback.work();
                }
            });
        }
        JsonObject mrkData = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("marker"), JsonObject::new);
        sd.marker = new GuiElementInst(JsonUtils.getIntArray((JsonElement)mrkData.get("offset"), (int[])new int[]{-2, -2}), (IGuiElement)new Marker(), mrkData).initialize(gui);
        sd.marker.get().bakeData(gui, sd.marker.data, sd.marker);
        return sd;
    }

    boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        return this.valueTxt != null && this.valueTxt.get().mouseClicked(gui, mouseX, mouseY, mouseButton);
    }

    boolean keyTyped(IGui gui, char typedChar, int keyCode) throws IOException {
        return this.valueTxt != null && this.valueTxt.get().keyTyped(gui, typedChar, keyCode);
    }

    void update(IGui gui) {
        if (this.valueTxt != null) {
            this.valueTxt.get().update(gui, this.valueTxt.data);
        }
    }

    void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY) {
        if (Mouse.isButtonDown((int)0)) {
            if (!prevMouseDownAll && IGuiElement.isHovering((IGui)gui, (int)(x + this.pos[0]), (int)(y + this.pos[1]), (int)mouseX, (int)mouseY, (int)this.size[0], (int)this.size[1])) {
                prevMouseDownAll = true;
                this.prevMouseDown = true;
            }
            if (this.prevMouseDown) {
                this.setSliderValue(mouseX - gui.getScreenPosX() - x - this.pos[0]);
            }
        } else {
            prevMouseDownAll = false;
            this.prevMouseDown = false;
        }
        GuiDefinition.renderElement((IGui)gui, (int)(x + this.pos[0] + Math.round(this.value) + this.marker.pos[0]), (int)(y + this.pos[1] + this.marker.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.marker);
        if (this.valueTxt != null) {
            GuiDefinition.renderElement((IGui)gui, (int)(x + this.pos[0] + this.size[0] + this.valueTxt.pos[0]), (int)(y + this.pos[1] + this.valueTxt.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.valueTxt);
        }
    }

    private void setSliderValue(int value) {
        this.value = Math.max(0, Math.min(this.size[0] - 1, value));
        if (this.valueTxt != null && this.toTextConverter != null) {
            ((TextField)this.valueTxt.get(TextField.class)).setText(this.toTextConverter.apply(this, Float.valueOf(this.value)));
        }
        if (this.callback != null) {
            this.callback.work();
        }
    }

    void setValue(float val) {
        this.value = val * (float)(this.size[0] - 1) / this.valueBase;
        if (this.valueTxt != null && this.toTextConverter != null) {
            ((TextField)this.valueTxt.get(TextField.class)).setText(this.toTextConverter.apply(this, Float.valueOf(this.value)));
        }
    }

    float getValue() {
        return this.value / (float)(this.size[0] - 1) * this.valueBase;
    }

    void setCallback(Procedure callback) {
        this.callback = callback;
    }

    private static final class Marker
    extends Texture {
        private boolean invertMask;

        private Marker() {
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            super.bakeData(gui, data, inst);
            this.invertMask = JsonUtils.getBoolVal((JsonElement)data.get("invertMask"), (boolean)true);
        }

        protected void drawRect(IGui gui) {
            if (this.invertMask) {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                super.drawRect(gui);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            } else {
                super.drawRect(gui);
            }
        }
    }
}

