/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.target;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.client.gui.element.tcu.shieldcolor.CheckBox;
import de.sanandrew.mods.turretmod.client.gui.tcu.TargetType;
import java.util.Locale;
import org.apache.commons.lang3.Range;

public class TargetNode<T>
extends CheckBox {
    private int[] margins;
    private final T targetId;
    private final TargetType<T> targetType;
    private final int width;
    private String name;

    public TargetNode(T id, TargetType<T> type, int width) {
        this.targetId = id;
        this.targetType = type;
        this.width = width;
    }

    @Override
    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.margins = JsonUtils.getIntArray((JsonElement)data.get("margins"), (int[])new int[]{2, 2, 0, 2}, (Range)Range.is((Comparable)Integer.valueOf(4)));
        JsonObject lblData = new JsonObject();
        data.add("labelText", (JsonElement)lblData);
        data.remove("label");
        super.bakeData(gui, data, inst);
    }

    public <U extends Text> U getLabel(IGui gui, JsonObject data) {
        return (U)((Object)new Label());
    }

    private static String uppercaseFirst(String input) {
        return input.substring(0, 0).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    private static JsonObject getTextColor(JsonObject textData, TargetType.EntityType type) {
        String[] suffixes = new String[]{"default", "hover", "disabled"};
        JsonObject colors = new JsonObject();
        block4: for (String suffix : suffixes) {
            switch (type) {
                case HOSTILE: {
                    colors.addProperty(suffix, JsonUtils.getStringVal((JsonElement)textData.get("hostile" + TargetNode.uppercaseFirst(suffix)), (String)(suffix.equalsIgnoreCase("hover") ? "0xFFC00000" : "0xFF800000")));
                    continue block4;
                }
                case PEACEFUL: {
                    colors.addProperty(suffix, JsonUtils.getStringVal((JsonElement)textData.get("peaceful" + TargetNode.uppercaseFirst(suffix)), (String)(suffix.equalsIgnoreCase("hover") ? "0xFF00C000" : "0xFF008000")));
                    continue block4;
                }
                default: {
                    colors.addProperty(suffix, JsonUtils.getStringVal((JsonElement)textData.get("default" + TargetNode.uppercaseFirst(suffix)), (String)(suffix.equalsIgnoreCase("hover") ? "0xFF00C000" : "0xFF008000")));
                }
            }
        }
        return colors;
    }

    public void update(IGui gui, JsonObject data) {
        this.setChecked(this.targetType.isTargeted(((IGuiTcuInst)gui).getTurretInst(), this.targetId), false);
    }

    @Override
    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        super.render(gui, partTicks, x + this.margins[0], y + this.margins[3], mouseX, mouseY, data);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return super.getHeight() + this.margins[0] + this.margins[2];
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.targetType.getName(this.targetId);
        }
        return this.name;
    }

    private final class Label
    extends Text {
        private Label() {
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            data.add("color", (JsonElement)TargetNode.getTextColor(data, TargetNode.this.targetType.getType(TargetNode.this.targetId)));
            super.bakeData(gui, data, inst);
        }

        public String getBakedText(IGui gui, JsonObject data) {
            return "";
        }

        public String getDynamicText(IGui gui, String originalText) {
            return (String)MiscUtils.defIfNull((Object)TargetNode.this.getName(), (Object)"");
        }
    }
}

