/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tinfo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Item;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTurretProvider;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Range;

public class InfoUpgradeItems
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tinfo_upgrade_items");
    private GuiElementInst[] upgradeItems;
    private int width;
    private int height;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        int rows = JsonUtils.getIntVal((JsonElement)data.get("rows"), (int)2);
        UpgradeProcessor upgProc = (UpgradeProcessor)((IGuiTurretProvider)gui).getTurretInst().getUpgradeProcessor();
        this.upgradeItems = new GuiElementInst[upgProc.func_70302_i_()];
        double scale = JsonUtils.getDoubleVal((JsonElement)data.get("itemScale"), (double)0.5);
        int[] offset = JsonUtils.getIntArray((JsonElement)data.get("offset"), (int[])new int[2], (Range)Range.is((Comparable)Integer.valueOf(2)));
        int colCount = MathHelper.func_76143_f((double)((double)this.upgradeItems.length / (double)rows));
        int itemSz = (int)Math.round(16.0 * scale);
        int max = this.upgradeItems.length;
        for (int i = 0; i < max; ++i) {
            JsonObject itemData = new JsonObject();
            JsonUtils.addJsonProperty((JsonObject)itemData, (String)"scale", (Number)scale);
            int posX = i % colCount * (2 + itemSz);
            int posY = i / colCount * (2 + itemSz);
            this.upgradeItems[i] = new GuiElementInst(new int[]{offset[0] + posX, offset[1] + posY}, (IGuiElement)new UpgradeItem(upgProc.func_70301_a(i)), itemData);
            this.upgradeItems[i].get().bakeData(gui, itemData, this.upgradeItems[i]);
        }
        this.width = colCount * (2 + itemSz) - 2;
        this.height = rows * (2 + itemSz) - 2;
    }

    public void update(IGui gui, JsonObject data) {
        UpgradeProcessor upgProc = (UpgradeProcessor)((IGuiTurretProvider)gui).getTurretInst().getUpgradeProcessor();
        int max = this.upgradeItems.length;
        for (int i = 0; i < max; ++i) {
            ((UpgradeItem)this.upgradeItems[i].get(UpgradeItem.class)).stack = upgProc.func_70301_a(i);
            this.upgradeItems[i].get().update(gui, this.upgradeItems[i].data);
        }
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        for (GuiElementInst upgradeItem : this.upgradeItems) {
            upgradeItem.get().render(gui, partTicks, x + upgradeItem.pos[0], y + upgradeItem.pos[1], mouseX, mouseY, upgradeItem.data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static final class UpgradeItem
    extends Item {
        UpgradeItem(ItemStack item) {
            this.stack = item;
        }

        protected ItemStack getBakedStack(IGui gui, JsonObject data) {
            return this.stack;
        }
    }
}

