/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tinfo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTurretProvider;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Range;

public class InfoUpgradeTooltips
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tinfo_upgrade_ttips");
    private GuiElementInst[] ttips;
    private int width;
    private int height;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        int rows = JsonUtils.getIntVal((JsonElement)data.get("rows"), (int)2);
        UpgradeProcessor upgProc = (UpgradeProcessor)((IGuiTurretProvider)gui).getTurretInst().getUpgradeProcessor();
        this.ttips = new GuiElementInst[upgProc.func_70302_i_()];
        double scale = JsonUtils.getDoubleVal((JsonElement)data.get("itemScale"), (double)0.5);
        int[] offset = JsonUtils.getIntArray((JsonElement)data.get("offset"), (int[])new int[]{-1, -1}, (Range)Range.is((Comparable)Integer.valueOf(2)));
        int colCount = MathHelper.func_76143_f((double)((double)this.ttips.length / (double)rows));
        int itemSz = (int)Math.round(16.0 * scale);
        int max = this.ttips.length;
        for (int i = 0; i < max; ++i) {
            JsonObject itemData = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("tooltip"), JsonObject::new);
            JsonUtils.addDefaultJsonProperty((JsonObject)itemData, (String)"size", (int[])new int[]{itemSz + 2, itemSz + 2});
            int posX = i % colCount * (2 + itemSz);
            int posY = i / colCount * (2 + itemSz);
            this.ttips[i] = new GuiElementInst(new int[]{offset[0] + posX, offset[1] + posY}, (IGuiElement)new Tooltip(upgProc.func_70301_a(i)), itemData);
            this.ttips[i].get().bakeData(gui, itemData, this.ttips[i]);
        }
        this.width = colCount * (2 + itemSz) - 2;
        this.height = rows * (2 + itemSz) - 2;
    }

    public void update(IGui gui, JsonObject data) {
        UpgradeProcessor upgProc = (UpgradeProcessor)((IGuiTurretProvider)gui).getTurretInst().getUpgradeProcessor();
        int max = this.ttips.length;
        for (int i = 0; i < max; ++i) {
            ((Tooltip)this.ttips[i].get(Tooltip.class)).stack = upgProc.func_70301_a(i);
            this.ttips[i].get().update(gui, this.ttips[i].data);
        }
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        for (GuiElementInst upgradeItem : this.ttips) {
            upgradeItem.get().render(gui, partTicks, x + upgradeItem.pos[0], y + upgradeItem.pos[1], mouseX, mouseY, upgradeItem.data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static final class Tooltip
    extends de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip {
        private boolean visible = true;
        ItemStack stack;

        Tooltip(ItemStack stack) {
            this.stack = stack;
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{16, 16});
            super.bakeData(gui, data, inst);
        }

        public GuiElementInst getContent(IGui gui, JsonObject data) {
            return new GuiElementInst((IGuiElement)new TooltipText()).initialize(gui);
        }

        public void update(IGui gui, JsonObject data) {
            ((TooltipText)this.getChild("content").get(TooltipText.class)).currStack = this.stack;
            this.visible = ItemStackUtils.isValid((ItemStack)this.stack);
            super.update(gui, data);
        }

        public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
            if (!this.visible) {
                return;
            }
            if (IGuiElement.isHovering((IGui)gui, (int)x, (int)y, (int)mouseX, (int)mouseY, (int)this.size[0], (int)this.size[1])) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                GuiUtils.drawGradientRect((int)(x + 1), (int)(y + 1), (int)(this.size[0] - 1), (int)(this.size[1] - 1), (int)-2130706433, (int)-2130706433, (boolean)false);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179126_j();
            }
            super.render(gui, partTicks, x, y, mouseX, mouseY, data);
        }

        public int getWidth() {
            return this.size[0];
        }

        public int getHeight() {
            return this.size[1];
        }

        private static final class TooltipText
        implements IGuiElement {
            private final List<GuiElementInst> lines = new ArrayList<GuiElementInst>();
            private ItemStack currStack = ItemStack.field_190927_a;
            private ItemStack prevStack = ItemStack.field_190927_a;
            private int width;
            private int height;

            private TooltipText() {
            }

            public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            }

            public void update(IGui gui, JsonObject data) {
                if (!ItemStackUtils.areEqual((ItemStack)this.currStack, (ItemStack)this.prevStack)) {
                    this.prevStack = this.currStack;
                    this.lines.clear();
                    this.width = 0;
                    this.height = 0;
                    List ttip = gui.get().func_191927_a(this.currStack);
                    for (String line : ttip) {
                        GuiElementInst txtElem = new GuiElementInst(new int[]{0, this.height}, (IGuiElement)new Text()).initialize(gui);
                        JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"color", (String)"0xFFFFFFFF");
                        JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"text", (String)line);
                        JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"shadow", (Boolean)true);
                        txtElem.get().bakeData(gui, txtElem.data, txtElem);
                        this.lines.add(txtElem);
                        this.height += txtElem.get().getHeight() + (this.height == 0 ? 2 : 0);
                    }
                    this.height -= 2 + (ttip.size() < 2 ? 2 : 0);
                }
            }

            public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
                this.update(gui, data);
                for (GuiElementInst line : this.lines) {
                    GuiDefinition.renderElement((IGui)gui, (int)(x + line.pos[0]), (int)(y + line.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)line);
                    this.width = Math.max(this.width, line.get().getWidth());
                }
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }
        }
    }
}

