/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu;

import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.util.GuiHelper;
import de.sanandrew.mods.turretmod.item.ItemTurretControlUnit;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class GuiTcuScreen
extends GuiScreen
implements IGuiTcuInst<GuiTcuScreen> {
    private final ResourceLocation pageKey;
    private final ITurretInst turret;
    private final IGuiTCU guiDelegate;
    private final boolean isRemote;
    private int posX;
    private int posY;
    private int xSize;
    private int ySize;
    private GuiDefinition guiDef;

    public GuiTcuScreen(ResourceLocation pageKey, IGuiTCU gui, ITurretInst turretInst, boolean isRemote) {
        this.pageKey = pageKey;
        this.turret = turretInst;
        this.guiDelegate = gui;
        this.isRemote = isRemote;
        try {
            this.guiDef = GuiDefinition.getNewDefinition((ResourceLocation)this.guiDelegate.getGuiDefinition());
            this.xSize = this.guiDef.width;
            this.ySize = this.guiDef.height;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, (Object)e);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiHelper.initGuiDef(this.guiDef, this);
        this.posX = (this.field_146294_l - this.xSize) / 2;
        this.posY = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.guiDelegate.initialize(this, this.guiDef);
    }

    public void func_73876_c() {
        super.func_73876_c();
        GuiTcuScreen.checkGuiClose(this);
        this.guiDelegate.updateScreen(this);
        this.guiDef.update((IGui)this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GuiHelper.drawGDBackground(this.guiDef, this, partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.guiDef.drawForeground((IGui)this, mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.guiDef.mouseClicked((IGui)this, mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.guiDef.mouseClickMove((IGui)this, mouseX, mouseY, mouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.guiDef.mouseReleased((IGui)this, mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.guiDef.handleMouseInput((IGui)this);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (!this.guiDef.keyTyped((IGui)this, typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
        this.guiDelegate.keyTyped(this, typedChar, keyCode);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.guiDef.guiClosed((IGui)this);
        this.guiDelegate.guiClosed(this);
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public GuiTcuScreen getGui() {
        return this;
    }

    @Override
    public ITurretInst getTurretInst() {
        return this.turret;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public int getWidth() {
        return this.xSize;
    }

    @Override
    public int getHeight() {
        return this.ySize;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void drawGradient(int left, int top, int right, int bottom, int startColor, int endColor) {
        this.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public ResourceLocation getCurrentPageKey() {
        return this.pageKey;
    }

    public GuiScreen get() {
        return this;
    }

    public GuiDefinition getDefinition() {
        return this.guiDef;
    }

    public int getScreenPosX() {
        return this.posX;
    }

    public int getScreenPosY() {
        return this.posY;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public boolean canRemoteTransfer() {
        return this.turret.getUpgradeProcessor().canAccessRemotely();
    }

    public boolean performAction(IGuiElement element, int action) {
        return this.guiDelegate.onElementAction(this, element, action);
    }

    static void checkGuiClose(IGuiTcuInst<?> gui) {
        Minecraft mc = gui.get().field_146297_k;
        ITurretInst turret = gui.getTurretInst();
        EntityLiving turretL = turret.get();
        if (turretL.field_70128_L) {
            mc.field_71439_g.func_71053_j();
        } else {
            double d = turretL.func_70032_d((Entity)mc.field_71439_g);
            double d2 = gui.isRemote() ? 64.0 : 6.0;
            if (d > d2 && !ItemTurretControlUnit.isHeldTcuBoundToTurret((EntityPlayer)mc.field_71439_g, turret)) {
                mc.field_71439_g.func_71053_j();
            }
        }
    }
}

