/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.label;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelElement;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.init.ClientProxy;
import de.sanandrew.mods.turretmod.registry.Lang;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldPersonal;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;

public class LabelTurretPersShield
implements ILabelElement {
    @Override
    public boolean showElement(ITurretInst turretInst) {
        return turretInst.getUpgradeProcessor().hasUpgrade(Upgrades.SHIELD_PERSONAL);
    }

    @Override
    public float getHeight(ITurretInst turretInst, FontRenderer fontRenderer) {
        return (float)fontRenderer.field_78288_b + 6.0f;
    }

    @Override
    public float getWidth(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return stdFontRenderer.func_78256_a(LabelTurretPersShield.getLabel(turretInst));
    }

    @Override
    public void renderQuads(ITurretInst turretInst, float maxWidth, float progress, FontRenderer fontRenderer, float currHeight, BufferBuilder buffer) {
        ShieldPersonal shield = (ShieldPersonal)turretInst.getUpgradeProcessor().getUpgradeInstance(Upgrades.SHIELD_PERSONAL.getId());
        float healthPerc = shield.getValue() / 20.0f * maxWidth;
        ClientProxy.addQuad(buffer, 0.0, currHeight += (float)fontRenderer.field_78288_b + 2.0f, healthPerc, (double)currHeight + 2.0, new ColorObj(0.87f, 0.45f, 1.0f, Math.max(progress, 0.015686275f)));
        ClientProxy.addQuad(buffer, healthPerc, currHeight, maxWidth, (double)currHeight + 2.0, new ColorObj(0.22f, 0.11f, 0.4f, Math.max(progress, 0.015686275f)));
    }

    @Override
    public void renderTextured(ITurretInst turretInst, float maxWidth, float progress, FontRenderer fontRenderer) {
        fontRenderer.func_175065_a(LabelTurretPersShield.getLabel(turretInst), 0.0f, 0.0f, new ColorObj(0.87f, 0.45f, 1.0f, Math.max(progress, 0.015686275f)).getColorInt(), false);
    }

    private static String getLabel(ITurretInst turretInst) {
        ShieldPersonal shield = (ShieldPersonal)turretInst.getUpgradeProcessor().getUpgradeInstance(Upgrades.SHIELD_PERSONAL.getId());
        if (shield.isInRecovery()) {
            return LangUtils.translate((LangUtils.TranslateKey)Lang.TCU_LABEL_PRSSHIELD_RECV, (Object[])new Object[]{String.format("%.0f %%", Float.valueOf(shield.getRecoveryPercentage()))});
        }
        return LangUtils.translate((LangUtils.TranslateKey)Lang.TCU_LABEL_PRSSHIELD, (Object[])new Object[]{String.format("%.2f/%.2f", Float.valueOf(shield.getValue()), Float.valueOf(20.0f))});
    }
}

