/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.label;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelElement;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.init.ClientProxy;
import de.sanandrew.mods.turretmod.registry.Lang;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.Forcefield;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;

public class LabelTurretShield
implements ILabelElement {
    @Override
    public boolean showElement(ITurretInst turretInst) {
        return turretInst.getTurret() instanceof TurretForcefield;
    }

    @Override
    public float getHeight(ITurretInst turretInst, FontRenderer fontRenderer) {
        return (float)fontRenderer.field_78288_b + 6.0f;
    }

    @Override
    public float getWidth(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return stdFontRenderer.func_78256_a(LabelTurretShield.getLabel(turretInst));
    }

    @Override
    public void renderQuads(ITurretInst turretInst, float maxWidth, float progress, FontRenderer fontRenderer, float currHeight, BufferBuilder buffer) {
        Forcefield shield = (Forcefield)turretInst.getRAM(null);
        float shieldPerc = shield == null ? 0.0f : shield.getValue() / shield.getMaxValue() * maxWidth;
        LabelTurretShield.addQuad(buffer, 0.0, currHeight += (float)fontRenderer.field_78288_b + 2.0f, shieldPerc, (double)currHeight + 2.0, new ColorObj(1.0f, 1.0f, 0.0f, Math.max(progress, 0.015686275f)));
        LabelTurretShield.addQuad(buffer, shieldPerc, currHeight, maxWidth, (double)currHeight + 2.0, new ColorObj(0.4f, 0.4f, 0.0f, Math.max(progress, 0.015686275f)));
    }

    @Override
    public void renderTextured(ITurretInst turretInst, float maxWidth, float progress, FontRenderer fontRenderer) {
        fontRenderer.func_175065_a(LabelTurretShield.getLabel(turretInst), 0.0f, 0.0f, new ColorObj(1.0f, 1.0f, 0.0f, Math.max(progress, 0.015686275f)).getColorInt(), false);
    }

    private static String getLabel(ITurretInst turretInst) {
        Forcefield shield = (Forcefield)turretInst.getRAM(null);
        if (shield != null) {
            if (shield.isInRecovery()) {
                return LangUtils.translate((LangUtils.TranslateKey)Lang.TCU_LABEL_TURRETSHIELD_RECV, (Object[])new Object[]{String.format("%.0f %%", Float.valueOf(shield.getRecovery() * 100.0f))});
            }
            return LangUtils.translate((LangUtils.TranslateKey)Lang.TCU_LABEL_TURRETSHIELD, (Object[])new Object[]{String.format("%.2f/%.2f", Float.valueOf(shield.getValue()), Float.valueOf(shield.getMaxValue()))});
        }
        return "";
    }

    private static void addQuad(BufferBuilder buf, double minX, double minY, double maxX, double maxY, ColorObj clr) {
        ClientProxy.addQuad(buf, minX, minY, maxX, maxY, clr, clr);
    }
}

