/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.page;

import com.google.common.base.Strings;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Button;
import de.sanandrew.mods.sanlib.lib.client.gui.element.TextField;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.smarttargeting.AdvTargetSettings;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class GuiSmartTargets
implements IGuiTCU {
    private static final int TURRET_IGNORE = 0;
    private static final int TURRET_CHECK_SAME = 1;
    private static final int TURRET_CHECK_ALL = 2;
    private static final int TAMED_ALL = 3;
    private static final int TAMED_PLAYERS = 4;
    private static final int TAMED_NONE = 5;
    private static final int CHILD_AND_ADULT = 6;
    private static final int CHILD_ONLY = 7;
    private static final int ADULT_ONLY = 8;
    private static final int NO_COUNT = 9;
    private static final int COUNT_GLOBAL_LESS = 10;
    private static final int COUNT_GLOBAL_MORE = 11;
    private static final int COUNT_INDIV_LESS = 12;
    private static final int COUNT_INDIV_MORE = 13;
    private Button turretIgnore;
    private Button turretCheckSame;
    private Button turretCheckAll;
    private Button tamedAll;
    private Button tamedPlayers;
    private Button tamedNone;
    private Button childAndAdult;
    private Button childOnly;
    private Button adultOnly;
    private Button noCount;
    private Button countGlobalLess;
    private Button countGlobalMore;
    private Button countIndivLess;
    private Button countIndivMore;
    private TextField countEntities;

    @Override
    public void initialize(IGuiTcuInst<?> gui, GuiDefinition guiDefinition) {
        this.turretIgnore = (Button)guiDefinition.getElementById("turretIgnore").get(Button.class);
        this.turretCheckSame = (Button)guiDefinition.getElementById("turretCheckSame").get(Button.class);
        this.turretCheckAll = (Button)guiDefinition.getElementById("turretCheckAll").get(Button.class);
        this.tamedAll = (Button)guiDefinition.getElementById("tamedAll").get(Button.class);
        this.tamedPlayers = (Button)guiDefinition.getElementById("tamedPlayers").get(Button.class);
        this.tamedNone = (Button)guiDefinition.getElementById("tamedNone").get(Button.class);
        this.childAndAdult = (Button)guiDefinition.getElementById("childAdult").get(Button.class);
        this.childOnly = (Button)guiDefinition.getElementById("childOnly").get(Button.class);
        this.adultOnly = (Button)guiDefinition.getElementById("adultOnly").get(Button.class);
        this.noCount = (Button)guiDefinition.getElementById("noCount").get(Button.class);
        this.countGlobalLess = (Button)guiDefinition.getElementById("countGlobalLess").get(Button.class);
        this.countGlobalMore = (Button)guiDefinition.getElementById("countGlobalMore").get(Button.class);
        this.countIndivLess = (Button)guiDefinition.getElementById("countIndivLess").get(Button.class);
        this.countIndivMore = (Button)guiDefinition.getElementById("countIndivMore").get(Button.class);
        this.countEntities = (TextField)guiDefinition.getElementById("countEntities").get(TextField.class);
        this.countEntities.setMaxStringLength(3);
        this.countEntities.setValidator(s -> {
            if (Strings.isNullOrEmpty((String)s)) {
                return true;
            }
            Integer val = GuiSmartTargets.getInteger(s);
            return val != null && val >= 0 && val <= 256;
        });
        this.countEntities.setResponder(s -> {
            Integer val;
            AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
            if (settings != null && (val = GuiSmartTargets.getInteger(s)) != null) {
                settings.setCountEntities(val);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
            }
        });
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        if (settings != null) {
            this.countEntities.setText(String.format("%d", settings.getCountEntities()));
        }
    }

    @Override
    public void updateScreen(IGuiTcuInst<?> gui) {
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        if (settings != null) {
            AdvTargetSettings.TurretAwareness tra = settings.getTurretAwareness();
            this.turretIgnore.setEnabled(tra != AdvTargetSettings.TurretAwareness.UNAWARE);
            this.turretCheckSame.setEnabled(tra != AdvTargetSettings.TurretAwareness.SAME_TYPE);
            this.turretCheckAll.setEnabled(tra != AdvTargetSettings.TurretAwareness.ALL_TYPES);
            AdvTargetSettings.TamedAwareness tma = settings.getTamedAwareness();
            this.tamedAll.setEnabled(tma != AdvTargetSettings.TamedAwareness.UNAWARE);
            this.tamedPlayers.setEnabled(tma != AdvTargetSettings.TamedAwareness.TARGETED_PLAYERS);
            this.tamedNone.setEnabled(tma != AdvTargetSettings.TamedAwareness.IGNORE_ALL_TAMED);
            AdvTargetSettings.ChildAwareness cla = settings.getChildAwareness();
            this.childAndAdult.setEnabled(cla != AdvTargetSettings.ChildAwareness.UNAWARE);
            this.childOnly.setEnabled(cla != AdvTargetSettings.ChildAwareness.CHILDREN_ONLY);
            this.adultOnly.setEnabled(cla != AdvTargetSettings.ChildAwareness.ADULTS_ONLY);
            AdvTargetSettings.CountAwareness cna = settings.getCountAwareness();
            this.noCount.setEnabled(cna != AdvTargetSettings.CountAwareness.NO_COUNT);
            this.countGlobalLess.setEnabled(cna != AdvTargetSettings.CountAwareness.BELOW_GLOBAL);
            this.countGlobalMore.setEnabled(cna != AdvTargetSettings.CountAwareness.ABOVE_GLOBAL);
            this.countIndivLess.setEnabled(cna != AdvTargetSettings.CountAwareness.BELOW_INDIVIDUAL);
            this.countIndivMore.setEnabled(cna != AdvTargetSettings.CountAwareness.ABOVE_INDIVIDUAL);
            this.countEntities.setEnabled(cna != AdvTargetSettings.CountAwareness.NO_COUNT);
        }
    }

    @Override
    public ResourceLocation getGuiDefinition() {
        return Resources.GUI_STRUCT_TCU_TARGET_SMART.resource;
    }

    @Override
    public boolean onElementAction(IGuiTcuInst<?> gui, IGuiElement element, int action) {
        AdvTargetSettings settings = GuiSmartTargets.getSettings(gui);
        switch (action) {
            case 0: {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 1: {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.SAME_TYPE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 2: {
                settings.setTurretAwareness(AdvTargetSettings.TurretAwareness.ALL_TYPES);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 3: {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 4: {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.TARGETED_PLAYERS);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 5: {
                settings.setTamedAwareness(AdvTargetSettings.TamedAwareness.IGNORE_ALL_TAMED);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 6: {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.UNAWARE);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 7: {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.CHILDREN_ONLY);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 8: {
                settings.setChildAwareness(AdvTargetSettings.ChildAwareness.ADULTS_ONLY);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 9: {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.NO_COUNT);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 10: {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.BELOW_GLOBAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 11: {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.ABOVE_GLOBAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 12: {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.BELOW_INDIVIDUAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
            case 13: {
                settings.setCountAwareness(AdvTargetSettings.CountAwareness.ABOVE_INDIVIDUAL);
                GuiSmartTargets.syncSettings(gui.getTurretInst());
                return true;
            }
        }
        return false;
    }

    public static boolean showTab(IGuiTcuInst<?> gui) {
        return gui.hasPermision() && gui.getTurretInst().getUpgradeProcessor().hasUpgrade(Upgrades.SMART_TGT);
    }

    private static AdvTargetSettings getSettings(IGuiTcuInst<?> gui) {
        AdvTargetSettings settings = (AdvTargetSettings)gui.getTurretInst().getUpgradeProcessor().getUpgradeInstance(Upgrades.SMART_TGT.getId());
        if (settings == null) {
            ((GuiScreen)gui.getGui()).field_146297_k.field_71439_g.func_71053_j();
        }
        return settings;
    }

    private static void syncSettings(ITurretInst turretInst) {
        UpgradeRegistry.INSTANCE.syncWithServer(turretInst, Upgrades.SMART_TGT.getId());
    }

    private static Integer getInteger(String s) {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

