/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model;

import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.client.model.IListedItemMeshDefinition;
import de.sanandrew.mods.turretmod.client.model.item.MeshDefAmmoCartridge;
import de.sanandrew.mods.turretmod.client.render.tileentity.RenderElectrolyteGenerator;
import de.sanandrew.mods.turretmod.client.render.tileentity.RenderTurretAssembly;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="sapturretmod")
public final class ModelRegistry {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelRegistry.setStandardModel(ItemRegistry.TURRET_CONTROL_UNIT);
        ModelRegistry.setStandardModel(ItemRegistry.TURRET_INFO);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_FILTER);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_AUTO);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_SPEED);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_REDSTONE);
        ModelRegistry.setStandardModel(BlockRegistry.ELECTROLYTE_GENERATOR);
        ModelRegistry.setStandardModel((Block)BlockRegistry.TURRET_ASSEMBLY);
        ModelRegistry.setStandardModel(BlockRegistry.TURRET_CRATE);
        ItemRegistry.TURRET_PLACERS.forEach((rl, item) -> {
            ResourceLocation regName = Objects.requireNonNull(item.getRegistryName());
            ModelRegistry.setStandardModel(item, new ResourceLocation(regName.func_110624_b(), "turrets/" + regName.func_110623_a()));
        });
        ItemRegistry.TURRET_AMMO.forEach((rl, item) -> {
            ResourceLocation regName = Objects.requireNonNull(item.getRegistryName());
            ModelRegistry.setStandardModel(item, new ResourceLocation(regName.func_110624_b(), "ammo/" + regName.func_110623_a()));
        });
        ItemRegistry.TURRET_UPGRADES.forEach((rl, item) -> {
            ResourceLocation regName = Objects.requireNonNull(item.getRegistryName());
            ModelRegistry.setStandardModel(item, new ResourceLocation(regName.func_110624_b(), "upgrades/" + regName.func_110623_a()));
        });
        ItemRegistry.TURRET_REPAIRKITS.forEach((rl, item) -> {
            ResourceLocation regName = Objects.requireNonNull(item.getRegistryName());
            ModelRegistry.setStandardModel(item, new ResourceLocation(regName.func_110624_b(), "repair_kits/" + regName.func_110623_a()));
        });
        ModelRegistry.setCustomMeshModel(ItemRegistry.AMMO_CARTRIDGE, new MeshDefAmmoCartridge());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurretAssembly.class, (TileEntitySpecialRenderer)new RenderTurretAssembly());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityElectrolyteGenerator.class, (TileEntitySpecialRenderer)new RenderElectrolyteGenerator());
    }

    private static void setStandardModel(Item item) {
        ResourceLocation regName = item.getRegistryName();
        if (regName != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(regName, "inventory"));
        }
    }

    private static void setStandardModel(Item item, ResourceLocation modelLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(modelLocation, "inventory"));
    }

    private static void setStandardModel(Block item) {
        Item itm = Item.func_150898_a((Block)item);
        if (itm != Items.field_190931_a) {
            ModelRegistry.setStandardModel(itm);
        }
    }

    private static void setCustomMeshModel(Item item, IListedItemMeshDefinition mesher) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesher);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])mesher.getDefinedResources());
    }
}

