/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model.entity;

import de.sanandrew.mods.sanlib.lib.client.ModelJsonHandler;
import de.sanandrew.mods.sanlib.lib.client.ModelJsonLoader;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.Resources;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class ModelTurretBase
extends ModelBase
implements ModelJsonHandler<ModelTurretBase, ModelJsonLoader.ModelJson> {
    private ModelRenderer head;
    private ModelRenderer healthBar;
    private ModelRenderer ammoBar;
    private final ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> modelJson;
    private final float scale;
    private boolean isGlowing = false;

    public ModelTurretBase(float scale) {
        this(scale, Resources.TURRET_T1_BASE.resource);
    }

    public ModelTurretBase(float scale, ResourceLocation modelLocation) {
        this.scale = scale;
        this.modelJson = ModelJsonLoader.create((ModelBase)this, (ResourceLocation)modelLocation, (String[])this.getMandatoryBoxes().toArray(new String[0]));
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float rotFloat, float rotYaw, float rotPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, rotFloat, rotYaw, rotPitch, scale, entity);
        if (this.modelJson.isLoaded()) {
            float[] lmCoords = new float[]{OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY};
            Arrays.asList(this.modelJson.getMainBoxes()).forEach(box -> {
                if (this.isGlowing) {
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
                } else {
                    ITurretInst turret = (ITurretInst)entity;
                    int b = turret.getPartBrightnessForRender(ModelTurretBase.getSubmergedBoxOffset(box));
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(b % 65536), (float)((float)b / 65536.0f));
                }
                box.func_78785_a(scale);
            });
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lmCoords[0], (float)lmCoords[1]);
        }
    }

    private static double getSubmergedBoxOffset(ModelRenderer box) {
        if (box.field_78804_l.size() > 0) {
            ModelBox cube = (ModelBox)box.field_78804_l.get(0);
            return (23.0 - (double)box.field_78797_d - (double)box.field_82908_p - (double)cube.field_78250_b) / 16.0;
        }
        return (23.0 - (double)box.field_78797_d - (double)box.field_82908_p) / 16.0;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotFloat, float rotYaw, float rotPitch, float partTicks, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, rotFloat, rotYaw, rotPitch, partTicks, entity);
        this.head.field_78796_g = rotYaw / 57.295776f;
        this.head.field_78795_f = rotPitch / 57.295776f;
        ITurretInst turret = (ITurretInst)entity;
        float maxHealth = turret.isInGui() ? 2.0f : turret.get().func_110138_aP();
        float health = turret.isInGui() ? 1.0f : turret.get().func_110143_aJ();
        int maxAmmo = turret.isInGui() ? 2 : turret.getTargetProcessor().getMaxAmmoCapacity();
        int ammo = turret.isInGui() ? 1 : turret.getTargetProcessor().getAmmoCount();
        this.healthBar.field_78808_h = -1.5707964f * (Math.max(0.0f, maxHealth - health) / maxHealth);
        this.ammoBar.field_78808_h = 1.5707964f * (Math.max(0.0f, (float)(maxAmmo - ammo)) / (float)maxAmmo);
    }

    public void onReload(IResourceManager iResourceManager, ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> loader) {
        loader.load();
        this.head = loader.getBox("head");
        this.healthBar = loader.getBox("healthBar");
        this.ammoBar = loader.getBox("ammoBar");
    }

    public void setTexture(String s) {
    }

    public float getBaseScale() {
        return this.scale;
    }

    protected List<String> getMandatoryBoxes() {
        return Arrays.asList("head", "healthBar", "ammoBar");
    }

    public void setGlowing(boolean glowing) {
        this.isGlowing = glowing;
    }
}

