/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model.entity;

import de.sanandrew.mods.sanlib.lib.client.ModelJsonLoader;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.model.entity.ModelTurretBase;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.turret.TurretRevolver;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;

public class ModelTurretRevolver
extends ModelTurretBase {
    private ModelRenderer barrelLeft;
    private ModelRenderer barrelRight;

    public ModelTurretRevolver(float scale) {
        super(scale, Resources.TURRET_T2_REVOLVER_MODEL.resource);
    }

    public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partTicks) {
        super.func_78086_a(entity, limbSwing, limbSwingAmount, partTicks);
        ITurretInst turretInst = (ITurretInst)entity;
        if (turretInst.getTurret() instanceof TurretRevolver) {
            TurretRevolver.MyRAM ram = turretInst.getRAM(TurretRevolver.MyRAM::new);
            float barrelDeltaL = ram.prevBarrelLeft + (ram.barrelLeft - ram.prevBarrelLeft) * partTicks;
            float barrelDeltaR = ram.prevBarrelRight + (ram.barrelRight - ram.prevBarrelRight) * partTicks;
            this.barrelLeft.field_78798_e = 3.0f - 3.0f * barrelDeltaL;
            this.barrelRight.field_78798_e = 3.0f - 3.0f * barrelDeltaR;
        }
    }

    @Override
    public List<String> getMandatoryBoxes() {
        return Stream.concat(super.getMandatoryBoxes().stream(), Stream.of("barrelLeft", "barrelRight")).collect(Collectors.toList());
    }

    @Override
    public void onReload(IResourceManager iResourceManager, ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> loader) {
        super.onReload(iResourceManager, loader);
        this.barrelLeft = loader.getBox("barrelLeft");
        this.barrelRight = loader.getBox("barrelRight");
    }
}

