/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.projectile;

import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.client.render.IRender;
import de.sanandrew.mods.turretmod.api.client.render.IRenderInst;
import de.sanandrew.mods.turretmod.api.client.render.IRenderRegistry;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderBullet;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderCrossbowBolt;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderFlame;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderNothingness;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderPebble;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.registry.projectile.Projectiles;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RenderProjectile
extends Render<EntityTurretProjectile>
implements IRenderRegistry<ResourceLocation, EntityTurretProjectile, IRender<EntityTurretProjectile>>,
IRenderInst<EntityTurretProjectile> {
    private final Map<ResourceLocation, IRender<EntityTurretProjectile>> renders = new HashMap<ResourceLocation, IRender<EntityTurretProjectile>>();

    public RenderProjectile(RenderManager renderManager) {
        super(renderManager);
        TurretModRebirth.PLUGINS.forEach(plugin -> plugin.registerProjectileRenderer(this));
    }

    public void doRender(EntityTurretProjectile entity, double x, double y, double z, float entityYaw, float partialTicks) {
        ResourceLocation delegateId = entity.delegate.getId();
        if (this.renders.containsKey(delegateId)) {
            this.renders.get(delegateId).doRender(this, entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityTurretProjectile entity) {
        if (this.renders.containsKey(entity.delegate.getId())) {
            return this.renders.get(entity.delegate.getId()).getRenderTexture(entity);
        }
        return null;
    }

    @Override
    public boolean register(@Nonnull ResourceLocation key, @Nonnull IRender<EntityTurretProjectile> render) {
        if (this.renders.containsKey(key)) {
            TmrConstants.LOG.log(Level.WARN, String.format("Cannot register renderer for projectile ID %s since it already has one.", key));
            return false;
        }
        this.renders.put(key, render);
        return true;
    }

    @Override
    public IRender<EntityTurretProjectile> remove(ResourceLocation key) {
        return this.renders.remove(key);
    }

    @Override
    public Render<?> getRenderer() {
        return this;
    }

    @Override
    public boolean bindRenderEntityTexture(EntityTurretProjectile entity) {
        return this.func_180548_c(entity);
    }

    @Override
    public boolean renderOutlines() {
        return this.field_188301_f;
    }

    @Override
    public Render<?> getRender() {
        return this;
    }

    @Override
    public int getRenderTeamColor(EntityTurretProjectile entity) {
        return this.func_188298_c(entity);
    }

    public static <T extends Entity> void initialize(IRenderRegistry<ResourceLocation, T, IRender<T>> registry) {
        registry.register(Projectiles.CB_BOLT.getId(), new RenderCrossbowBolt());
        registry.register(Projectiles.HARPOON.getId(), new RenderCrossbowBolt());
        registry.register(Projectiles.PEBBLE.getId(), new RenderPebble());
        registry.register(Projectiles.CRYO_BALL_I.getId(), new RenderNothingness());
        registry.register(Projectiles.CRYO_BALL_II.getId(), new RenderNothingness());
        registry.register(Projectiles.CRYO_BALL_III.getId(), new RenderNothingness());
        registry.register(Projectiles.BULLET.getId(), new RenderBullet());
        registry.register(Projectiles.MG_PEBBLE.getId(), new RenderPebble());
        registry.register(Projectiles.LASER_NORMAL.getId(), new RenderNothingness());
        registry.register(Projectiles.FLAME_NORMAL.getId(), new RenderFlame(false));
        registry.register(Projectiles.FLAME_PURIFY.getId(), new RenderFlame(true));
    }
}

