/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.tileentity;

import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteProcess;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class RenderElectrolyteGenerator
extends TileEntitySpecialRenderer<TileEntityElectrolyteGenerator> {
    private static int wireCallList;

    public void render(TileEntityElectrolyteGenerator tile, double x, double y, double z, float partTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        int max = tile.processes.length;
        for (int i = 0; i < max; ++i) {
            ElectrolyteProcess proc = tile.processes[i];
            if (proc == null) continue;
            RenderElectrolyteGenerator.drawElectrolyteItem(i, proc.processStack);
        }
        GlStateManager.func_179121_F();
    }

    private static void drawElectrolyteItem(int index, @Nonnull ItemStack stack) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(40.0f * (float)index), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.4f, (float)0.0f, (float)0.0f);
        int max = 3;
        for (int i = 0; i < max; ++i) {
            RenderUtils.renderStackInWorld((ItemStack)stack, (double)0.0, (double)(1.0E-4 * (double)i), (double)0.0, (float)0.0f, (float)(180.0f / (float)max * (float)i), (float)0.0f, (double)0.3);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.TILE_ELECTROLYTE_GEN_WIRE.resource);
        RenderElectrolyteGenerator.drawParaboleWire();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private static void drawParaboleWire() {
        int steps2 = 10;
        if (wireCallList == 0) {
            int i;
            double scale = 0.01;
            double perpendAngle = 1.5707963267948966;
            Vec3d[] builtVecMain = new Vec3d[11];
            Vec3d[] builtVecA = new Vec3d[11];
            Vec3d[] builtVecB = new Vec3d[11];
            for (i = 0; i <= 10; ++i) {
                double x = (double)i / 10.0;
                double y = Math.pow(x, 4.0);
                builtVecMain[i] = new Vec3d(x * -0.35, y * -0.49, 0.0);
                builtVecA[i] = builtVecMain[i].func_186678_a(1.0);
                builtVecB[i] = builtVecMain[i].func_186678_a(1.0);
            }
            builtVecA[0] = builtVecMain[0].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(builtVecMain[1].func_178788_d(builtVecMain[0]).func_72432_b().func_186678_a(scale), 1.5707963267948966));
            builtVecB[0] = builtVecMain[0].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(builtVecMain[1].func_178788_d(builtVecMain[0]).func_72432_b().func_186678_a(scale), -1.5707963267948966));
            for (i = 1; i < builtVecA.length - 1; ++i) {
                Vec3d vecBtwPre = builtVecMain[i].func_178788_d(builtVecMain[i - 1]);
                Vec3d vecBtwPost = builtVecMain[i + 1].func_178788_d(builtVecMain[i]);
                double btwAngle = Math.acos(Math.min(vecBtwPre.func_72430_b(vecBtwPost) / vecBtwPre.func_189985_c(), 1.0));
                builtVecA[i] = builtVecMain[i].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(vecBtwPre.func_72432_b().func_186678_a(scale), 1.5707963267948966 + btwAngle / 2.0));
                builtVecB[i] = builtVecMain[i].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(vecBtwPre.func_72432_b().func_186678_a(scale), -1.5707963267948966 - btwAngle / 2.0));
            }
            Vec3d vecBtw = builtVecMain[builtVecMain.length - 1].func_178788_d(builtVecMain[builtVecMain.length - 2]).func_72432_b().func_186678_a(scale);
            builtVecA[builtVecA.length - 1] = builtVecMain[builtVecMain.length - 1].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(vecBtw, 1.5707963267948966));
            builtVecB[builtVecA.length - 1] = builtVecMain[builtVecMain.length - 1].func_178787_e(RenderElectrolyteGenerator.rotateVecXY(vecBtw, -1.5707963267948966));
            wireCallList = GlStateManager.func_187442_t((int)1);
            if (wireCallList == 0) {
                return;
            }
            GlStateManager.func_187423_f((int)wireCallList, (int)4864);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i2 = 0; i2 < builtVecA.length - 1; ++i2) {
                double u = Math.abs(builtVecA[i2 + 1].func_178788_d(builtVecA[i2]).func_72433_c()) * 4.5;
                buf.func_181662_b(builtVecA[i2].field_72450_a, builtVecA[i2].field_72448_b, -scale).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(builtVecA[i2 + 1].field_72450_a, builtVecA[i2 + 1].field_72448_b, -scale).func_187315_a(u, 1.0).func_181675_d();
                buf.func_181662_b(builtVecB[i2 + 1].field_72450_a, builtVecB[i2 + 1].field_72448_b, scale).func_187315_a(u, 0.0).func_181675_d();
                buf.func_181662_b(builtVecB[i2].field_72450_a, builtVecB[i2].field_72448_b, scale).func_187315_a(0.0, 0.0).func_181675_d();
                buf.func_181662_b(builtVecA[i2].field_72450_a, builtVecA[i2].field_72448_b, scale).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(builtVecA[i2 + 1].field_72450_a, builtVecA[i2 + 1].field_72448_b, scale).func_187315_a(u, 1.0).func_181675_d();
                buf.func_181662_b(builtVecB[i2 + 1].field_72450_a, builtVecB[i2 + 1].field_72448_b, -scale).func_187315_a(u, 0.0).func_181675_d();
                buf.func_181662_b(builtVecB[i2].field_72450_a, builtVecB[i2].field_72448_b, -scale).func_187315_a(0.0, 0.0).func_181675_d();
            }
            tess.func_78381_a();
            GlStateManager.func_187415_K();
        }
        GlStateManager.func_179148_o((int)wireCallList);
    }

    private static void delWireCallList() {
        GlStateManager.func_187449_e((int)wireCallList, (int)0);
        wireCallList = 0;
    }

    private static Vec3d rotateVecXY(Vec3d vec, double yaw) {
        double cos = Math.cos(yaw);
        double sin = Math.sin(yaw);
        double d0 = vec.field_72450_a * cos - vec.field_72448_b * sin;
        double d1 = vec.field_72448_b * cos + vec.field_72450_a * sin;
        double d2 = vec.field_72449_c;
        return new Vec3d(d0, d1, d2);
    }
}

