/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.world;

import de.sanandrew.mods.sanlib.lib.XorShiftRandom;
import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.event.RenderEventHandler;
import de.sanandrew.mods.turretmod.registry.Resources;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderTurretCam {
    private static final long MAX_UPDATE_TIME_NS = 1000000000L;
    private static final WeakHashMap<ITurretInst, CamEntry> TURRETS = new WeakHashMap();
    private static long renderEndNanoTime;
    private static final XorShiftRandom RNG;

    public static void bindTurretCamTx(ITurretInst turret, int quality) {
        CamEntry entry = TURRETS.get(turret);
        if (entry == null) {
            entry = new CamEntry(quality);
            TURRETS.put(turret, entry);
        } else {
            entry.active = true;
        }
        if (entry.active) {
            GlStateManager.func_179144_i((int)entry.textureId);
        }
    }

    public static void drawTurretCam(ITurretInst turretInst, int quality, int x, int y, int width, int height) {
        if (turretInst.isActive()) {
            RenderTurretCam.bindTurretCamTx(turretInst, quality);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(0.00390625f * (float)width), (float)(0.00390625f * (float)height), (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)-256, (int)-256, (float)0.0f, (int)0, (int)0, (int)256, (int)256);
            GlStateManager.func_179121_F();
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.GUI_TCU_CAM_NA.resource);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)(0.00390625f * (float)width), (float)(0.015625f * (float)height), (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (float)0.0f, (int)0, (int)(64 * RNG.randomInt(3)), (int)256, (int)64);
            GlStateManager.func_179121_F();
        }
    }

    public static void render(Minecraft mc, float renderTickTime) {
        GuiScreen prevDisplayedGui = null;
        if (mc.field_71441_e == null) {
            return;
        }
        if (TURRETS.size() > 0) {
            if (!mc.field_71415_G) {
                prevDisplayedGui = mc.field_71462_r;
                mc.field_71462_r = null;
                mc.field_71415_G = true;
            }
            RenderTurretCam.cleanupRenderers(false);
            TURRETS.forEach((turret, camEntry) -> {
                long updTime;
                if (turret != null && (updTime = System.nanoTime()) - ((CamEntry)camEntry).lastUpdTime > 1000000000L) {
                    EntityLiving turretL = turret.get();
                    GameSettings settings = mc.field_71474_y;
                    Entity entityBkp = mc.func_175606_aa();
                    int thirdPersonBkp = settings.field_74320_O;
                    boolean hideGuiBkp = settings.field_74319_N;
                    int mipmapBkp = settings.field_151442_I;
                    float fovBkp = settings.field_74334_X;
                    int widthBkp = mc.field_71443_c;
                    int heightBkp = mc.field_71440_d;
                    float turretPrevYawBkp = turretL.field_70126_B;
                    float turretYawBkp = turretL.field_70177_z;
                    float turretPitchBkp = turretL.field_70125_A;
                    float turretPrevPitchBkp = turretL.field_70127_C;
                    double turretPosYBkp = turretL.field_70163_u;
                    double turretPrevPosYBkp = turretL.field_70167_r;
                    double turretLTPosYBkp = turretL.field_70137_T;
                    mc.func_175607_a((Entity)turretL);
                    settings.field_74334_X = 100.0f;
                    settings.field_74320_O = 0;
                    settings.field_74319_N = true;
                    settings.field_151442_I = 0;
                    mc.field_71443_c = ((CamEntry)camEntry).quality;
                    mc.field_71440_d = ((CamEntry)camEntry).quality;
                    RenderEventHandler.renderPlayer = true;
                    RenderEventHandler.renderEntity = mc.field_71439_g;
                    turretL.field_70177_z = turretL.field_70759_as;
                    turretL.field_70126_B = turretL.field_70758_at;
                    int fps = Math.min(Minecraft.func_175610_ah(), mc.field_71474_y.field_74350_i);
                    fps = Math.max(fps, 60);
                    long timeDelta = updTime - renderEndNanoTime;
                    long timeDeltaFps = Math.max((long)(1000000000 / fps / 4) - timeDelta, 0L);
                    mc.field_71460_t.func_78471_a(renderTickTime, System.nanoTime() + timeDeltaFps);
                    GlStateManager.func_179144_i((int)((CamEntry)camEntry).textureId);
                    GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)((CamEntry)camEntry).quality, (int)((CamEntry)camEntry).quality, (int)0);
                    renderEndNanoTime = System.nanoTime();
                    turretL.field_70163_u = turretPosYBkp;
                    turretL.field_70167_r = turretPrevPosYBkp;
                    turretL.field_70137_T = turretLTPosYBkp;
                    turretL.field_70177_z = turretYawBkp;
                    turretL.field_70126_B = turretPrevYawBkp;
                    turretL.field_70125_A = turretPitchBkp;
                    turretL.field_70127_C = turretPrevPitchBkp;
                    RenderEventHandler.renderEntity = null;
                    RenderEventHandler.renderPlayer = false;
                    mc.func_175607_a(entityBkp);
                    settings.field_74334_X = fovBkp;
                    settings.field_74320_O = thirdPersonBkp;
                    settings.field_74319_N = hideGuiBkp;
                    settings.field_151442_I = mipmapBkp;
                    mc.field_71443_c = widthBkp;
                    mc.field_71440_d = heightBkp;
                    ((CamEntry)camEntry).lastUpdTime = updTime;
                }
                ((CamEntry)camEntry).active = false;
            });
            if (prevDisplayedGui != null) {
                mc.field_71462_r = prevDisplayedGui;
                mc.field_71415_G = false;
            }
        }
    }

    public static void cleanupRenderers(boolean clearAll) {
        TURRETS.forEach((turret, camEntry) -> {
            if (clearAll) {
                ((CamEntry)camEntry).active = false;
            }
            if (!((CamEntry)camEntry).active) {
                GL11.glDeleteTextures((int)((CamEntry)camEntry).textureId);
            }
        });
        TURRETS.entrySet().removeIf(entry -> entry.getKey() == null || entry.getValue() == null || !((CamEntry)entry.getValue()).active);
    }

    static {
        RNG = new XorShiftRandom();
    }

    private static class CamEntry {
        private final int quality;
        private final int textureId = GL11.glGenTextures();
        private boolean active = true;
        private long lastUpdTime = 0L;

        private CamEntry(int quality) {
            this.quality = quality;
            GlStateManager.func_179144_i((int)this.textureId);
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)quality, (int)quality, (int)0, (int)6407, (int)5121, (ByteBuffer)BufferUtils.createByteBuffer((int)(3 * quality * quality)));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
    }
}

