/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.assembly.AssemblyIngredient;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.compat.crafttweaker.CTHandler;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.sapturretmod.TurretAssembly")
@ZenRegister
@ModOnly(value="sapturretmod")
public class CTAssembly {
    public static List<IAction> ACTIONS_PRE = new LinkedList<IAction>();
    public static List<IAction> ACTIONS_POST = new LinkedList<IAction>();
    private static int ctId = 0;

    @ZenMethod
    public static void removeAllRecipes() {
        CTAssembly.removeAllRecipes(null);
    }

    @ZenMethod
    public static void removeAllRecipes(final String group) {
        ACTIONS_PRE.add(new IAction(){

            public void apply() {
                if (group != null) {
                    AssemblyManager.INSTANCE.clearRecipesByGroup(group);
                } else {
                    AssemblyManager.INSTANCE.clearRecipes();
                }
            }

            public String describe() {
                return "Removing all Turret Assembly Table recipes" + (group != null ? " within group " + group : "");
            }
        });
    }

    @ZenMethod
    public static void removeRecipeByName(String id) {
        final ResourceLocation idRL = CTHandler.getRL(id);
        ACTIONS_PRE.add(new IAction(){

            public void apply() {
                if (AssemblyManager.INSTANCE.getRecipe(idRL) == null) {
                    CraftTweakerAPI.logError((String)("Failed to remove Turret Assembly Table recipe with name " + idRL.toString()));
                }
                AssemblyManager.INSTANCE.removeRecipe(idRL);
            }

            public String describe() {
                return "Removing Turret Assembly Table recipe with name " + idRL.toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipesByOutput(IItemStack output) {
        CTAssembly.removeRecipesByOutput(output, null);
    }

    @ZenMethod
    public static void removeRecipesByOutput(final IItemStack output, final String group) {
        final ItemStack outputInst = CraftTweakerMC.getItemStack((IItemStack)output);
        final Function<String, List> grabRecipes = gn -> {
            if (gn != null) {
                return AssemblyManager.INSTANCE.getRecipes((String)gn);
            }
            return AssemblyManager.INSTANCE.getRecipes();
        };
        ACTIONS_PRE.add(new IAction(){

            public void apply() {
                int oldSz = ((List)grabRecipes.apply(group)).size();
                new ArrayList<IAssemblyRecipe>((Collection)grabRecipes.apply(group)).forEach(r -> {
                    if (ItemStackUtils.areEqual((ItemStack)outputInst, (ItemStack)r.getRecipeOutput(), (boolean)outputInst.func_77942_o())) {
                        AssemblyManager.INSTANCE.removeRecipe(r.getId());
                    }
                });
                if (oldSz == ((List)grabRecipes.apply(group)).size()) {
                    CraftTweakerAPI.logError((String)("Failed to remove Turret Assembly Table recipe with input " + output.toString() + (group != null ? " within group " + group : "")));
                }
            }

            public String describe() {
                return "Removing Turret Assembly Table recipe with input " + output.toString() + (group != null ? " within group " + group : "");
            }
        });
    }

    @ZenMethod
    public static void addRecipe(String id, String group, IIngredient[] inputs, IItemStack output, int fluxPerTick, int processTime) {
        CTAssembly.registerRecipeH(CTHandler.getRL(id), group, inputs, output, fluxPerTick, processTime);
    }

    @ZenMethod
    public static void addRecipe(String group, IIngredient[] inputs, IItemStack output, int fluxPerTick, int processTime) {
        CTAssembly.registerRecipeH(CTAssembly.buildCtId(), group, inputs, output, fluxPerTick, processTime);
    }

    @ZenMethod
    public static void setGroupIcon(final String group, IItemStack item) {
        final ItemStack itemInst = CraftTweakerMC.getItemStack((IItemStack)item);
        ACTIONS_POST.add(new IAction(){

            public void apply() {
                AssemblyManager.INSTANCE.setGroupIcon(group, itemInst);
            }

            public String describe() {
                return "Set Turret Assembly Table group icon to " + itemInst.toString() + " for group " + group;
            }
        });
    }

    @ZenMethod
    public static void setGroupOrder(final String group, final int ordinal) {
        ACTIONS_POST.add(new IAction(){

            public void apply() {
                AssemblyManager.INSTANCE.setGroupOrder(group, ordinal);
            }

            public String describe() {
                return "Setting Turret Assembly Table group order to " + ordinal + " for group " + group;
            }
        });
    }

    private static ResourceLocation buildCtId() {
        return new ResourceLocation("crafttweaker", String.format("ct_saaembly_%d", ++ctId));
    }

    private static void registerRecipeH(final ResourceLocation id, final String group, IIngredient[] inputs, IItemStack output, final int fluxPerTick, final int processTime) {
        final NonNullList inputsInst = NonNullList.func_191196_a();
        final ItemStack outputInst = CraftTweakerMC.getItemStack((IItemStack)output);
        Arrays.stream(inputs).forEach(i -> inputsInst.add((Object)new AssemblyIngredient(i.getAmount(), (ItemStack[])Arrays.stream(i.getItemArray()).map(CraftTweakerMC::getItemStack).toArray(ItemStack[]::new))));
        ACTIONS_PRE.add(new IAction(){

            public void apply() {
                try {
                    AssemblyManager.INSTANCE.registerRecipe(new AssemblyRecipe(id, group, (NonNullList<Ingredient>)inputsInst, fluxPerTick, processTime, outputInst), true);
                }
                catch (RuntimeException ex) {
                    CraftTweakerAPI.logError((String)ex.getMessage());
                }
            }

            public String describe() {
                return "Adding Turret Assembly Table recipe <" + id.toString() + ">";
            }
        });
    }
}

