/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import de.sanandrew.mods.turretmod.compat.crafttweaker.CTHandler;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteManager;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.sapturretmod.ElectrolyteGenerator")
@ZenRegister
@ModOnly(value="sapturretmod")
public class CTElectrolyte {
    public static List<IAction> ACTIONS = new LinkedList<IAction>();
    private static int ctId = 0;

    @ZenMethod
    public static void removeAllFuels() {
        ACTIONS.add(new IAction(){

            public void apply() {
                ElectrolyteManager.INSTANCE.clearFuels();
            }

            public String describe() {
                return "Removing all Electrolyte Generator recipes";
            }
        });
    }

    @ZenMethod
    public static void removeFuelByName(String id) {
        final ResourceLocation idRL = CTHandler.getRL(id);
        ACTIONS.add(new IAction(){

            public void apply() {
                if (ElectrolyteManager.INSTANCE.getFuel(idRL) == null) {
                    CraftTweakerAPI.logError((String)("Failed to remove Electrolyte Generator recipe with name " + idRL.toString()));
                }
                ElectrolyteManager.INSTANCE.removeFuel(idRL);
            }

            public String describe() {
                return "Removing Electrolyte Generator recipe with name " + idRL.toString();
            }
        });
    }

    @ZenMethod
    public static void removeFuelsByInput(final IIngredient input) {
        final Ingredient inputInst = CraftTweakerMC.getIngredient((IIngredient)input);
        ACTIONS.add(new IAction(){

            public void apply() {
                ItemStack[] matchingStacks = inputInst.func_193365_a();
                int oldSz = ElectrolyteManager.INSTANCE.getFuels().size();
                new ArrayList<IElectrolyteRecipe>(ElectrolyteManager.INSTANCE.getFuels()).forEach(r -> {
                    if (r.getIngredients().stream().anyMatch(i -> Arrays.stream(matchingStacks).anyMatch(arg_0 -> ((Ingredient)i).apply(arg_0)))) {
                        ElectrolyteManager.INSTANCE.removeFuel(r.getId());
                    }
                });
                if (oldSz == ElectrolyteManager.INSTANCE.getFuels().size()) {
                    CraftTweakerAPI.logError((String)("Failed to remove Electrolyte Generator recipe with input " + input.toString()));
                }
            }

            public String describe() {
                return "Removing Electrolyte Generator recipe with input " + input.toString();
            }
        });
    }

    @ZenMethod
    public static void addFuel(IIngredient input, IItemStack trash, IItemStack treasure, float efficiency, int processingTime) {
        CTElectrolyte.registerFuelH(CTElectrolyte.buildCtId(), input, trash, null, treasure, null, efficiency, processingTime);
    }

    @ZenMethod
    public static void addFuel(IIngredient input, IItemStack trash, float trashChance, IItemStack treasure, float treasureChance, float efficiency, int processingTime) {
        CTElectrolyte.registerFuelH(CTElectrolyte.buildCtId(), input, trash, Float.valueOf(trashChance), treasure, Float.valueOf(treasureChance), efficiency, processingTime);
    }

    @ZenMethod
    public static void addFuel(String id, IIngredient input, IItemStack trash, IItemStack treasure, float efficiency, int processingTime) {
        CTElectrolyte.registerFuelH(CTHandler.getRL(id), input, trash, null, treasure, null, efficiency, processingTime);
    }

    @ZenMethod
    public static void addFuel(String id, IIngredient input, IItemStack trash, float trashChance, IItemStack treasure, float treasureChance, float efficiency, int processingTime) {
        CTElectrolyte.registerFuelH(CTHandler.getRL(id), input, trash, Float.valueOf(trashChance), treasure, Float.valueOf(treasureChance), efficiency, processingTime);
    }

    private static ResourceLocation buildCtId() {
        return new ResourceLocation("crafttweaker", String.format("ct_elec_%d", ++ctId));
    }

    private static void registerFuelH(final ResourceLocation id, IIngredient input, IItemStack trash, final Float trashChance, IItemStack treasure, final Float treasureChance, final float efficiency, final int processingTime) {
        final Ingredient inputInst = CraftTweakerMC.getIngredient((IIngredient)input);
        final ItemStack trashInst = CraftTweakerMC.getItemStack((IItemStack)trash);
        final ItemStack treasureInst = CraftTweakerMC.getItemStack((IItemStack)treasure);
        ACTIONS.add(new IAction(){

            public void apply() {
                ElectrolyteRecipe recipe = trashChance == null || treasureChance == null ? new ElectrolyteRecipe(id, inputInst, trashInst, treasureInst, efficiency, processingTime) : new ElectrolyteRecipe(id, inputInst, trashInst, treasureInst, efficiency, processingTime, trashChance.floatValue(), treasureChance.floatValue());
                ElectrolyteManager.INSTANCE.registerFuel(recipe);
            }

            public String describe() {
                return "Adding Electrolyte Generator recipe <" + id.toString() + ">";
            }
        });
    }
}

