/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.compat.jei;

import com.google.common.collect.ImmutableList;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.registry.Lang;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
class AssemblyRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final List<ItemStack> output;
    private final int fluxPerTick;
    private final int timeInTicks;

    AssemblyRecipeWrapper(IAssemblyRecipe recipe) {
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        for (Ingredient item : recipe.getIngredients()) {
            inputBuilder.add(Arrays.asList(item.func_193365_a()));
        }
        this.input = inputBuilder.build();
        this.fluxPerTick = recipe.getFluxPerTick();
        this.timeInTicks = recipe.getProcessTime();
        this.output = ImmutableList.of((Object)recipe.getRecipeOutput());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.input);
        ingredients.setOutputs(ItemStack.class, this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = LangUtils.translate((LangUtils.TranslateKey)Lang.JEI_ASSEMBLY_ENERGY, (Object[])new Object[0]) + ' ' + this.fluxPerTick * this.timeInTicks + " RF";
        minecraft.field_71466_p.func_78276_b(s, 0, 90, -8355712);
        s = LangUtils.translate((LangUtils.TranslateKey)Lang.JEI_ASSEMBLY_TIME, (Object[])new Object[0]) + ' ' + MiscUtils.getTimeFromTicks((int)this.timeInTicks);
        minecraft.field_71466_p.func_78276_b(s, 0, 100, -8355712);
    }
}

