/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import com.mojang.authlib.GameProfile;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.repairkit.IRepairKit;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.entity.turret.DataWatcherBooleans;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.item.ItemRemapper;
import de.sanandrew.mods.turretmod.item.ItemTurret;
import de.sanandrew.mods.turretmod.item.ItemTurretControlUnit;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateTurretState;
import de.sanandrew.mods.turretmod.registry.Sounds;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.tileentity.TileEntityTurretCrate;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTurret
extends EntityLiving
implements IEntityAdditionalSpawnData,
ITurretInst {
    private static final AxisAlignedBB UPWARDS_BLOCK = new AxisAlignedBB(0.1, 0.99, 0.1, 1.0, 1.0, 1.0);
    private static final DataParameter<Boolean> SHOT_CHNG = EntityDataManager.func_187226_a(EntityTurret.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> VARIANT = EntityDataManager.func_187226_a(EntityTurret.class, (DataSerializer)DataSerializers.field_187194_d);
    private boolean showRange;
    public boolean inGui;
    private final TargetProcessor targetProc = new TargetProcessor(this);
    private final UpgradeProcessor upgProc = new UpgradeProcessor(this);
    private UUID ownerUUID;
    private String ownerName;
    private DataWatcherBooleans<EntityTurret> dwBools;
    private boolean prevShotChng;
    private ITurretRAM turretRAM;
    @Nonnull
    private ITurret delegate;

    public EntityTurret(World world) {
        super(world);
        this.field_70177_z = 0.0f;
        this.delegate = TurretRegistry.INSTANCE.getDefaultObject();
    }

    public EntityTurret(World world, ITurret delegate) {
        this(world);
        this.loadDelegate(delegate);
        this.func_70606_j(this.func_110138_aP());
    }

    public EntityTurret(World world, EntityPlayer owner, ITurret delegate) {
        this(world, delegate);
        this.ownerUUID = owner.func_110124_au();
        this.ownerName = owner.func_70005_c_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_AMMO_CAPACITY);
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_RELOAD_TICKS);
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_INIT_SHOOT_TICKS);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.dwBools = new DataWatcherBooleans<EntityTurret>(this);
        this.dwBools.registerDwValue();
        this.field_70180_af.func_187214_a(SHOT_CHNG, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)"");
        this.setActive(true);
    }

    protected SoundEvent func_184601_bQ(DamageSource dmgSrc) {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getHurtSound(this), (Object)Sounds.HIT_TURRETHIT);
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getDeathSound(this), (Object)Sounds.HIT_TURRETDEATH);
    }

    private SoundEvent getCollectSound() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getCollectSound(this), (Object)Sounds.COLLECT_IA_GET);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70625_a(Entity entity, float yawSpeed, float pitchSpeed) {
        double deltaY;
        double deltaX = entity.field_70165_t - this.field_70165_t;
        double deltaZ = entity.field_70161_v - this.field_70161_v;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            deltaY = livingBase.field_70163_u + (double)livingBase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            deltaY = (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double distVecXZ = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float yawRotation = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - 90.0f;
        float pitchRotation = (float)(-(Math.atan2(deltaY, distVecXZ) * 180.0 / Math.PI));
        this.field_70125_A = EntityTurret.calcRotation(this.field_70125_A, pitchRotation);
        this.field_70759_as = EntityTurret.calcRotation(this.field_70759_as, yawRotation);
    }

    public float func_70047_e() {
        return this.delegate.getEyeHeight(this.field_70131_O);
    }

    public void func_70034_d(float rotation) {
    }

    private static float calcRotation(float prevRotation, float newRotation) {
        float speed = 20.0f;
        float part = MathHelper.func_76142_g((float)(newRotation - prevRotation));
        if (part > 20.0f) {
            part = 20.0f;
        }
        if (part < -20.0f) {
            part = -20.0f;
        }
        return prevRotation + part;
    }

    public void func_70071_h_() {
        if (!this.inGui) {
            super.func_70071_h_();
            this.field_70177_z = 0.0f;
            this.field_70761_aq = 0.0f;
            this.delegate.onUpdate(this);
        }
    }

    @Override
    public boolean wasShooting() {
        boolean shot = (Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG) != this.prevShotChng;
        this.prevShotChng = (Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG);
        return shot;
    }

    @Override
    public void setShooting() {
        this.field_70180_af.func_187227_b(SHOT_CHNG, (Object)((Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG) == false ? 1 : 0));
    }

    private boolean isSubmergedInLiquid(double heightMod) {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u + heightMod, this.field_70161_v);
        return this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public void func_70636_d() {
        if (!this.delegate.isBuoy()) {
            this.field_70181_x -= (double)0.0325f;
        } else if (this.isSubmergedInLiquid(this.field_70131_O + 0.2f)) {
            this.field_70181_x += (double)0.0125f;
        } else if (this.isSubmergedInLiquid(this.field_70131_O + 0.05f)) {
            this.field_70181_x += (double)0.005f;
            if (this.field_70181_x > (double)0.025f) {
                this.field_70181_x *= 0.75;
            }
        } else if (!this.isSubmergedInLiquid(this.field_70131_O - 0.2f)) {
            this.field_70181_x -= (double)0.0325f;
        } else {
            this.field_70181_x -= (double)0.005f;
            if (this.field_70181_x < (double)-0.025f) {
                this.field_70181_x *= 0.75;
            }
        }
        super.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.field_72984_F.func_76320_a("oldAi");
            this.updateMyEntityActionState();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        this.upgProc.onTick();
        if (!this.field_70170_p.field_72995_K) {
            this.targetProc.onTick();
        } else {
            this.targetProc.onTickClient();
        }
        if (this.isActive()) {
            if (this.targetProc.hasTarget()) {
                this.func_70625_a(this.targetProc.getTarget(), 10.0f, this.func_70646_bf());
            } else if (this.field_70170_p.field_72995_K && TmrUtils.INSTANCE.getPassengersOfClass((Entity)this, EntityPlayer.class).size() < 1) {
                this.field_70759_as += 1.0f;
                this.field_70759_as = MiscUtils.wrap360((float)this.field_70759_as);
                this.field_70758_at = MiscUtils.wrap360((float)this.field_70758_at);
                if (this.field_70125_A < 0.0f) {
                    this.field_70125_A += 5.0f;
                    if (this.field_70125_A > 0.0f) {
                        this.field_70125_A = 0.0f;
                    }
                } else if (this.field_70125_A > 0.0f) {
                    this.field_70125_A -= 5.0f;
                    if (this.field_70125_A < 0.0f) {
                        this.field_70125_A = 0.0f;
                    }
                }
            }
        } else {
            float lockedPitch;
            this.field_70759_as = MiscUtils.wrap360((float)this.field_70759_as);
            this.field_70758_at = MiscUtils.wrap360((float)this.field_70758_at);
            float closestRot = (float)(MathHelper.func_76123_f((float)this.field_70759_as) / 90) * 90.0f;
            if (this.field_70759_as > closestRot) {
                this.field_70759_as -= 5.0f;
                if (this.field_70759_as < closestRot) {
                    this.field_70759_as = closestRot;
                }
            } else if (this.field_70759_as < closestRot) {
                this.field_70759_as += 5.0f;
                if (this.field_70759_as > closestRot) {
                    this.field_70759_as = closestRot;
                }
            }
            if (this.field_70125_A < (lockedPitch = this.delegate.getDeactiveHeadPitch())) {
                this.field_70125_A += 1.0f;
                if (this.field_70125_A > lockedPitch) {
                    this.field_70125_A = lockedPitch;
                }
            } else if (this.field_70125_A > lockedPitch) {
                this.field_70125_A -= 1.0f;
                if (this.field_70125_A < lockedPitch) {
                    this.field_70125_A = lockedPitch;
                }
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    private void onInteractSucceed(@Nonnull ItemStack heldItem, EntityPlayer player) {
        if (heldItem.func_190916_E() == 0) {
            player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem.func_77946_l());
        }
        this.updateState();
        player.field_71069_bz.func_75142_b();
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getCollectSound(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_70170_p.field_72995_K) {
            if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT)) {
                if (!player.func_70093_af()) {
                    TmrUtils.INSTANCE.openGui(player, EnumGui.TCU, this.func_145782_y(), 0, 0);
                }
                return true;
            }
            if (!ItemStackUtils.isValid((ItemStack)stack) && hand == EnumHand.MAIN_HAND) {
                TmrUtils.INSTANCE.openGui(player, EnumGui.TINFO, this.func_145782_y(), 0, 0);
            }
            return false;
        }
        if (ItemStackUtils.isValid((ItemStack)stack)) {
            if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT) && player.func_70093_af()) {
                ItemTurretControlUnit.bindTurret(stack, this);
                return true;
            }
            if (this.targetProc.addAmmo(stack, (ICapabilityProvider)player)) {
                this.onInteractSucceed(stack, player);
                return true;
            }
            if (this.upgProc.tryApplyUpgrade(stack.func_77946_l())) {
                stack.func_190918_g(1);
                this.onInteractSucceed(stack, player);
                return true;
            }
            if (this.applyRepairKit(stack)) {
                stack.func_190918_g(1);
                this.onInteractSucceed(stack, player);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean applyRepairKit(ItemStack stack) {
        IRepairKit repKit = RepairKitRegistry.INSTANCE.getObject(stack);
        if (repKit.isApplicable(this)) {
            this.func_70691_i(repKit.getHealAmount());
            repKit.onHeal(this);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource dmgSrc) {
        super.func_70645_a(dmgSrc);
        if (!this.field_70170_p.field_72995_K) {
            this.targetProc.dropAmmo();
            this.upgProc.dropUpgrades();
        }
        this.func_70106_y();
    }

    private void updateMyEntityActionState() {
        ++this.field_70708_bq;
        this.field_70702_br = 0.0f;
        this.field_191988_bg = 0.0f;
        this.field_70177_z = 0.0f;
    }

    @Override
    public ITargetProcessor getTargetProcessor() {
        return this.targetProc;
    }

    @Override
    public IUpgradeProcessor getUpgradeProcessor() {
        return this.upgProc;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.delegate.getId().toString());
        NBTTagCompound targetNbt = new NBTTagCompound();
        this.targetProc.writeToNbt(targetNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)targetNbt);
        NBTTagCompound upgNbt = new NBTTagCompound();
        this.upgProc.writeToNbt(upgNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)upgNbt);
        if (this.ownerUUID != null) {
            buffer.writeBoolean(true);
            buffer.writeLong(this.ownerUUID.getMostSignificantBits());
            buffer.writeLong(this.ownerUUID.getLeastSignificantBits());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
        } else {
            buffer.writeBoolean(false);
        }
        this.delegate.writeSpawnData(this, buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.delegate = TurretRegistry.INSTANCE.getObject(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer)));
        this.targetProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        this.upgProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        if (buffer.readBoolean()) {
            this.ownerUUID = new UUID(buffer.readLong(), buffer.readLong());
            this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.delegate.readSpawnData(this, buffer);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("turretId", this.delegate.getId().toString());
        this.targetProc.writeToNbt(nbt);
        this.upgProc.writeToNbt(nbt);
        this.dwBools.writeToNbt(nbt);
        if (this.ownerUUID != null) {
            nbt.func_74778_a("ownerUUID", this.ownerUUID.toString());
            nbt.func_74778_a("ownerName", this.ownerName);
        }
        if (this.delegate instanceof IVariantHolder) {
            nbt.func_74778_a("Variant", this.getVariant().getId().toString());
        }
        this.delegate.onSave(this, nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String turretId = nbt.func_74779_i("turretId");
        if (UuidUtils.isStringUuid((String)turretId)) {
            this.loadDelegate(ItemRemapper.OLD_TURRET_MAPPINGS.get(UUID.fromString(turretId)));
        } else {
            ResourceLocation turretIdRL = new ResourceLocation(turretId);
            if (ItemRemapper.OLD_TURRET_ID_MAPPINGS.containsKey(turretIdRL)) {
                turretIdRL = ItemRemapper.OLD_TURRET_ID_MAPPINGS.get(turretIdRL);
            }
            this.loadDelegate(turretIdRL);
        }
        super.func_70037_a(nbt);
        this.targetProc.readFromNbt(nbt);
        this.upgProc.readFromNbt(nbt);
        this.dwBools.readFromNbt(nbt);
        if (nbt.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbt.func_74779_i("ownerUUID"));
            this.ownerName = nbt.func_74779_i("ownerName");
        }
        if (nbt.func_150297_b("Variant", 8)) {
            this.setVariant(new ResourceLocation(nbt.func_74779_i("Variant")));
        }
        this.delegate.onLoad(this, nbt);
    }

    private void loadDelegate(ResourceLocation id) {
        this.loadDelegate(TurretRegistry.INSTANCE.getObject(id));
    }

    private void loadDelegate(ITurret turret) {
        this.delegate = turret;
        this.delegate.entityInit(this);
        this.delegate.applyEntityAttributes(this);
        this.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a((double)this.delegate.getReloadTicks());
        this.func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111128_a((double)this.delegate.getAmmoCapacity());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.delegate.getHealth());
        this.targetProc.init();
    }

    public int func_70646_bf() {
        return 50;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_82720_e();
    }

    public final void func_70653_a(Entity entity, float unknown, double motionXAmount, double motionZAmount) {
    }

    public final void func_70091_d(MoverType type, double motionX, double motionY, double motionZ) {
        if (type == MoverType.PISTON) {
            super.func_70091_d(type, motionX, motionY, motionZ);
        }
    }

    public boolean func_184202_aL() {
        return super.func_184202_aL() || TurretModRebirth.proxy.checkTurretGlowing(this);
    }

    public final void func_191986_a(float strafe, float vertical, float forward) {
    }

    @Override
    public SoundEvent getShootSound() {
        return this.delegate.getShootSound(this);
    }

    @Override
    public SoundEvent getNoAmmoSound() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getNoAmmoSound(this), (Object)SoundEvents.field_187576_at);
    }

    @Override
    public boolean isActive() {
        return this.dwBools.getBit(DataWatcherBooleans.Turret.ACTIVE.bit);
    }

    @Override
    public void setActive(boolean isActive) {
        this.dwBools.setBit(DataWatcherBooleans.Turret.ACTIVE.bit, isActive);
    }

    @Override
    public boolean showRange() {
        return this.showRange;
    }

    @Override
    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
    }

    private static boolean isAABBInside(AxisAlignedBB bb1) {
        return bb1.field_72340_a <= EntityTurret.UPWARDS_BLOCK.field_72340_a && bb1.field_72338_b <= EntityTurret.UPWARDS_BLOCK.field_72338_b && bb1.field_72339_c <= EntityTurret.UPWARDS_BLOCK.field_72339_c && bb1.field_72336_d >= EntityTurret.UPWARDS_BLOCK.field_72336_d && bb1.field_72337_e >= EntityTurret.UPWARDS_BLOCK.field_72337_e && bb1.field_72334_f >= EntityTurret.UPWARDS_BLOCK.field_72334_f;
    }

    public static boolean canTurretBePlaced(ITurret delegate, World world, BlockPos pos, boolean doBlockCheckOnly) {
        BlockPos posPlaced2;
        AxisAlignedBB blockBB = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos);
        boolean buoyant = delegate.isBuoy();
        if (!(buoyant || blockBB != null && EntityTurret.isAABBInside(blockBB))) {
            return false;
        }
        BlockPos posPlaced = pos.func_177972_a(EnumFacing.UP);
        BlockPos blockPos = posPlaced2 = buoyant ? pos : pos.func_177967_a(EnumFacing.UP, 2);
        if (!world.func_180495_p(posPlaced).func_177230_c().func_176200_f((IBlockAccess)world, posPlaced) || !world.func_180495_p(posPlaced2).func_177230_c().func_176200_f((IBlockAccess)world, posPlaced2)) {
            return false;
        }
        if (!doBlockCheckOnly) {
            AxisAlignedBB aabb = new AxisAlignedBB((double)posPlaced.func_177958_n(), (double)posPlaced.func_177956_o(), (double)posPlaced.func_177952_p(), (double)posPlaced.func_177958_n() + 1.0, (double)posPlaced.func_177956_o() + (buoyant ? -1.0 : 1.0), (double)posPlaced.func_177952_p() + 1.0);
            return world.func_72872_a(EntityTurret.class, aabb).isEmpty();
        }
        return true;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public boolean hasPlayerPermission(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.ownerUUID == null) {
            return true;
        }
        MinecraftServer mcSrv = this.field_70170_p.func_73046_m();
        GameProfile profile = player.func_146103_bH();
        if (mcSrv != null && mcSrv.func_71264_H() && mcSrv.func_71214_G().equals(profile.getName())) {
            return true;
        }
        if (TmrUtils.INSTANCE.canPlayerEditAll() || this.ownerUUID.equals(profile.getId())) {
            return true;
        }
        return player.func_70003_b(2, "") && TmrUtils.INSTANCE.canOpEditAll();
    }

    @Override
    public boolean isInGui() {
        return this.inGui;
    }

    @Override
    public <V extends ITurretRAM> V getRAM(Supplier<V> onNull) {
        if (this.turretRAM == null && onNull != null) {
            this.turretRAM = (ITurretRAM)onNull.get();
        }
        return (V)((ITurretRAM)ReflectionUtils.getCasted((Object)this.turretRAM));
    }

    @Override
    public void updateState() {
        PacketRegistry.sendToAllAround((IMessage)new PacketUpdateTurretState(this), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        IVariant variant;
        ItemStack pickedItem = TurretRegistry.INSTANCE.getItem(this.delegate.getId());
        if (this.delegate instanceof IVariantHolder && !((IVariantHolder)((Object)this.delegate)).isDefaultVariant(variant = this.getVariant())) {
            new ItemTurret.TurretStats(null, null, variant).updateData(pickedItem);
        }
        return pickedItem;
    }

    public void func_174812_G() {
        this.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity instanceof EntityPlayer ? entity.func_174813_aQ() : null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Override
    public AxisAlignedBB getRangeBB() {
        return this.delegate.getRangeBB(this);
    }

    @Override
    public boolean isBuoy() {
        return this.delegate.isBuoy();
    }

    @Override
    public EntityLiving get() {
        return this;
    }

    @Override
    public ITurret getTurret() {
        return this.delegate;
    }

    @Override
    public ITurret.AttackType getAttackType() {
        return this.delegate.getAttackType();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return LangUtils.translate((String)LangUtils.ENTITY_NAME.get(new Object[]{this.delegate.getId()}), (Object[])new Object[0]);
    }

    public boolean func_70648_aU() {
        return this.delegate.isBuoy();
    }

    @Override
    public TileEntityTurretCrate dismantle() {
        TileEntity te;
        BlockPos cratePos = this.func_180425_c();
        if (this.field_70170_p.func_180501_a(cratePos, BlockRegistry.TURRET_CRATE.func_176223_P(), 3) && (te = this.field_70170_p.func_175625_s(cratePos)) instanceof TileEntityTurretCrate) {
            TileEntityTurretCrate crate = (TileEntityTurretCrate)te;
            crate.insertTurret(this);
            this.func_174812_G();
            return crate;
        }
        return null;
    }

    @Override
    public IVariant getVariant() {
        if (this.delegate instanceof IVariantHolder) {
            return ((IVariantHolder)((Object)this.delegate)).getVariant(new ResourceLocation((String)this.field_70180_af.func_187225_a(VARIANT)));
        }
        return null;
    }

    @Override
    public void setVariant(ResourceLocation variantId) {
        if (this.delegate instanceof IVariantHolder) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)variantId.toString());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPartBrightnessForRender(double partY) {
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e((BlockPos)bpos)) {
            bpos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + partY)));
            return this.field_70170_p.func_175626_b((BlockPos)bpos, 0);
        }
        return 0;
    }
}

