/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import com.google.common.base.Strings;
import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.projectile.ProjectileRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EntityTurretProjectile
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData,
IProjectileInst {
    public de.sanandrew.mods.turretmod.api.ammo.IProjectile delegate;
    private UUID shooterUUID;
    private EntityTurret shooterCache;
    private Entity lastDamaged;
    private int lastDamagedTimer;
    private IAmmunition ammunition;
    private String ammoSubtype;
    private double maxDist;
    private float lastDamage;
    private double attackModifier = 1.0;

    public EntityTurretProjectile(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.maxDist = 2.147483647E9;
        this.lastDamage = -1.0f;
    }

    EntityTurretProjectile(World world, de.sanandrew.mods.turretmod.api.ammo.IProjectile delegate, IAmmunition ammunition, String ammoSubtype, EntityTurret shooter, Entity target, double attackModifier) {
        this(world, delegate, ammunition, ammoSubtype, shooter, target, null, attackModifier);
    }

    EntityTurretProjectile(World world, de.sanandrew.mods.turretmod.api.ammo.IProjectile delegate, IAmmunition ammunition, String ammoSubtype, EntityTurret shooter, Vec3d shootingVec, double attackModifier) {
        this(world, delegate, ammunition, ammoSubtype, shooter, null, shootingVec, attackModifier);
    }

    private EntityTurretProjectile(World world, de.sanandrew.mods.turretmod.api.ammo.IProjectile delegate, IAmmunition ammunition, String ammoSubtype, EntityTurret shooter, Entity target, Vec3d shootingVec, double attackModifier) {
        this(world);
        this.delegate = delegate;
        this.shooterUUID = shooter.func_110124_au();
        this.shooterCache = shooter;
        this.ammunition = ammunition;
        this.ammoSubtype = ammoSubtype;
        this.attackModifier = attackModifier;
        double y = shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1;
        this.func_70107_b(shooter.field_70165_t, y, shooter.field_70161_v);
        this.maxDist = shooter.getTargetProcessor().getRangeVal() * 4.0;
        Vec3d targetVec = target != null ? new Vec3d(target.field_70165_t - shooter.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 1.4 - y, target.field_70161_v - shooter.field_70161_v) : (shootingVec != null ? shootingVec : new Vec3d(0.0, -1.0, 0.0));
        this.setHeadingFromVec(targetVec.func_72432_b());
        this.field_70181_x += (double)this.delegate.getArc() * Math.sqrt(targetVec.field_72450_a * targetVec.field_72450_a + targetVec.field_72449_c * targetVec.field_72449_c) * 0.05;
        this.delegate.onCreate(this.shooterCache, this);
    }

    private void setHeadingFromVec(Vec3d vector) {
        double scatterVal = this.delegate.getScatterValue();
        float initSpeed = this.delegate.getSpeed();
        this.field_70159_w = vector.field_72450_a * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        this.field_70179_y = vector.field_72449_c * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        this.field_70181_x = vector.field_72448_b * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        float vecPlaneNormal = MathHelper.func_76133_a((double)(vector.field_72450_a * vector.field_72450_a + vector.field_72449_c * vector.field_72449_c));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vector.field_72450_a, vector.field_72449_c) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vector.field_72448_b, vecPlaneNormal) * 180.0 / Math.PI);
    }

    protected void func_70088_a() {
        if (this.shooterUUID != null && this.shooterCache == null) {
            this.shooterCache = (EntityTurret)EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.shooterUUID);
        }
    }

    public void func_70071_h_() {
        this.field_70160_al = true;
        if (this.shooterCache != null && (double)this.func_70032_d((Entity)this.shooterCache) > this.maxDist || this.delegate == null) {
            this.func_70106_y();
            return;
        }
        if (this.lastDamaged != null && ++this.lastDamagedTimer >= 20) {
            this.lastDamaged = null;
            this.lastDamagedTimer = 0;
        }
        this.doCollisionCheck();
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float speed = this.delegate.getSpeedMultiplierAir();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float disPos = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)disPos, this.field_70163_u - this.field_70181_x * (double)disPos, this.field_70161_v - this.field_70179_y * (double)disPos, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            BlockPos currPos = this.func_180425_c();
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)this.field_70170_p.func_180495_p(currPos).func_177230_c());
            float viscosity = 1.0f;
            if (fluid != null) {
                viscosity = (float)fluid.getViscosity(this.field_70170_p, currPos) / 1000.0f;
            }
            speed = this.delegate.getSpeedMultiplierLiquid(viscosity);
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.field_70181_x -= (double)(this.delegate.getArc() * 0.1f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
        this.delegate.onUpdate(this.shooterCache, this);
    }

    private void doCollisionCheck() {
        Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d futurePosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult hitObj = this.field_70170_p.func_147447_a(posVec, futurePosVec, false, true, false);
        posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        futurePosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (hitObj != null) {
            futurePosVec = new Vec3d(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        AxisAlignedBB checkBB = this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0);
        List list = this.field_70170_p.func_72839_b((Entity)this, checkBB);
        double minDist = 0.0;
        for (Entity collidedEntity : list) {
            double vecDistance;
            boolean isClosest;
            IEntityMultiPart iemp;
            AxisAlignedBB collisionAABB;
            RayTraceResult interceptObj;
            if (!collidedEntity.func_70067_L() || collidedEntity == this.shooterCache || (interceptObj = (collisionAABB = collidedEntity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(posVec, futurePosVec)) == null) continue;
            Entity validator = collidedEntity;
            if (collidedEntity instanceof MultiPartEntityPart && (iemp = ((MultiPartEntityPart)collidedEntity).field_70259_a) instanceof Entity) {
                validator = (Entity)iemp;
            }
            boolean bl = isClosest = (vecDistance = posVec.func_72438_d(interceptObj.field_72307_f)) < minDist || minDist == 0.0;
            if (this.shooterCache != null && !this.shooterCache.getTargetProcessor().isEntityValidTarget(validator) || !isClosest) continue;
            entity = collidedEntity;
            minDist = vecDistance;
        }
        if (entity != null) {
            hitObj = new RayTraceResult(entity);
        }
        if (hitObj != null && hitObj.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)hitObj.field_72308_g;
            if (player.field_71075_bZ.field_75102_a) {
                hitObj = null;
            }
        }
        if (hitObj != null) {
            if (hitObj.field_72308_g != null) {
                MutableFloat dmg = new MutableFloat((Number)((double)this.delegate.getDamage() * this.attackModifier));
                IProjectile.TargetType tgtType = this.getTargetType(hitObj.field_72308_g);
                DamageSource damagesource = this.getProjDamageSource(hitObj.field_72308_g, tgtType);
                if (this.func_70027_ad() && !(hitObj.field_72308_g instanceof EntityEnderman)) {
                    hitObj.field_72308_g.func_70015_d(5);
                }
                boolean preHitVelocityChanged = hitObj.field_72308_g.field_70133_I;
                boolean preHitAirBorne = hitObj.field_72308_g.field_70160_al;
                double preHitMotionX = hitObj.field_72308_g.field_70159_w;
                double preHitMotionY = hitObj.field_72308_g.field_70181_x;
                double preHitMotionZ = hitObj.field_72308_g.field_70179_y;
                hitObj.field_72308_g.field_70172_ad = 0;
                if (hitObj.field_72308_g instanceof EntityCreature && this.shooterCache != null) {
                    TmrUtils.INSTANCE.setEntityTarget((EntityCreature)hitObj.field_72308_g, this.shooterCache);
                }
                if (this.delegate.onDamageEntityPre(this.shooterCache, this, hitObj.field_72308_g, damagesource, dmg) && hitObj.field_72308_g.func_70097_a(damagesource, dmg.floatValue())) {
                    this.lastDamage = dmg.floatValue();
                    this.lastDamaged = hitObj.field_72308_g;
                    this.lastDamagedTimer = 0;
                    hitObj.field_72308_g.field_70133_I = preHitVelocityChanged;
                    hitObj.field_72308_g.field_70160_al = preHitAirBorne;
                    hitObj.field_72308_g.field_70159_w = preHitMotionX;
                    hitObj.field_72308_g.field_70181_x = preHitMotionY;
                    hitObj.field_72308_g.field_70179_y = preHitMotionZ;
                    this.delegate.onDamageEntityPost(this.shooterCache, this, hitObj.field_72308_g, damagesource);
                    if (hitObj.field_72308_g instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)hitObj.field_72308_g;
                        if (!this.field_70170_p.field_72995_K) {
                            living.func_85034_r(living.func_85035_bI() + 1);
                        }
                        double deltaX = this.field_70165_t - living.field_70165_t;
                        double deltaZ = this.field_70161_v - living.field_70161_v;
                        while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                            deltaZ = (Math.random() - Math.random()) * 0.01;
                            deltaX = (Math.random() - Math.random()) * 0.01;
                        }
                        this.knockBackEntity(living, deltaX, deltaZ);
                        if (this.shooterCache != null) {
                            EnchantmentHelper.func_151384_a((EntityLivingBase)living, (Entity)this.shooterCache);
                            EnchantmentHelper.func_151385_b((EntityLivingBase)this.shooterCache, (Entity)living);
                        }
                    }
                }
            }
            if (this.delegate.onHit(this.shooterCache, this, hitObj)) {
                this.func_70107_b(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c);
                this.func_184185_a(this.delegate.getRicochetSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70106_y();
            }
        }
    }

    public static DamageSource getDamageSource(ITurretInst turret, @Nonnull IProjectileInst projectile, IProjectile.TargetType type) {
        switch (type) {
            case SPECIAL_ENDERMAN: {
                return new DamageSourceProjectile(projectile.get(), turret).func_180138_v();
            }
            case SPECIAL_ENDER_DRAGON: {
                return new DamageSourceProjectile(projectile.get(), turret).func_94540_d();
            }
            case SPECIAL_WITHER: {
                return new DamageSourceHiddenProjectile(projectile.get(), turret);
            }
        }
        return new DamageSourceIndirectProjectile(projectile.get(), turret);
    }

    private DamageSource getProjDamageSource(Entity hitEntity, IProjectile.TargetType type) {
        return (DamageSource)MiscUtils.defIfNull((Object)this.delegate.getCustomDamageSrc(this.shooterCache, this, hitEntity, type), () -> EntityTurretProjectile.getDamageSource(this.shooterCache, this, type));
    }

    private IProjectile.TargetType getTargetType(Entity entity) {
        boolean hasToxinII;
        if (this.shooterCache == null) {
            return IProjectile.TargetType.REGULAR;
        }
        boolean hasToxinI = this.shooterCache.getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_TOXIN_I);
        boolean bl = hasToxinII = hasToxinI && this.shooterCache.getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_TOXIN_II);
        if (entity instanceof EntityEnderman && hasToxinI) {
            return IProjectile.TargetType.SPECIAL_ENDERMAN;
        }
        if ((entity instanceof EntityDragon || entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof EntityDragon) && hasToxinII) {
            return IProjectile.TargetType.SPECIAL_ENDER_DRAGON;
        }
        if (entity instanceof EntityWither && hasToxinII) {
            return IProjectile.TargetType.SPECIAL_WITHER;
        }
        return IProjectile.TargetType.REGULAR;
    }

    private void knockBackEntity(EntityLivingBase living, double deltaX, double deltaZ) {
        if (this.field_70146_Z.nextDouble() >= living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            living.field_70160_al = true;
            double normXZ = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            double kbStrengthXZ = this.delegate.getKnockbackHorizontal();
            double kbStrengthY = this.delegate.getKnockbackVertical();
            living.field_70159_w /= 2.0;
            living.field_70181_x /= 2.0;
            living.field_70179_y /= 2.0;
            living.field_70159_w -= deltaX / normXZ * kbStrengthXZ;
            living.field_70181_x += kbStrengthY;
            living.field_70179_y -= deltaZ / normXZ * kbStrengthXZ;
            if (living.field_70181_x > (double)0.4f) {
                living.field_70181_x = 0.4f;
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.delegate = ProjectileRegistry.INSTANCE.getObject(new ResourceLocation(nbt.func_74779_i("DelegateId")));
        if (!this.delegate.isValid()) {
            this.func_70106_y();
        }
        if (nbt.func_74764_b("AttackModifier")) {
            this.attackModifier = nbt.func_74769_h("AttackModifier");
        }
        if (nbt.func_74764_b("shooter")) {
            this.shooterUUID = UUID.fromString(nbt.func_74779_i("shooter"));
        }
        if (nbt.func_74764_b("AmmoType")) {
            this.ammunition = AmmunitionRegistry.INSTANCE.getObject(new ResourceLocation(nbt.func_74779_i("AmmoType")));
        }
        if (nbt.func_74764_b("AmmoSubtype")) {
            this.ammoSubtype = nbt.func_74779_i("AmmoSubtype");
        }
        this.lastDamage = nbt.func_74764_b("LastDamage") ? nbt.func_74760_g("LastDamage") : Float.MAX_VALUE;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("DelegateId", this.delegate.getId().toString());
        nbt.func_74780_a("AttackModifier", this.attackModifier);
        if (this.shooterUUID != null) {
            nbt.func_74778_a("shooter", this.shooterUUID.toString());
        }
        if (this.ammunition != null) {
            nbt.func_74778_a("AmmoType", this.ammunition.getId().toString());
        }
        if (this.ammoSubtype != null) {
            nbt.func_74778_a("AmmoSubtype", this.ammoSubtype);
        }
    }

    public void func_70186_c(double x, double y, double z, float recoil, float randMulti) {
        float vecNormal = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)vecNormal;
        y /= (double)vecNormal;
        z /= (double)vecNormal;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        this.field_70159_w = x *= (double)recoil;
        this.field_70181_x = y *= (double)recoil;
        this.field_70179_y = z *= (double)recoil;
        float vecPlaneNormal = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, vecPlaneNormal) * 180.0 / Math.PI);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.delegate.getId().toString());
        buffer.writeFloat(this.field_70177_z);
        buffer.writeFloat(this.field_70125_A);
        buffer.writeBoolean(this.shooterCache != null);
        if (this.shooterCache != null) {
            buffer.writeInt(this.shooterCache.func_145782_y());
        }
        buffer.writeBoolean(this.ammunition != null);
        if (this.ammunition != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ammunition.getId().toString());
        }
        buffer.writeBoolean(this.ammoSubtype != null);
        if (this.ammoSubtype != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ammoSubtype);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.delegate = ProjectileRegistry.INSTANCE.getObject(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer)));
        this.field_70177_z = buffer.readFloat();
        this.field_70125_A = buffer.readFloat();
        if (buffer.readBoolean()) {
            this.shooterCache = (EntityTurret)this.field_70170_p.func_73045_a(buffer.readInt());
        }
        if (buffer.readBoolean()) {
            this.ammunition = AmmunitionRegistry.INSTANCE.getObject(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer)));
        }
        if (buffer.readBoolean()) {
            this.ammoSubtype = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    @Override
    public float getLastCausedDamage() {
        return this.lastDamage;
    }

    @Override
    public Entity getLastDamagedEntity() {
        return this.lastDamaged;
    }

    @Override
    public Entity get() {
        return this;
    }

    @Override
    public IAmmunition getAmmunition() {
        return (IAmmunition)MiscUtils.defIfNull((Object)this.ammunition, AmmunitionRegistry.INSTANCE::getDefaultObject);
    }

    @Override
    public String getAmmunitionSubtype() {
        return this.ammoSubtype;
    }

    public static class DamageSourceIndirectProjectile
    extends EntityDamageSourceIndirect
    implements ITurretDamageSource {
        private final ITurretInst turretInst;

        DamageSourceIndirectProjectile(Entity projectile, ITurretInst turretInst) {
            super("sapturretmod.turret", projectile, (Entity)(turretInst != null ? turretInst.get() : projectile));
            this.func_76349_b();
            this.turretInst = turretInst;
        }

        @Nonnull
        public ITextComponent func_151519_b(@Nonnull EntityLivingBase attacked) {
            return this.turretInst != null ? DamageSourceProjectile.getDeathMessage(attacked, this.turretInst, this.field_76373_n) : super.func_151519_b(attacked);
        }

        @Override
        public ITurretInst getTurretInst() {
            return this.turretInst;
        }
    }

    public static class DamageSourceProjectile
    extends DamageSourceHiddenProjectile {
        DamageSourceProjectile(Entity projectile, ITurretInst turretInst) {
            super(projectile, turretInst);
            this.func_76349_b();
        }
    }

    public static class DamageSourceHiddenProjectile
    extends EntityDamageSource
    implements ITurretDamageSource {
        private final ITurretInst turretInst;

        DamageSourceHiddenProjectile(Entity projectile, ITurretInst turretInst) {
            super("sapturretmod.turret", projectile);
            this.turretInst = turretInst;
        }

        @Nullable
        public Entity func_76364_f() {
            return this.field_76386_o;
        }

        @Nullable
        public Entity func_76346_g() {
            return this.turretInst.get();
        }

        public ITextComponent func_151519_b(EntityLivingBase attacked) {
            return DamageSourceHiddenProjectile.getDeathMessage(attacked, this.turretInst, this.field_76373_n);
        }

        static ITextComponent getDeathMessage(EntityLivingBase attacked, ITurretInst turret, String damageType) {
            String turretOwner = turret.getOwnerName();
            String turretName = turret.get().func_70005_c_();
            if (!Strings.isNullOrEmpty((String)turretOwner)) {
                turretName = turretOwner + "'s " + turretName;
            }
            String s = "death.attack." + damageType + '.' + turret.getTurret().getId();
            return new TextComponentTranslation(s, new Object[]{attacked.func_145748_c_(), turretName});
        }

        @Override
        public ITurretInst getTurretInst() {
            return this.turretInst;
        }
    }

    public static interface ITurretDamageSource {
        public ITurretInst getTurretInst();
    }
}

