/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.Pattern;
import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.init.TmrConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

@Category(value="targets")
public final class TargetList {
    public static final String NAME = "targets";
    @Value(comment="Wether or not to regenerate the groundEntities config. This will be set to false once it is done.\nThe generator will scoop through the entity registry and add any entity extending EntityLiving and filter out anything that is already\nwhitelisted as a flying or water-based entity.")
    public static boolean groundRegenerate = true;
    @Value(comment="A whitelist to determine targetable entity types by \"anti-ground\" turrets (anything that cannot attack flying or water-based entities).\nThis needs to be the registry name, like \"minecraft:cow\" for a cow, etc.", range=@Range(validationPattern=@Pattern(value=".*?:.*")))
    public static String[] groundEntities = new String[0];
    @Value(comment="A whitelist to determine targetable entity types by \"anti-air\" turrets (anything that cannot attack ground-based or water-based entities).\nThis needs to be the registry name, like \"minecraft:ghast\" for a ghast, etc.", range=@Range(validationPattern=@Pattern(value=".*?:.*")))
    public static String[] flyingEntities = new String[]{"aether_legacy:aerwhale", "aether_legacy:flying_cow", "aether_legacy:zephyr", "babymobs:babyblaze", "babymobs:babydragon", "babymobs:babyghast", "babymobs:babywither", "botania:pixie", "butterflies:butterfly", "claysoldiers:mountpegasus", "enderiozoo:owl", "exoticbirds:bluejay", "exoticbirds:booby", "exoticbirds:cardinal", "exoticbirds:cassowary", "exoticbirds:crane", "exoticbirds:gouldianfinch", "exoticbirds:heron", "exoticbirds:hummingbird", "exoticbirds:kingfisher", "exoticbirds:kookaburra", "exoticbirds:lyrebird", "exoticbirds:magpie", "exoticbirds:owl", "exoticbirds:parrot", "exoticbirds:peafowl", "exoticbirds:pelican", "exoticbirds:phoenix", "exoticbirds:pigeon", "exoticbirds:robin", "exoticbirds:seagull", "exoticbirds:swan", "exoticbirds:toucan", "exoticbirds:vulture", "exoticbirds:woodpecker", "familiarfauna:familiarfauna.butterfly", "familiarfauna:familiarfauna.dragonfly", "familiarfauna:familiarfauna.pixie", "forestry:butterflyge", "minecraft:bat", "minecraft:blaze", "minecraft:ender_dragon", "minecraft:ghast", "minecraft:parrot", "minecraft:vex", "minecraft:wither", "nex:ghast_queen", "nex:ghastling", "primitivemobs:blazing_juggernaut", "quark:wraith", "thaumcraft:firebat", "thaumcraft:wisp", "thebetweenlands:dragonfly", "thebetweenlands:firefly", "thebetweenlands:chiromaw", "totemic:bald_eagle", "twilightforest:firefly", "twilightforest:mini_ghast", "twilightforest:mosquito_swarm", "twilightforest:snow_queen", "twilightforest:snow_guardian", "twilightforest:tower_ghast", "twilightforest:ur_ghast", "twilightforest:wraith", "twilightforest:raven", "thermalfoundation:blizz", "thermalfoundation:blitz", "thermalfoundation:basalz", "birdwmod:rednecked_nightjar", "birdwmod:eurasian_bullfinch", "birdwmod:redflanked_bluetail", "birdwmod:stellers_eider", "birdwmod:killdeer", "birdwmod:eastern_bluebird", "birdwmod:northern_mockingbird", "birdwmod:green_heron", "birdwmod:hoatzin", "birdwmod:turquoisebrowed_motmot", "birdwmod:kingofsaxony_bird_of_paradise", "birdwmod:great_grey_owl", "birdwmod:brown_booby", "emberroot:fairies", "emberroot:owl", "emberroot:rootsonesprite", "emberroot:rootsonespriteling", "emberroot:rootsonespriteprojectile", "emberroot:rootsonespritegreater", "emberroot:rootsonespriteboss", "randomthings:spirit", "stupidthings:balloon", "mysticalworld:entity_owl", "ambients:bird", "ambients:bat", "ebwizardry:blaze_minion", "ebwizardry:ice_wraith", "ebwizardry:lightning_wraith", "ebwizardry:shadow_wraith", "ebwizardry:storm_elemental", "ebwizardry:phoenix", "ebwizardry:vex_minion", "ebwizardry:remnant", "mowziesmobs:lantern", "mowziesmobs:naga", "betteranimalsplus:lammergeier", "betteranimalsplus:songbird", "betteranimalsplus:zotzpyre", "bewitchment:owl", "bewitchment:raven", "cqrepoured:nether_dragon", "cqrepoured:flying_skull", "cqrepoured:pirate_parrot", "mod_lavacow:raven", "mod_lavacow:ptera", "mod_lavacow:vespa", "mod_lavacow:ghostray", "iceandfire:firedragon", "iceandfire:icedragon", "iceandfire:hippogryph", "iceandfire:if_pixie", "iceandfire:stymphalianbird", "iceandfire:amphithere", "mahoutsukai:fae", "netherex:ghast_queen", "netherex:ghastling", "pneumaticcraft:drone", "pneumaticcraft:logistic_drone", "pneumaticcraft:harvesting_drone", "rats:ratlantean_spirit", "rats:plague_cloud", "srparasites:alafha", "srparasites:emana", "srparasites:emanaadapted", "srparasites:buthol", "srparasites:oronco", "thaumicaugmentation:primal_wisp", "coroutil:bat_smart", "inventorypets:entityminiquantumblaze", "mob_mash:ghost", "specialmobs:specialghast", "specialmobs:babyghast", "specialmobs:fighterghast", "specialmobs:kingghast", "specialmobs:queenghast", "specialmobs:unholyghast", "specialmobs:specialblaze", "specialmobs:cinderblaze", "specialmobs:conflagrationblaze", "specialmobs:emberblaze", "specialmobs:hellfireblaze", "specialmobs:infernoblaze", "specialmobs:joltblaze", "specialmobs:wildfireblaze", "fossil:fossil.pterosaur", "fossil:fossil.meganeura", "fossil:fossil.confuciusornis", "erebus:erebus.wasp", "erebus:erebus.fly", "erebus:erebus.mosquito", "erebus:erebus.bot_fly", "erebus:erebus.moth", "erebus:erebus.worker_bee", "erebus:erebus.dragon_fly", "erebus:erebus.cicada", "erebus:erebus.midge_swarm", "erebus:erebus.locust"};
    @Value(comment="A whitelist to determine targetable entity types by \"anti-water\" turrets (anything that cannot attack flying or ground-based entities).\nThis needs to be the registry name, like \"minecraft:squid\" for a squid, etc.", range=@Range(validationPattern=@Pattern(value=".*?:.*")))
    public static String[] waterEntities = new String[]{"babymobs:babyguardian", "babymobs:babysquid", "enderiozoo:epicsquid", "minecraft:elder_guardian", "claysoldiers:mountturtle", "minecraft:guardian", "minecraft:squid", "primitivemobs:lily_lurker", "thebetweenlands:angler", "thebetweenlands:blind_cave_fish", "jaff:cod", "jaff:salmon", "jaff:clownfish", "jaff:pufferfish", "abyssaldepths:fish", "abyssaldepths:clownfish", "abyssaldepths:seahorse", "abyssaldepths:butterflyfish", "abyssaldepths:masked_butterflyfish", "abyssaldepths:raccoon_butterflyfish", "abyssaldepths:spotfin_butterflyfish", "abyssaldepths:bannerfish", "abyssaldepths:fairy_basslet", "abyssaldepths:blackcap_basslet", "abyssaldepths:sailfish", "abyssaldepths:swordfish", "abyssaldepths:sea_serpent", "better_diving:peeper", "better_diving:bladderfish", "better_diving:garryfish", "better_diving:holefish", "better_diving:boomerang", "betteranimalsplus:jellyfish", "betteranimalsplus:nautilus", "betteranimalsplus:shark", "betteranimalsplus:lamprey", "betteranimalsplus:bobbit_worm", "betteranimalsplus:eel_freshwater", "betteranimalsplus:eel_saltwater", "betteranimalsplus:whale", "betteranimalsplus:horseshoecrab", "mod_lavacow:piranha", "mod_lavacow:zombiepiranha", "iceandfire:siren", "iceandfire:hippocampus", "iceandfire:seaserpent", "rats:pirat_boat", "merpig:merpig", "rocketsquidsft:rocketsquid", "rocketsquidsft:babyrocketsquid", "fossil:fossil.nautilus", "fossil:fossil.coelacanth", "fossil:fossil.alligator_gar", "fossil:fossil.sturgeon", "fossil:fossil.plesiosaur", "fossil:fossil.mosasaurus", "fossil:fossil.liopleurodon", "fossil:fossil.henodus", "fossil:fossil.icthyosaurus", "fossil:fossil.megalograptus", "fossil:fossil.crassigyrinus", "fossil:fossil.megalodon", "fossil:fossil.diplocaulus", "erebus:erebus.pond_skater", "fossil:fossil.tiktaalik", "fossil:fossil.sarcosuchus", "fossil:fossil.spinosaurus"};
    private static final String[] guaranteedGround = new String[]{"minecraft:wither_skeleton", "minecraft:stray", "minecraft:husk", "minecraft:zombie_villager", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:evocation_illager", "minecraft:vindication_illager", "minecraft:illusion_illager", "minecraft:creeper", "minecraft:skeleton", "minecraft:spider", "minecraft:giant", "minecraft:zombie", "minecraft:slime", "minecraft:zombie_pigman", "minecraft:enderman", "minecraft:cave_spider", "minecraft:silverfish", "minecraft:magma_cube", "minecraft:witch", "minecraft:endermite", "minecraft:shulker", "minecraft:pig", "minecraft:sheep", "minecraft:cow", "minecraft:chicken", "minecraft:wolf", "minecraft:mooshroom", "minecraft:snowman", "minecraft:ocelot", "minecraft:villager_golem", "minecraft:horse", "minecraft:rabbit", "minecraft:polar_bear", "minecraft:llama", "minecraft:villager", "biomesoplenty:wasp", "botania:doppleganger", "botania:pink_wither", "animania:hamster", "animania:ferret_grey", "animania:ferret_white", "animania:hedgehog", "animania:hedgehog_albino", "animania:toad", "animania:frog", "animania:dartfrog", "animania:buck_cottontail", "animania:doe_cottontail", "animania:kit_cottontail", "animania:buck_chinchilla", "animania:doe_chinchilla", "animania:kit_chinchilla", "animania:buck_dutch", "animania:doe_dutch", "animania:kit_dutch", "animania:buck_havana", "animania:doe_havana", "animania:kit_havana", "animania:buck_jack", "animania:doe_jack", "animania:kit_jack", "animania:buck_new_zealand", "animania:doe_new_zealand", "animania:kit_new_zealand", "animania:buck_rex", "animania:doe_rex", "animania:kit_rex", "animania:buck_lop", "animania:doe_lop", "animania:kit_lop", "animania:peachick_charcoal", "animania:peahen_charcoal", "animania:peacock_charcoal", "animania:peachick_opal", "animania:peahen_opal", "animania:peacock_opal", "animania:peachick_peach", "animania:peahen_peach", "animania:peacock_peach", "animania:peachick_purple", "animania:peahen_purple", "animania:peacock_purple", "animania:peachick_taupe", "animania:peahen_taupe", "animania:peacock_taupe", "animania:peachick_blue", "animania:peahen_blue", "animania:peacock_blue", "animania:peachick_white", "animania:peahen_white", "animania:peacock_white", "animania:mare_draft", "animania:stallion_draft", "animania:foal_draft", "animania:piglet_yorkshire", "animania:sow_yorkshire", "animania:hog_yorkshire", "animania:piglet_old_spot", "animania:sow_old_spot", "animania:hog_old_spot", "animania:piglet_large_black", "animania:sow_large_black", "animania:hog_large_black", "animania:piglet_large_white", "animania:sow_large_white", "animania:hog_large_white", "animania:piglet_hampshire", "animania:sow_hampshire", "animania:hog_hampshire", "animania:piglet_duroc", "animania:sow_duroc", "animania:hog_duroc", "animania:chick_leghorn", "animania:hen_leghorn", "animania:rooster_leghorn", "animania:chick_orpington", "animania:hen_orpington", "animania:rooster_orpington", "animania:chick_plymouth_rock", "animania:hen_plymouth_rock", "animania:rooster_plymouth_rock", "animania:chick_rhode_island_red", "animania:hen_rhode_island_red", "animania:rooster_rhode_island_red", "animania:chick_wyandotte", "animania:hen_wyandotte", "animania:rooster_wyandotte", "animania:calf_angus", "animania:cow_angus", "animania:bull_angus", "animania:calf_friesian", "animania:cow_friesian", "animania:bull_friesian", "animania:calf_hereford", "animania:cow_hereford", "animania:bull_hereford", "animania:calf_holstein", "animania:cow_holstein", "animania:bull_holstein", "animania:calf_longhorn", "animania:cow_longhorn", "animania:bull_longhorn", "animania:calf_highland", "animania:cow_highland", "animania:bull_highland", "animania:calf_jersey", "animania:cow_jersey", "animania:bull_jersey", "animania:calf_mooshroom", "animania:cow_mooshroom", "animania:bull_mooshroom", "animania:kid_alpine", "animania:buck_alpine", "animania:doe_alpine", "animania:kid_angora", "animania:buck_angora", "animania:doe_angora", "animania:kid_fainting", "animania:buck_fainting", "animania:doe_fainting", "animania:kid_kiko", "animania:buck_kiko", "animania:doe_kiko", "animania:kid_kinder", "animania:buck_kinder", "animania:doe_kinder", "animania:kid_nigerian_dwarf", "animania:buck_nigerian_dwarf", "animania:doe_nigerian_dwarf", "animania:kid_pygmy", "animania:buck_pygmy", "animania:doe_pygmy", "animania:lamb_friesian", "animania:ewe_friesian", "animania:ram_friesian", "animania:lamb_suffolk", "animania:ewe_suffolk", "animania:ram_suffolk", "animania:lamb_dorper", "animania:ewe_dorper", "animania:ram_dorper", "animania:lamb_dorset", "animania:ewe_dorset", "animania:ram_dorset", "animania:lamb_merino", "animania:ewe_merino", "animania:ram_merino", "animania:lamb_jacob", "animania:ewe_jacob", "animania:ram_jacob", "quark:stoneling", "quark:archaeologist", "quark:foxhound", "quark:dweller", "quark:ashen", "quark:frog", "quark:pirate", "quark:crab", "quark:leash_knot", "aqua_creepers:aqua_creeper", "astralsorcery:entityflare", "astralsorcery:entityspectraltool", "astralsorcery:entityliquidspark", "cyclicmagic:robot", "bouncy_creepers:bouncy_creeper", "camels:camel", "emberroot:deers", "emberroot:sprouts", "emberroot:rainbowslime", "emberroot:rainbow_golem", "emberroot:hero", "emberroot:creeper", "emberroot:slime", "emberroot:dire_wolf", "emberroot:withercat", "emberroot:witherwitch", "emberroot:enderminy", "emberroot:knight_fallen", "emberroot:fallenmount", "emberroot:timberwolf", "emberroot:skeleton_frozen", "energeticsheep:energetic_sheep", "erebus:erebus.beetle_larva", "erebus:erebus.centipede", "erebus:erebus.beetle", "erebus:erebus.tarantula", "erebus:erebus.scorpion", "erebus:erebus.solifuge", "erebus:erebus.grasshopper", "erebus:erebus.rhino_beetle", "erebus:erebus.antlion", "erebus:erebus.black_widow", "erebus:erebus.glow_worm", "erebus:erebus.bombardier_beetle", "erebus:erebus.scytodes", "erebus:erebus.money_spider", "erebus:erebus.praying_mantis", "erebus:erebus.jumping_spider", "erebus:erebus.fire_ant", "erebus:erebus.velvet_worm", "erebus:erebus.titan_beetle", "erebus:erebus.bot_fly_larva", "erebus:erebus.fungal_weevil", "erebus:erebus.crop_weevil", "erebus:erebus.woodlouse", "erebus:erebus.fire_ant_soldier", "erebus:erebus.lava_web_spider", "erebus:erebus.antlion_mini_boss", "erebus:erebus.chameleon_tick", "erebus:erebus.solifuge_small", "erebus:erebus.punchroom", "erebus:erebus.crushroom", "erebus:erebus.black_ant", "erebus:erebus.zombie_ant", "erebus:erebus.tarantula_mini_boss", "erebus:erebus.tarantula_baby", "erebus:erebus.bog_maw", "erebus:erebus.magma_crawler", "erebus:erebus.animated_block", "erebus:erebus.animated_chest", "erebus:erebus.animated_bamboo_crate", "erebus:erebus.umber_golem", "erebus:erebus.umber_golem_idol", "erebus:erebus.antlion_boss", "erebus:erebus.honey_pot_ant", "erebus:erebus.bombardier_beetle_larva", "erebus:erebus.zombie_ant_soldier", "erebus:erebus.bed_bug", "erebus:erebus.stag_beetle", "erebus:erebus.gas_vent", "fossil:fossil.triceratops", "fossil:fossil.velociraptor", "fossil:fossil.tyrannosaurus", "fossil:fossil.stegosaurus", "fossil:fossil.dilophosaurus", "fossil:fossil.brachiosaurus", "fossil:fossil.spinosaurus", "fossil:fossil.compsognathus", "fossil:fossil.ankylosaurus", "fossil:fossil.pachycephalosaurus", "fossil:fossil.deinonychus", "fossil:fossil.gallimimus", "fossil:fossil.allosaurus", "fossil:fossil.sarcosuchus", "fossil:fossil.ceratosaurus", "fossil:fossil.dryosaurus", "fossil:fossil.therizinosaurus", "fossil:fossil.parasaurolophus", "fossil:fossil.citipati", "fossil:fossil.diplodocus", "fossil:fossil.ornitholestes", "fossil:fossil.dodo", "fossil:fossil.gastornis", "fossil:fossil.kelenken", "fossil:fossil.phorusrhacos", "fossil:fossil.titanis", "fossil:fossil.mammoth", "fossil:fossil.smilodon", "fossil:fossil.quagga", "fossil:fossil.elasmotherium", "fossil:fossil.megalania", "fossil:fossil.megaloceros", "fossil:fossil.platybelodon", "fossil:fossil.tiktaalik", "fossil:fossil.edaphosaurus", "fossil:fossil.arthropleura", "fossil:fossil.failuresaurus", "fossil:fossil.dinoegg", "fossil:fossil.friendlypigzombie", "fossil:fossil.anueffect", "fossil:fossil.anudead", "fossil:fossil.tarslime", "fossil:fossil.sentrypigman", "fossil:fossil.anubite", "fossil:fossil.anu", "fossil:fossil.debugtest", "fossil:fossil.debugtest_2", "fossil:fossil.toyball", "fossil:fossil.toytetheredlog", "fossil:fossil.toyscratchingpost", "iceologer:iceologer", "grue:entitygrue", "thaumadditions:chester", "thaumadditions:blue_wolf", "illagers_plus:furantur", "illagers_plus:hoarder", "illagers_plus:necromancer", "illagers_plus:illager_king", "illagers_plus:enchanter", "illagers_plus:archer", "industrialforegoing:pink_slime", "randomthings:goldenchicken", "testdummy:dummy", "openblocks:luggage", "openblocks:mini_me", "sophisticatedwolves:textures/entity/brown/wolf.png", "stupidthings:balloonliquid", "stupidthings:smokebomb", "stupidthings:blockbomb", "beneath:shadow", "thebetweenlands:dark_druid", "thebetweenlands:sludge", "thebetweenlands:swamp_hag", "thebetweenlands:wight", "thebetweenlands:sporeling", "thebetweenlands:leech", "thebetweenlands:blood_snail", "thebetweenlands:mire_snail", "thebetweenlands:mire_snail_egg", "thebetweenlands:lurker", "thebetweenlands:gecko", "thebetweenlands:termite", "thebetweenlands:toad", "thebetweenlands:frog", "thebetweenlands:gas_cloud", "thebetweenlands:tar_beast", "thebetweenlands:silt_crab", "thebetweenlands:pyrad", "thebetweenlands:peat_mummy", "thebetweenlands:tarminion", "thebetweenlands:mummy_arm", "thebetweenlands:fortress_boss", "thebetweenlands:fortress_boss_spawner", "thebetweenlands:fortress_boss_blockade", "thebetweenlands:fortress_boss_turret", "thebetweenlands:dreadful_mummy", "thebetweenlands:smoll_sludge", "thebetweenlands:greebling", "thebetweenlands:boulder_sprite", "thebetweenlands:spirit_tree_face_small", "thebetweenlands:spirit_tree_face_large", "thebetweenlands:tamed_spirit_tree_face", "thebetweenlands:root_sprite", "thebetweenlands:small_sludge_worm", "thebetweenlands:tiny_sludge_worm", "thebetweenlands:large_sludge_worm", "thebetweenlands:tiny_worm_egg_sac", "thebetweenlands:tiny_sludge_worm_helper", "thebetweenlands:shambler", "thebetweenlands:wall_lamprey", "thebetweenlands:moving_spawner_hole", "thebetweenlands:wall_living_root", "thebetweenlands:crypt_crawler", "thebetweenlands:barrishee", "thebetweenlands:ash_sprite", "thebetweenlands:triggered_falling_block", "thebetweenlands:triggered_sludge_wall_jet", "thebetweenlands:splodeshroom", "thebetweenlands:cc_ground_spawner", "thebetweenlands:emberling_shaman", "thebetweenlands:flame_jet", "thebetweenlands:emberling", "thebetweenlands:wild_emberling", "thebetweenlands:sludge_menace", "thebetweenlands:draeton_dragonfly", "thebetweenlands:draeton_firefly", "thebetweenlands:draeton_chiromaw_tamed", "thebetweenlands:chiromaw_greebling_rider", "thebetweenlands:worm_ground_spawner", "thebetweenlands:chiromaw_matriarch", "thebetweenlands:chiromaw_hatchling", "thebetweenlands:chiromaw_tame", "thebetweenlands:stalker", "thebetweenlands:swarm", "mysticalworld:entity_fox", "mysticalworld:entity_frog", "mysticalworld:entity_beetle", "mysticalworld:entity_sprout", "mysticalworld:entity_hell_sprout", "mysticalworld:entity_deer", "mysticalworld:entity_spirit_deer", "mysticalworld:entity_spirit_beetle", "mysticalworld:entity_endermini", "mysticalworld:entity_lava_cat", "mysticalworld:entity_silkworm", "mysticalworld:entity_clam", "mysticalworld:entity_lurker", "thaumcraft:cultistportalgreater", "thaumcraft:cultistportallesser", "thaumcraft:turretbasic", "thaumcraft:turretadvanced", "thaumcraft:arcanebore", "thaumcraft:golem", "thaumcraft:eldritchwarden", "thaumcraft:eldritchgolem", "thaumcraft:cultistleader", "thaumcraft:taintaclegiant", "thaumcraft:brainyzombie", "thaumcraft:giantbrainyzombie", "thaumcraft:spellbat", "thaumcraft:pech", "thaumcraft:mindspider", "thaumcraft:eldritchguardian", "thaumcraft:cultistknight", "thaumcraft:cultistcleric", "thaumcraft:eldritchcrab", "thaumcraft:inhabitedzombie", "thaumcraft:thaumslime", "thaumcraft:taintcrawler", "thaumcraft:taintacle", "thaumcraft:taintacletiny", "thaumcraft:taintswarm", "thaumcraft:taintseed", "thaumcraft:taintseedprime", "natura:imp", "natura:heatscarspider", "natura:babyheatscarspider", "natura:nitrocreeper", "tconstruct:blueslime", "ebwizardry:zombie_minion", "ebwizardry:husk_minion", "ebwizardry:skeleton_minion", "ebwizardry:stray_minion", "ebwizardry:spider_minion", "ebwizardry:wither_skeleton_minion", "ebwizardry:silverfish_minion", "ebwizardry:spirit_wolf", "ebwizardry:spirit_horse", "ebwizardry:ice_giant", "ebwizardry:magic_slime", "ebwizardry:decoy", "ebwizardry:wizard", "ebwizardry:evil_wizard", "mowziesmobs:foliaath", "mowziesmobs:baby_foliaath", "mowziesmobs:ferrous_wroughtnaut", "mowziesmobs:barakoan_barakoana", "mowziesmobs:barakoana", "mowziesmobs:barakoaya", "mowziesmobs:barakoan_player", "mowziesmobs:barako", "mowziesmobs:frostmaw", "mowziesmobs:grottol", "betteranimalsplus:brownbear", "betteranimalsplus:blackbear", "betteranimalsplus:deer", "betteranimalsplus:feralwolf", "betteranimalsplus:coyote", "betteranimalsplus:fox", "betteranimalsplus:tarantula", "betteranimalsplus:hirschgeist", "betteranimalsplus:goat", "betteranimalsplus:pheasant", "betteranimalsplus:reindeer", "betteranimalsplus:boar", "betteranimalsplus:squirrel", "betteranimalsplus:badger", "betteranimalsplus:crab", "betteranimalsplus:horseshoecrab", "betteranimalsplus:moose", "betteranimalsplus:turkey", "betteranimalsplus:goose", "betteranimalsplus:walrus", "betteranimalsplus:kermodebear", "bewitchment:lizard", "bewitchment:snake", "bewitchment:toad", "bewitchment:black_dog", "bewitchment:ghost", "bewitchment:hellhound", "bewitchment:feuerwurm", "bewitchment:werewolf", "bewitchment:cleaver", "bewitchment:demon", "bewitchment:demoness", "bewitchment:imp", "bewitchment:bafometyr", "bewitchment:shadow_person", "bewitchment:cambion", "bewitchment:druden", "bewitchment:baphomet", "bewitchment:leonard", "bloodmagic:sentient_specter", "bloodmagic:mimic", "bloodmagic:corrupted_zombie", "bloodmagic:corrupted_sheep", "bloodmagic:corrupted_chicken", "bloodmagic:corrupted_spider", "cqrepoured:slime_part", "cqrepoured:dummy", "cqrepoured:dwarf", "cqrepoured:enderman", "cqrepoured:gremlin", "cqrepoured:goblin", "cqrepoured:golem", "cqrepoured:human", "cqrepoured:illager", "cqrepoured:npc", "cqrepoured:minotaur", "cqrepoured:mandril", "cqrepoured:mummy", "cqrepoured:ogre", "cqrepoured:orc", "cqrepoured:boarman", "cqrepoured:pirate", "cqrepoured:skeleton", "cqrepoured:spectre", "cqrepoured:triton", "cqrepoured:walker", "cqrepoured:zombie", "cqrepoured:giant_endermite", "cqrepoured:giant_silverfish", "cqrepoured:giant_silverfish1", "cqrepoured:giant_silverfish2", "cqrepoured:giant_tortoise", "cqrepoured:lich", "cqrepoured:boar_mage", "cqrepoured:necromancer", "cqrepoured:walker_king", "cqrepoured:pirate_captain", "cqrepoured:giant_spider", "cqrepoured:illusion_walker_king", "enderskills:animated_stone_golem", "enderskills:voltaic_sentinel", "mod_lavacow:lavacow", "mod_lavacow:zombiemushroom", "mod_lavacow:parasite", "mod_lavacow:foglet", "mod_lavacow:zombiefrozen", "mod_lavacow:undeadswine", "mod_lavacow:salamander", "mod_lavacow:ithaqua", "mod_lavacow:mimic", "mod_lavacow:sludgelord", "mod_lavacow:lilsludge", "mod_lavacow:scarecrow", "mod_lavacow:vespacocoon", "mod_lavacow:boneworm", "mod_lavacow:pingu", "mod_lavacow:undertaker", "mod_lavacow:unburied", "mod_lavacow:banshee", "mod_lavacow:weta", "mod_lavacow:avaton", "mekanism:robit", "mekanism:babyskeleton", "iceandfire:dragonegg", "iceandfire:dragonskull", "iceandfire:snowvillager", "iceandfire:stonestatue", "iceandfire:gorgon", "iceandfire:cyclops", "iceandfire:deathworm", "iceandfire:if_cockatrice", "iceandfire:if_troll", "iceandfire:myrmex_worker", "iceandfire:myrmex_soldier", "iceandfire:myrmex_sentinel", "iceandfire:myrmex_royal", "iceandfire:myrmex_queen", "iceandfire:myrmex_egg", "iceandfire:myrmex_swarmer", "iceandfire:if_mob_skull", "iceandfire:dread_thrall", "iceandfire:dread_ghoul", "iceandfire:dread_beast", "iceandfire:dread_scuttler", "iceandfire:dread_lich", "iceandfire:dread_knight", "iceandfire:dread_horse", "iceandfire:if_hydra", "mahoutsukai:familiar_entity", "mahoutsukai:kodoku_entity", "mutantbeasts:creeper_minion", "mutantbeasts:endersoul_clone", "mutantbeasts:mutant_creeper", "mutantbeasts:mutant_enderman", "mutantbeasts:mutant_skeleton", "mutantbeasts:mutant_snow_golem", "mutantbeasts:mutant_zombie", "mutantbeasts:spider_pig", "mysticalwildlife:vrontausaurus", "mysticalwildlife:yaga_hog", "mysticalwildlife:dusk_lurker", "mysticalwildlife:cicaptera_azure", "mysticalwildlife:cicaptera_verdant", "mysticalwildlife:cicaptera_crimson", "mysticalwildlife:cicaptera_sandy", "mysticalwildlife:cicaptera_wintry", "mysticalwildlife:cicaptera_lovely", "mysticalwildlife:plumper", "mysticalwildlife:krill", "netherex:pigtificate_leader", "netherex:pigtificate", "netherex:gold_golem", "netherex:mogus", "netherex:salamander", "netherex:wight", "netherex:ember", "netherex:nethermite", "netherex:spinout", "netherex:spore_creeper", "netherex:spore", "netherex:coolmar_spider", "netherex:brute", "netherex:frost", "pneumaticcraft:programmable_controller", "rats:rat", "rats:illager_piper", "rats:marbled_cheese_golem", "rats:feral_ratlantean", "rats:neo_ratlantean", "rats:pirat", "rats:plague_doctor", "rats:black_death", "rats:plague_beast", "srparasites:dorpa", "srparasites:infhuman", "srparasites:infcow", "srparasites:infsheep", "srparasites:infwolf", "srparasites:infpig", "srparasites:infvillager", "srparasites:infsheephead", "srparasites:infwolfhead", "srparasites:infcowhead", "srparasites:infpighead", "srparasites:infvillagerhead", "srparasites:rathol", "srparasites:lodo", "srparasites:mudo", "srparasites:anged", "srparasites:ganro", "srparasites:venkrol", "srparasites:venkrolsii", "srparasites:venkrolsiii", "srparasites:tonro", "srparasites:unvo", "srparasites:lesh", "srparasites:shyco", "srparasites:hull", "srparasites:nogla", "srparasites:canra", "srparasites:bano", "srparasites:shycoadapted", "srparasites:hulladapted", "srparasites:noglaadapted", "srparasites:canraadapted", "srparasites:banoadapted", "srparasites:terla", "srparasites:ancientpod", "srparasites:oroncoten", "srparasites:homming", "thaumicaugmentation:autocaster", "thaumicaugmentation:autocaster_eldritch", "thaumicaugmentation:eldritch_guardian", "thaumicaugmentation:eldritch_warden", "thaumicaugmentation:eldritch_golem", "thaumicwonders:corruption_avatar", "treasure2:wood_mimic", "treasure2:pirate_mimic", "treasure2:bound_soul", "waddles:adelie_penguin", "nuclearcraft:feral_ghoul", "inventorypets:entityminiquantumenderman", "inventorypets:entitybillgates", "inventorypets:entitysteveballmer", "inventorypets:entitysatyanadella", "inventorypets:entitylivinganvil", "inventorypets:entitylivingbed", "mob_mash:mothman", "mob_mash:reptomaniac", "mob_mash:crocoduck", "mob_mash:meme", "mob_mash:nomad", "mob_mash:slagmite", "mob_mash:sandworm", "mob_mash:pirate", "mob_mash:undead_nomad", "mob_mash:skeleton_pirate", "mob_mash:doppelganger", "mob_mash:grizzlybear", "mob_mash:cursedtool", "mob_mash:chupacabra", "specialmobs:specialcreeper", "specialmobs:darkcreeper", "specialmobs:deathcreeper", "specialmobs:dirtcreeper", "specialmobs:doomcreeper", "specialmobs:drowningcreeper", "specialmobs:endercreeper", "specialmobs:firecreeper", "specialmobs:gravelcreeper", "specialmobs:jumpingcreeper", "specialmobs:lightningcreeper", "specialmobs:minicreeper", "specialmobs:splittingcreeper", "specialmobs:specialzombie", "specialmobs:brutezombie", "specialmobs:firezombie", "specialmobs:fishingzombie", "specialmobs:giantzombie", "specialmobs:hungryzombie", "specialmobs:huskzombie", "specialmobs:plaguezombie", "specialmobs:specialpigzombie", "specialmobs:brutepigzombie", "specialmobs:fishingpigzombie", "specialmobs:giantpigzombie", "specialmobs:hungrypigzombie", "specialmobs:knightpigzombie", "specialmobs:plaguepigzombie", "specialmobs:vampirepigzombie", "specialmobs:specialskeleton", "specialmobs:bruteskeleton", "specialmobs:fireskeleton", "specialmobs:gatlingskeleton", "specialmobs:giantskeleton", "specialmobs:knightskeleton", "specialmobs:ninjaskeleton", "specialmobs:poisonskeleton", "specialmobs:sniperskeleton", "specialmobs:spitfireskeleton", "specialmobs:strayskeleton", "specialmobs:specialwitherskeleton", "specialmobs:brutewitherskeleton", "specialmobs:gatlingwitherskeleton", "specialmobs:giantwitherskeleton", "specialmobs:knightwitherskeleton", "specialmobs:ninjawitherskeleton", "specialmobs:sniperwitherskeleton", "specialmobs:spitfirewitherskeleton", "specialmobs:specialslime", "specialmobs:blackberryslime", "specialmobs:blueberryslime", "specialmobs:caramelslime", "specialmobs:grapeslime", "specialmobs:lemonslime", "specialmobs:strawberryslime", "specialmobs:watermelonslime", "specialmobs:speciallavaslime", "specialmobs:flyinglavaslime", "specialmobs:hardenedlavaslime", "specialmobs:stickylavaslime", "specialmobs:volatilelavaslime", "specialmobs:specialspider", "specialmobs:babyspider", "specialmobs:desertspider", "specialmobs:flyingspider", "specialmobs:giantspider", "specialmobs:hungryspider", "specialmobs:motherspider", "specialmobs:palespider", "specialmobs:poisonspider", "specialmobs:webspider", "specialmobs:witchspider", "specialmobs:specialcavespider", "specialmobs:babycavespider", "specialmobs:flyingcavespider", "specialmobs:mothercavespider", "specialmobs:webcavespider", "specialmobs:witchcavespider", "specialmobs:specialsilverfish", "specialmobs:blindingsilverfish", "specialmobs:fishingsilverfish", "specialmobs:flyingsilverfish", "specialmobs:poisonsilverfish", "specialmobs:toughsilverfish", "specialmobs:specialenderman", "specialmobs:blindingenderman", "specialmobs:icyenderman", "specialmobs:lightningenderman", "specialmobs:minienderman", "specialmobs:mirageenderman", "specialmobs:thiefenderman", "specialmobs:specialwitch", "specialmobs:dominationwitch", "specialmobs:shadowswitch", "specialmobs:undeadwitch", "specialmobs:wildswitch", "specialmobs:windwitch"};
    private static final List<ResourceLocation> TARGETABLE_GROUND = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> TARGETABLE_AIR = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> TARGETABLE_WATER = new ArrayList<ResourceLocation>();

    public static void initializePostInit() {
        if (groundRegenerate) {
            groundEntities = (String[])EntityList.func_180124_b().stream().filter(nm -> {
                Stream<String> feStr = Arrays.stream(flyingEntities);
                Stream<String> weStr = Arrays.stream(waterEntities);
                String nmStr = nm.toString();
                Class c = EntityList.getClass((ResourceLocation)nm);
                if (c == null) return false;
                if (!EntityLiving.class.isAssignableFrom(c)) return false;
                if (!feStr.noneMatch(nmStr::equals)) return false;
                if (!weStr.noneMatch(nmStr::equals)) return false;
                if (ITurretInst.class.isAssignableFrom(c)) return false;
                if (EntityLiving.class.equals((Object)c)) return false;
                if (Entity.class.equals((Object)c)) return false;
                return true;
            }).map(ResourceLocation::toString).toArray(String[]::new);
            groundEntities = (String[])ArrayUtils.addAll((Object[])groundEntities, (Object[])Arrays.stream(guaranteedGround).filter(v -> Arrays.stream(groundEntities).noneMatch(g -> g.equals(v))).toArray(String[]::new));
        }
        TargetList.finalizeWhitelists();
    }

    private static void finalizeWhitelists() {
        TARGETABLE_GROUND.clear();
        TARGETABLE_AIR.clear();
        TARGETABLE_WATER.clear();
        TARGETABLE_GROUND.addAll(Arrays.stream(groundEntities).map(ResourceLocation::new).collect(Collectors.toList()));
        TARGETABLE_AIR.addAll(Arrays.stream(flyingEntities).map(ResourceLocation::new).collect(Collectors.toList()));
        TARGETABLE_WATER.addAll(Arrays.stream(waterEntities).map(ResourceLocation::new).collect(Collectors.toList()));
        groundRegenerate = false;
        TmrConfig.Targets.reset();
    }

    public static boolean isEntityTargetable(ResourceLocation res, ITurret.AttackType type) {
        switch (type) {
            case ALL: {
                return Stream.of(TARGETABLE_GROUND.stream(), TARGETABLE_AIR.stream(), TARGETABLE_WATER.stream()).flatMap(s -> s).anyMatch(r -> r.equals((Object)res));
            }
            case GROUND: {
                return TARGETABLE_GROUND.stream().anyMatch(r -> r.equals((Object)res));
            }
            case AIR: {
                return TARGETABLE_AIR.stream().anyMatch(r -> r.equals((Object)res));
            }
            case WATER: {
                return TARGETABLE_WATER.stream().anyMatch(r -> r.equals((Object)res));
            }
        }
        return false;
    }

    public static Map<ResourceLocation, Boolean> getStandardTargetList(ITurret.AttackType type) {
        Set entities;
        switch (type) {
            case ALL: {
                entities = Stream.of(TARGETABLE_GROUND.stream(), TARGETABLE_AIR.stream(), TARGETABLE_WATER.stream()).flatMap(s -> s).collect(Collectors.toCollection(LinkedHashSet::new));
                break;
            }
            case GROUND: {
                entities = new LinkedHashSet<ResourceLocation>(TARGETABLE_GROUND);
                break;
            }
            case AIR: {
                entities = new LinkedHashSet<ResourceLocation>(TARGETABLE_AIR);
                break;
            }
            case WATER: {
                entities = new LinkedHashSet<ResourceLocation>(TARGETABLE_WATER);
                break;
            }
            default: {
                entities = Collections.emptySet();
            }
        }
        return entities.stream().filter(e -> !Entity.class.equals(MiscUtils.defIfNull((Object)EntityList.getClass((ResourceLocation)e), Entity.class))).collect(Collectors.toMap(Function.identity(), e -> {
            Class entityCls = EntityList.getClass((ResourceLocation)e);
            return entityCls != null && IMob.class.isAssignableFrom(entityCls);
        }));
    }
}

