/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.InventoryUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.event.TargetingEvent;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.entity.turret.TargetList;
import de.sanandrew.mods.turretmod.item.ItemAmmoCartridge;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.world.PlayerList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public final class TargetProcessor
implements ITargetProcessor {
    private final Map<ResourceLocation, Boolean> entityTargetList = new HashMap<ResourceLocation, Boolean>();
    private final Map<UUID, Boolean> playerTargetList = new HashMap<UUID, Boolean>();
    private final ITurretInst turret;
    private int ammoCount;
    @Nonnull
    private ItemStack ammoStack;
    private int shootTicks;
    private int initShootTicks;
    private Entity entityToAttack;
    private UUID entityToAttackUUID;
    private boolean isShootingClt;
    private boolean isBlacklistEntity = false;
    private boolean isBlacklistPlayer = false;
    private long processTicks = 0L;

    TargetProcessor(ITurretInst turret) {
        this.turret = turret;
        this.initShootTicks = 20;
        this.ammoStack = ItemStack.field_190927_a;
    }

    public void init() {
        this.entityTargetList.putAll(TargetList.getStandardTargetList(this.turret.getAttackType()));
        this.playerTargetList.putAll(PlayerList.INSTANCE.getDefaultPlayerList());
    }

    @Override
    public boolean addAmmo(@Nonnull ItemStack stack) {
        return this.addAmmo(stack, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean addAmmo(@Nonnull ItemStack stack, ICapabilityProvider excessInv) {
        int maxCapacity;
        String subtype;
        if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            return ItemAmmoCartridge.extractAmmoStacks(stack, this, true);
        }
        if (!this.isAmmoApplicable(stack)) return false;
        IAmmunition type = AmmunitionRegistry.INSTANCE.getObject(stack);
        if (!this.isAmmoTypeEqual(type, subtype = (String)MiscUtils.defIfNull((Object)AmmunitionRegistry.INSTANCE.getSubtype(stack), (Object)""))) {
            if (excessInv != null) {
                this.putAmmoInInventory(excessInv);
            } else {
                this.dropAmmo();
            }
        }
        if ((maxCapacity = this.getMaxAmmoCapacity() - this.ammoCount) <= 0) return false;
        if (!this.hasAmmo()) {
            this.ammoStack = AmmunitionRegistry.INSTANCE.getItem(type.getId(), subtype);
        } else if (!AmmunitionRegistry.INSTANCE.isEqual(stack, this.ammoStack)) {
            return false;
        }
        int provided = type.getAmmoCapacity();
        int providedStack = stack.func_190916_E() * provided;
        if (providedStack - maxCapacity > 0) {
            int stackSub = MathHelper.func_76128_c((double)((double)maxCapacity / (double)providedStack * (double)stack.func_190916_E()));
            if (stackSub <= 0) return false;
            this.ammoCount += stackSub * provided;
            stack.func_190918_g(stackSub);
            return true;
        } else {
            this.ammoCount += providedStack;
            stack.func_190920_e(0);
        }
        return true;
    }

    @Override
    public int getAmmoCount() {
        return this.ammoCount;
    }

    @Override
    @Nonnull
    public ItemStack getAmmoStack() {
        if (ItemStackUtils.isValid((ItemStack)this.ammoStack)) {
            return this.ammoStack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public void setAmmoStackInternal(ItemStack stack) {
        this.ammoStack = stack;
    }

    public void setAmmoStackInternal(ItemStack stack, int count) {
        this.ammoStack = stack;
        this.ammoCount = count;
    }

    @Override
    public boolean hasAmmo() {
        return ItemStackUtils.isValid((ItemStack)this.ammoStack) && this.ammoCount > 0;
    }

    @Override
    public void dropExcessAmmo() {
        int decrAmmo;
        if (this.hasAmmo() && (decrAmmo = this.ammoCount - this.getMaxAmmoCapacity()) > 0) {
            NonNullList items = NonNullList.func_191196_a();
            IAmmunition type = AmmunitionRegistry.INSTANCE.getObject(this.ammoStack);
            int maxStackSize = this.ammoStack.func_77976_d();
            while (decrAmmo > 0 && type.isValid()) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.func_190920_e(Math.min(decrAmmo / type.getAmmoCapacity(), maxStackSize));
                decrAmmo -= stack.func_190916_E() * type.getAmmoCapacity();
                if (stack.func_190916_E() <= 0) break;
                items.add((Object)stack);
            }
            this.ammoCount = this.getMaxAmmoCapacity();
            this.spawnItemEntities((NonNullList<ItemStack>)items);
        }
    }

    @Override
    public void decrAmmo() {
        TargetingEvent.ConsumeAmmo event = new TargetingEvent.ConsumeAmmo(this, this.ammoStack, 1);
        if (!TARGET_BUS.post((Event)event) && event.getResult() != Event.Result.DENY) {
            this.ammoCount -= event.consumeAmount;
            if (this.ammoCount < 0) {
                this.ammoCount = 0;
            }
        }
    }

    public NonNullList<ItemStack> extractAmmoItems() {
        NonNullList items = NonNullList.func_191196_a();
        int maxStackSize = this.ammoStack.func_77976_d();
        IAmmunition type = AmmunitionRegistry.INSTANCE.getObject(this.ammoStack);
        while (this.ammoCount > 0 && type.isValid()) {
            ItemStack stack = this.ammoStack.func_77946_l();
            stack.func_190920_e(Math.min(this.ammoCount / type.getAmmoCapacity(), maxStackSize));
            this.ammoCount -= stack.func_190916_E() * type.getAmmoCapacity();
            if (stack.func_190916_E() <= 0) {
                this.ammoCount = 0;
                break;
            }
            items.add((Object)stack);
        }
        return items;
    }

    private void spawnItemEntities(NonNullList<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            EntityLiving turretL = this.turret.get();
            stacks.forEach(stack -> {
                EntityItem item = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, stack);
                turretL.field_70170_p.func_72838_d((Entity)item);
            });
        }
    }

    void dropAmmo() {
        if (this.hasAmmo()) {
            NonNullList<ItemStack> items = this.extractAmmoItems();
            this.ammoStack = ItemStack.field_190927_a;
            this.spawnItemEntities(items);
        }
    }

    @Override
    public void putAmmoInInventory(ICapabilityProvider inventory) {
        if (this.hasAmmo()) {
            NonNullList<ItemStack> items = this.extractAmmoItems();
            this.ammoStack = ItemStack.field_190927_a;
            if (!items.isEmpty()) {
                EntityLiving turretL = this.turret.get();
                for (ItemStack stack : items) {
                    if (!ItemStackUtils.isValid((ItemStack)(stack = InventoryUtils.addStackToCapability((ItemStack)stack, (ICapabilityProvider)inventory, (EnumFacing)EnumFacing.UP, (boolean)false)))) continue;
                    EntityItem item = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, stack);
                    turretL.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    @Override
    public boolean isAmmoApplicable(@Nonnull ItemStack stack) {
        return this.getAmmoApplyType(stack) != ITargetProcessor.ApplyType.NOT_COMPATIBLE;
    }

    @Override
    public ITargetProcessor.ApplyType getAmmoApplyType(@Nonnull ItemStack stack) {
        IAmmunition stackType;
        if (ItemStackUtils.isValid((ItemStack)stack) && (stackType = AmmunitionRegistry.INSTANCE.getObject(stack)).isValid()) {
            if (this.isAmmoTypeEqual(stackType, AmmunitionRegistry.INSTANCE.getSubtype(stack))) {
                return this.ammoCount < this.getMaxAmmoCapacity() ? ITargetProcessor.ApplyType.ADD : ITargetProcessor.ApplyType.NOT_COMPATIBLE;
            }
            Collection<IAmmunition> types = AmmunitionRegistry.INSTANCE.getObjects(this.turret.getTurret());
            return types.contains(stackType) ? ITargetProcessor.ApplyType.REPLACE : ITargetProcessor.ApplyType.NOT_COMPATIBLE;
        }
        return ITargetProcessor.ApplyType.NOT_COMPATIBLE;
    }

    private boolean isAmmoTypeEqual(IAmmunition ammo, String subtype) {
        subtype = subtype != null ? subtype : "";
        IAmmunition currType = AmmunitionRegistry.INSTANCE.getObject(this.ammoStack);
        String currSubtype = (String)MiscUtils.defIfNull((Object)AmmunitionRegistry.INSTANCE.getSubtype(this.ammoStack), (Object)"");
        return currType.getId().equals((Object)ammo.getId()) && subtype.equals(currSubtype);
    }

    @Override
    public final int getMaxAmmoCapacity() {
        return MathHelper.func_76143_f((double)this.turret.get().func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111126_e());
    }

    @Override
    public final int getMaxShootTicks() {
        return MathHelper.func_76143_f((double)this.turret.get().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111126_e());
    }

    @Override
    public final boolean isShooting() {
        return this.initShootTicks <= 0 || this.isShootingClt;
    }

    @Override
    public boolean canShoot() {
        return this.initShootTicks <= 0 && this.shootTicks == 0;
    }

    @Override
    public void setShot(boolean success) {
        this.shootTicks = success ? this.getMaxShootTicks() : this.getMaxInitShootTicks();
    }

    @Override
    public void decrInitShootTicks() {
        --this.initShootTicks;
    }

    @Override
    public void resetInitShootTicks() {
        this.initShootTicks = this.getMaxInitShootTicks();
    }

    private int getMaxInitShootTicks() {
        return (int)Math.round(this.turret.get().func_110148_a(TurretAttributes.MAX_INIT_SHOOT_TICKS).func_111126_e());
    }

    @Override
    public Entity getProjectile() {
        if (this.hasAmmo()) {
            IAmmunition ammo = AmmunitionRegistry.INSTANCE.getObject(this.ammoStack);
            String ammoSubtype = AmmunitionRegistry.INSTANCE.getSubtype(this.ammoStack);
            IProjectile proj = ammo.getProjectile(this.turret);
            if (proj != null) {
                double attackModifier = this.turret.get().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                if (this.entityToAttack != null) {
                    return new EntityTurretProjectile(this.turret.get().field_70170_p, proj, ammo, ammoSubtype, (EntityTurret)this.turret, this.entityToAttack, attackModifier);
                }
                return new EntityTurretProjectile(this.turret.get().field_70170_p, proj, ammo, ammoSubtype, (EntityTurret)this.turret, this.turret.get().func_70040_Z(), attackModifier);
            }
        }
        return null;
    }

    @Override
    public double getRangeVal() {
        AxisAlignedBB aabb = this.getAdjustedRange(false);
        return Math.max(aabb.field_72336_d - aabb.field_72340_a, Math.max(aabb.field_72337_e - aabb.field_72338_b, aabb.field_72334_f - aabb.field_72339_c)) / 2.0;
    }

    @Override
    public AxisAlignedBB getAdjustedRange(boolean doOffset) {
        AxisAlignedBB aabb = this.turret.getRangeBB();
        EntityLiving turretL = this.turret.get();
        return doOffset ? aabb.func_72317_d(turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v) : aabb;
    }

    private boolean checkTargetListeners(Entity e) {
        TargetingEvent.TargetCheck event = new TargetingEvent.TargetCheck(this, e);
        return !TARGET_BUS.post((Event)event) && event.getResult() != Event.Result.DENY;
    }

    @Override
    public boolean shootProjectile() {
        TargetingEvent.Shooting event = new TargetingEvent.Shooting(this);
        if (TARGET_BUS.post((Event)event)) {
            return event.getResult() != Event.Result.DENY;
        }
        Entity projectile = this.getProjectile();
        if (projectile != null) {
            this.turret.get().field_70170_p.func_72838_d(projectile);
            this.playSound(this.turret.getShootSound(), 1.8f);
            this.turret.setShooting();
            this.decrAmmo();
            return event.getResult() != Event.Result.DENY;
        }
        this.playSound(this.turret.getNoAmmoSound(), 1.0f);
        return event.getResult() == Event.Result.ALLOW;
    }

    @Override
    public void playSound(SoundEvent sound, float volume) {
        EntityLiving turretL = this.turret.get();
        float pitch = 1.0f / (turretL.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f;
        turretL.field_70170_p.func_184148_a(null, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch);
    }

    @Override
    public void onTick() {
        boolean changed = false;
        EntityLiving turretL = this.turret.get();
        if (!this.turret.isActive()) {
            if (this.entityToAttack != null || this.entityToAttackUUID != null) {
                this.resetInitShootTicks();
                this.entityToAttack = null;
                this.entityToAttackUUID = null;
                this.turret.updateState();
            }
            return;
        }
        if (this.shootTicks > 0) {
            --this.shootTicks;
        }
        if (this.entityToAttack == null && this.entityToAttackUUID != null) {
            this.entityToAttack = EntityUtils.getEntityByUUID((World)turretL.field_70170_p, (UUID)this.entityToAttackUUID);
        }
        AxisAlignedBB aabb = this.getAdjustedRange(true);
        if (TARGET_BUS.post((Event)new TargetingEvent.ProcessorTick(this, this.processTicks))) {
            return;
        }
        if (this.processTicks++ % 10L == 0L && this.entityToAttack == null) {
            for (Entity entityObj : this.getValidTargetList(aabb)) {
                if (!this.checkTargetListeners(entityObj)) continue;
                this.entityToAttack = entityObj;
                this.entityToAttackUUID = entityObj.func_110124_au();
                changed = true;
                break;
            }
        }
        if (this.entityToAttack != null) {
            if (this.isEntityValidTarget(this.entityToAttack, aabb) && this.checkTargetListeners(this.entityToAttack)) {
                if (this.canShoot()) {
                    this.setShot(this.shootProjectile());
                    changed = true;
                } else if (this.initShootTicks > 0) {
                    this.decrInitShootTicks();
                }
            } else {
                this.resetInitShootTicks();
                this.entityToAttack = null;
                this.entityToAttackUUID = null;
                changed = true;
            }
        }
        if (changed) {
            this.turret.updateState();
        }
    }

    @Override
    public void onTickClient() {
        if (this.entityToAttack != null && !this.entityToAttack.func_70089_S()) {
            this.entityToAttackUUID = null;
            this.entityToAttack = null;
        }
    }

    @Override
    public boolean isEntityBlacklist() {
        return this.isBlacklistEntity;
    }

    @Override
    public boolean isPlayerBlacklist() {
        return this.isBlacklistPlayer;
    }

    @Override
    public void setEntityBlacklist(boolean isBlacklist) {
        this.isBlacklistEntity = isBlacklist;
    }

    @Override
    public void setPlayerBlacklist(boolean isBlacklist) {
        this.isBlacklistPlayer = isBlacklist;
    }

    @Override
    public boolean isEntityValidTarget(Entity entity) {
        return this.isEntityValidTarget(entity, this.getAdjustedRange(true));
    }

    @Override
    public List<Entity> getValidTargetList() {
        return this.getValidTargetList(this.getAdjustedRange(true));
    }

    @Override
    public boolean isEntityTargeted(Entity entity) {
        if (entity instanceof EntityPlayer) {
            UUID id = entity.func_110124_au();
            return this.playerTargetList.containsKey(id) && this.isBlacklistPlayer ^ this.isPlayerTargeted(id);
        }
        ResourceLocation id = EntityList.func_191306_a(entity.getClass());
        return this.entityTargetList.containsKey(id) && this.isBlacklistEntity ^ this.isEntityTargeted(id);
    }

    private List<Entity> getValidTargetList(AxisAlignedBB aabb) {
        return this.turret.get().field_70170_p.func_175674_a((Entity)this.turret.get(), aabb, entity -> this.isEntityValidTarget((Entity)entity, aabb));
    }

    private boolean isEntityValidTarget(Entity entity, AxisAlignedBB aabb) {
        return this.isEntityTargeted(entity) && entity.func_70089_S() && entity.func_174813_aQ().func_72326_a(aabb) && (this.turret.getTurret().canSeeThroughBlocks() || this.turret.get().func_70685_l(entity));
    }

    @Override
    public boolean isPlayerTargeted(UUID id) {
        return Boolean.TRUE.equals(this.playerTargetList.get(id));
    }

    @Override
    public boolean isEntityTargeted(ResourceLocation id) {
        return Boolean.TRUE.equals(this.entityTargetList.get(id));
    }

    @Override
    public ITurretInst getTurretInst() {
        return this.turret;
    }

    @Override
    public boolean hasTarget() {
        return this.entityToAttack != null;
    }

    @Override
    public Entity getTarget() {
        return this.entityToAttack;
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74768_a("ammoCount", this.ammoCount);
        if (ItemStackUtils.isValid((ItemStack)this.ammoStack)) {
            NBTTagCompound stackTag = new NBTTagCompound();
            this.ammoStack.func_77955_b(stackTag);
            nbt.func_74782_a("ammoStack", (NBTBase)stackTag);
        }
        if (this.entityToAttackUUID != null) {
            nbt.func_74778_a("targetUUID", this.entityToAttackUUID.toString());
        }
        nbt.func_74757_a("entityBlacklist", this.isBlacklistEntity);
        nbt.func_74757_a("playerBlacklist", this.isBlacklistPlayer);
        NBTTagList entityTargets = new NBTTagList();
        for (Map.Entry<ResourceLocation, Boolean> res : this.getEntityTargets().entrySet()) {
            NBTTagCompound entityEntry = new NBTTagCompound();
            entityEntry.func_74778_a("ID", res.getKey().toString());
            entityEntry.func_74757_a("Enabled", res.getValue().booleanValue());
            entityTargets.func_74742_a((NBTBase)entityEntry);
        }
        nbt.func_74782_a("EntityTargetsCMP", (NBTBase)entityTargets);
        NBTTagList playerTargets = new NBTTagList();
        for (Map.Entry<UUID, Boolean> res : this.getPlayerTargets().entrySet()) {
            NBTTagCompound playerEntry = new NBTTagCompound();
            playerEntry.func_74778_a("ID", res.getKey().toString());
            playerEntry.func_74757_a("Enabled", res.getValue().booleanValue());
            playerTargets.func_74742_a((NBTBase)playerEntry);
        }
        nbt.func_74782_a("PlayerTargetsCMP", (NBTBase)playerTargets);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        NBTTagList list;
        int i;
        NBTTagList list2;
        if (nbt == null) {
            return;
        }
        this.ammoCount = nbt.func_74762_e("ammoCount");
        if (nbt.func_74764_b("ammoStack")) {
            this.ammoStack = new ItemStack(nbt.func_74775_l("ammoStack"));
        }
        if (nbt.func_74764_b("targetUUID")) {
            this.entityToAttackUUID = UUID.fromString(nbt.func_74779_i("targetUUID"));
        }
        this.isBlacklistEntity = nbt.func_74767_n("entityBlacklist");
        this.isBlacklistPlayer = nbt.func_74767_n("playerBlacklist");
        if (nbt.func_74764_b("entityTargets")) {
            ArrayList<Class> entityTgt = new ArrayList<Class>();
            list2 = nbt.func_150295_c("entityTargets", 8);
            for (i = 0; i < list2.func_74745_c(); ++i) {
                Class cls = ReflectionUtils.getClass((String)list2.func_150307_f(i));
                if (cls == null) continue;
                entityTgt.add(cls);
            }
            this.updateEntityTargets((ResourceLocation[])entityTgt.stream().map(EntityList::func_191306_a).toArray(ResourceLocation[]::new));
        } else {
            list = nbt.func_150295_c("EntityTargetsCMP", 10);
            for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
                NBTTagCompound tag = list.func_150305_b(i2);
                this.updateEntityTarget(new ResourceLocation(tag.func_74779_i("ID")), tag.func_74767_n("Enabled"));
            }
        }
        if (nbt.func_74764_b("playerTargets")) {
            ArrayList<UUID> playerTgt = new ArrayList<UUID>();
            list2 = nbt.func_150295_c("playerTargets", 8);
            for (i = 0; i < list2.func_74745_c(); ++i) {
                try {
                    UUID id = UUID.fromString(list2.func_150307_f(i));
                    if (id.equals(UuidUtils.EMPTY_UUID)) {
                        this.isBlacklistPlayer = true;
                        continue;
                    }
                    playerTgt.add(id);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.updatePlayerTargets(playerTgt.toArray(new UUID[0]));
        } else {
            list = nbt.func_150295_c("PlayerTargetsCMP", 10);
            for (int i3 = 0; i3 < list.func_74745_c(); ++i3) {
                NBTTagCompound tag = list.func_150305_b(i3);
                this.updatePlayerTarget(UUID.fromString(tag.func_74779_i("ID")), tag.func_74767_n("Enabled"));
            }
        }
    }

    @Override
    public ResourceLocation[] getEnabledEntityTargets() {
        return (ResourceLocation[])this.entityTargetList.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toArray(ResourceLocation[]::new);
    }

    @Override
    public UUID[] getEnabledPlayerTargets() {
        return (UUID[])this.playerTargetList.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toArray(UUID[]::new);
    }

    @Override
    public Map<ResourceLocation, Boolean> getEntityTargets() {
        return new HashMap<ResourceLocation, Boolean>(this.entityTargetList);
    }

    @Override
    public Map<UUID, Boolean> getPlayerTargets() {
        return new HashMap<UUID, Boolean>(this.playerTargetList);
    }

    @Override
    public void updateEntityTarget(ResourceLocation res, boolean active) {
        if (TargetList.isEntityTargetable(res, this.turret.getAttackType())) {
            this.entityTargetList.put(res, active);
        }
    }

    @Override
    public void updatePlayerTarget(UUID uid, boolean active) {
        this.playerTargetList.put(uid, active);
    }

    @Override
    public void updateEntityTargets(ResourceLocation[] keys) {
        this.entityTargetList.entrySet().forEach(entry -> entry.setValue(false));
        Arrays.stream(keys).filter(r -> TargetList.isEntityTargetable(r, this.turret.getAttackType())).forEach(r -> this.entityTargetList.put((ResourceLocation)r, true));
    }

    @Override
    public void updatePlayerTargets(UUID[] uuids) {
        this.playerTargetList.entrySet().forEach(entry -> entry.setValue(false));
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            this.playerTargetList.put(uuid, true);
        }
    }

    public void updateClientState(int targetId, int ammoCount, @Nonnull ItemStack ammoStack, boolean isShooting) {
        EntityLiving turretL = this.turret.get();
        if (turretL.field_70170_p.field_72995_K) {
            this.entityToAttack = targetId < 0 ? null : turretL.field_70170_p.func_73045_a(targetId);
            this.ammoCount = ammoCount;
            this.ammoStack = ammoStack;
            this.isShootingClt = isShooting;
        }
    }

    @Override
    public String getTargetName() {
        return this.hasTarget() ? EntityList.func_75621_b((Entity)this.entityToAttack) : "";
    }
}

