/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeInstance;
import de.sanandrew.mods.turretmod.item.ItemUpgrade;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateUgradeSlot;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class UpgradeProcessor
implements IUpgradeProcessor {
    @Nonnull
    private final NonNullList<ItemStack> upgradeStacks = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private final Map<ResourceLocation, IUpgradeInstance<?>> upgInstances = new ConcurrentHashMap();
    private final Map<ResourceLocation, IUpgradeInstance<?>> upgTickable = new ConcurrentHashMap();
    private boolean hasChanged = false;
    private final ITurretInst turret;
    private final Deque<IUpgrade> firstSynchronize = new ConcurrentLinkedDeque<IUpgrade>();

    UpgradeProcessor(ITurretInst turret) {
        this.turret = turret;
    }

    @Override
    public void onTick() {
        this.upgTickable.forEach((key, val) -> val.onTick(this.turret));
        if (this.hasChanged) {
            int i;
            EntityLiving turretL = this.turret.get();
            int max = this.upgradeStacks.size();
            for (i = 0; i < max; ++i) {
                IUpgrade upg;
                IUpgrade dep;
                ItemStack invStack = (ItemStack)this.upgradeStacks.get(i);
                if (!ItemStackUtils.isValid((ItemStack)invStack) || (dep = (upg = UpgradeRegistry.INSTANCE.getObject(invStack)).getDependantOn()) == null || this.hasUpgrade(dep)) continue;
                this.dropUpgrade(turretL, i, invStack, upg);
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_III)) {
                max = this.upgradeStacks.size();
                for (i = 27; i < max; ++i) {
                    this.dropUpgrade(turretL, i, (ItemStack)this.upgradeStacks.get(i), null);
                }
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_II)) {
                for (i = 18; i < 27; ++i) {
                    this.dropUpgrade(turretL, i, (ItemStack)this.upgradeStacks.get(i), null);
                }
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_I)) {
                for (i = 9; i < 18; ++i) {
                    this.dropUpgrade(turretL, i, (ItemStack)this.upgradeStacks.get(i), null);
                }
            }
        }
        while (!this.firstSynchronize.isEmpty()) {
            UpgradeRegistry.INSTANCE.syncWithClients(this.turret, this.firstSynchronize.pollFirst().getId());
        }
    }

    private void dropUpgrade(EntityLiving entity, int slot, ItemStack stack, IUpgrade upg) {
        if (ItemStackUtils.isValid((ItemStack)stack)) {
            if (!entity.field_70170_p.field_72995_K) {
                EntityItem itm = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                entity.field_70170_p.func_72838_d((Entity)itm);
            }
            upg = upg != null ? upg : UpgradeRegistry.INSTANCE.getObject(stack);
            upg.terminate(this.turret, stack);
            this.upgradeStacks.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean hasUpgrade(ResourceLocation id) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getItem(id);
        return this.upgradeStacks.stream().anyMatch(currStack -> ItemStackUtils.areEqual((ItemStack)upgItemStack, (ItemStack)currStack, (boolean)false));
    }

    @Override
    public boolean hasUpgrade(IUpgrade upg) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getItem(upg.getId());
        return this.upgradeStacks.stream().anyMatch(currStack -> ItemStackUtils.areEqual((ItemStack)upgItemStack, (ItemStack)currStack, (boolean)false));
    }

    @Override
    public <T extends IUpgradeInstance<?>> T getUpgradeInstance(ResourceLocation id) {
        return (T)((IUpgradeInstance)ReflectionUtils.getCasted(this.upgInstances.get(id)));
    }

    @Override
    public void setUpgradeInstance(ResourceLocation id, IUpgradeInstance<?> inst) {
        this.upgInstances.put(id, inst);
        if (inst.getClass().getAnnotation(IUpgradeInstance.Tickable.class) != null) {
            this.upgTickable.put(id, inst);
        }
    }

    @Override
    public void delUpgradeInstance(ResourceLocation id) {
        this.upgInstances.remove(id);
        this.upgTickable.remove(id);
    }

    public int func_70302_i_() {
        return this.upgradeStacks.size();
    }

    public boolean func_191420_l() {
        return this.upgradeStacks.stream().noneMatch(ItemStackUtils::isValid);
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.upgradeStacks.size() ? (ItemStack)this.upgradeStacks.get(slot) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack slotStack = (ItemStack)this.upgradeStacks.get(slot);
        if (ItemStackUtils.isValid((ItemStack)slotStack)) {
            ItemStack itemstack;
            if (slotStack.func_190916_E() <= amount) {
                IUpgrade upg = UpgradeRegistry.INSTANCE.getObject(slotStack);
                upg.terminate(this.turret, slotStack);
                itemstack = slotStack;
                this.upgradeStacks.set(slot, (Object)ItemStack.field_190927_a);
            } else {
                itemstack = slotStack.func_77979_a(amount);
                if (slotStack.func_190916_E() == 0) {
                    this.upgradeStacks.set(slot, (Object)ItemStack.field_190927_a);
                }
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.upgradeStacks.get(slot)))) {
            ItemStack itemstack = (ItemStack)this.upgradeStacks.get(slot);
            this.upgradeStacks.set(slot, (Object)ItemStack.field_190927_a);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        ItemStack slotStack = (ItemStack)this.upgradeStacks.get(slot);
        if (!ItemStackUtils.areEqual((ItemStack)slotStack, (ItemStack)stack)) {
            IUpgrade upg;
            if (ItemStackUtils.isValid((ItemStack)slotStack)) {
                upg = UpgradeRegistry.INSTANCE.getObject(slotStack);
                upg.terminate(this.turret, slotStack);
            }
            if (ItemStackUtils.isValid((ItemStack)stack)) {
                upg = UpgradeRegistry.INSTANCE.getObject(stack);
                upg.initialize(this.turret, stack);
                if (upg.getClass().getAnnotation(IUpgrade.InitSynchronizeClient.class) != null) {
                    this.firstSynchronize.offerLast(upg);
                }
            }
        }
        this.upgradeStacks.set(slot, (Object)stack);
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "Upgrades";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.hasChanged = true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    private boolean isUpgradeItemApplicable(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemUpgrade) {
            IUpgrade upg = ((ItemUpgrade)stack.func_77973_b()).upgrade;
            if (this.hasUpgrade(upg)) {
                return false;
            }
            if (!UpgradeRegistry.INSTANCE.isApplicable(upg, this.turret.getTurret())) {
                return false;
            }
            IUpgrade dep = upg.getDependantOn();
            return dep == null || this.hasUpgrade(dep);
        }
        return false;
    }

    private boolean isUpgradeItemApplicableForSlot(int slot, ItemStack stack, boolean checkItem) {
        if (!checkItem || this.isUpgradeItemApplicable(stack)) {
            if (slot >= 9 && !this.hasUpgrade(Upgrades.UPG_STORAGE_I)) {
                return false;
            }
            if (slot >= 18 && !this.hasUpgrade(Upgrades.UPG_STORAGE_II)) {
                return false;
            }
            if (slot >= 27 && !this.hasUpgrade(Upgrades.UPG_STORAGE_III)) {
                return false;
            }
            return !ItemStackUtils.isValid((ItemStack)((ItemStack)this.upgradeStacks.get(slot)));
        }
        return false;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return this.isUpgradeItemApplicableForSlot(slot, stack, true);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.upgradeStacks.clear();
    }

    @Override
    public boolean tryApplyUpgrade(@Nonnull ItemStack upgStack) {
        if (this.isUpgradeItemApplicable(upgStack)) {
            EntityLiving turretL = this.turret.get();
            int max = this.upgradeStacks.size();
            for (int i = 0; i < max; ++i) {
                if (!this.isUpgradeItemApplicableForSlot(i, upgStack, false)) continue;
                this.func_70299_a(i, upgStack);
                PacketRegistry.sendToAllAround((IMessage)new PacketUpdateUgradeSlot(this.turret, i, upgStack), turretL.field_71093_bK, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, 64.0);
                return true;
            }
        }
        return false;
    }

    void dropUpgrades() {
        EntityLiving turretL = this.turret.get();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70304_b(i);
            if (!ItemStackUtils.isValid((ItemStack)stack)) continue;
            float xOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float yOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float zOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(turretL.field_70170_p, turretL.field_70165_t + (double)xOff, turretL.field_70163_u + (double)yOff, turretL.field_70161_v + (double)zOff, stack);
            float motionSpeed = 0.05f;
            entityitem.field_70159_w = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
            entityitem.field_70181_x = (float)MiscUtils.RNG.randomGaussian() * motionSpeed + 0.2f;
            entityitem.field_70179_y = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
            turretL.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public NonNullList<ItemStack> extractUpgrades() {
        NonNullList newList = NonNullList.func_191196_a();
        newList.addAll(this.upgradeStacks);
        this.upgradeStacks.clear();
        return newList;
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("upgInventory", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.upgradeStacks, (int)1, this::callbackWriteUpgStack));
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        if (nbt != null) {
            ItemStackUtils.readItemStacksFromTag(this.upgradeStacks, (NBTTagList)nbt.func_150295_c("upgInventory", 10), this::callbackReadUpgStack);
        }
    }

    private void callbackWriteUpgStack(@Nonnull ItemStack upgStack, NBTTagCompound nbt) {
        IUpgrade upg = UpgradeRegistry.INSTANCE.getObject(upgStack);
        upg.onSave(this.turret, nbt);
    }

    private void callbackReadUpgStack(@Nonnull ItemStack upgStack, NBTTagCompound nbt) {
        IUpgrade upg = UpgradeRegistry.INSTANCE.getObject(upgStack);
        upg.initialize(this.turret, upgStack);
        upg.onLoad(this.turret, nbt);
        if (upg.getClass().getAnnotation(IUpgrade.InitSynchronizeClient.class) != null) {
            this.firstSynchronize.offerLast(upg);
        }
    }

    @Override
    public boolean canAccessRemotely() {
        return this.hasUpgrade(Upgrades.REMOTE_ACCESS);
    }
}

