/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.event;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.LevelStorage;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldPersonal;
import de.sanandrew.mods.turretmod.tileentity.TileEntityTurretCrate;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="sapturretmod")
public class DamageEventHandler {
    private static final String DISABLE_XP_DROP_TAG = "sapturretmod:disable_xp_drop";

    @SubscribeEvent
    public static void onDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityTurret) {
            EntityTurret turret = (EntityTurret)event.getEntity();
            if (!turret.field_70170_p.field_72995_K) {
                TileEntityTurretCrate crate;
                IUpgradeProcessor proc = turret.getUpgradeProcessor();
                if (proc.hasUpgrade(Upgrades.SHIELD_PERSONAL)) {
                    ShieldPersonal upgInst = (ShieldPersonal)proc.getUpgradeInstance(Upgrades.SHIELD_PERSONAL.getId());
                    float restDmg = upgInst.damage(event.getAmount());
                    if (restDmg <= 0.0f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(restDmg);
                    }
                    UpgradeRegistry.INSTANCE.syncWithClients(turret, Upgrades.SHIELD_PERSONAL.getId());
                }
                if (!event.isCanceled() && proc.hasUpgrade(Upgrades.TURRET_SAFE) && turret.func_110143_aJ() - event.getAmount() <= 0.001f && (crate = turret.dismantle()) != null) {
                    crate.getInventory().replaceSafeUpgrade();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LevelStorage lvlStorage;
        ITurretInst turret;
        DamageSource dmgSrc = event.getSource();
        EntityLivingBase corpse = event.getEntityLiving();
        if (dmgSrc instanceof EntityTurretProjectile.ITurretDamageSource && corpse.field_70170_p instanceof WorldServer && (turret = ((EntityTurretProjectile.ITurretDamageSource)dmgSrc).getTurretInst()) != null && turret.getUpgradeProcessor().hasUpgrade(Upgrades.LEVELING) && (lvlStorage = (LevelStorage)turret.getUpgradeProcessor().getUpgradeInstance(Upgrades.LEVELING.getId())) != null) {
            FakePlayer faker = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)corpse.field_70170_p));
            int xp = TmrUtils.getExperiencePoints(event.getEntityLiving(), (EntityPlayer)faker);
            xp = ForgeEventFactory.getExperienceDrop((EntityLivingBase)corpse, (EntityPlayer)faker, (int)xp);
            lvlStorage.addXp(xp);
            corpse.func_184211_a(DISABLE_XP_DROP_TAG);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getEntity().func_184216_O().contains(DISABLE_XP_DROP_TAG)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        EntityLivingBase e;
        Entity t = event.getEntity();
        if (t instanceof EntityLiving && (e = ((EntityLiving)t).func_70638_az()) instanceof ITurretInst && ((ITurretInst)e).getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_TOXIN_I)) {
            event.setCanceled(true);
        }
    }
}

