/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.event;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.ForcefieldHandler;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="sapturretmod")
public class ExplosionEventHandler {
    private static final Predicate<EntityLivingBase> CHK_ENTITY = entity -> {
        if (entity instanceof ITurretInst) {
            ITurretInst turretInst = (ITurretInst)entity;
            return turretInst.getTurret() instanceof TurretForcefield && turretInst.getUpgradeProcessor().hasUpgrade(Upgrades.SHIELD_EXPLOSIVE);
        }
        return false;
    };

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        float radius = event.getExplosion().field_77280_f;
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).func_186662_g(24.0).func_191194_a(event.getExplosion().getPosition());
        for (EntityLivingBase living : event.getWorld().func_175647_a(EntityLivingBase.class, aabb, CHK_ENTITY::test)) {
            ForcefieldHandler.onExplosion((ITurretInst)living, aabb, event.getAffectedBlocks(), event.getAffectedEntities());
        }
    }
}

