/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.event;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.event.TargetingEvent;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncAttackTarget;
import de.sanandrew.mods.turretmod.registry.turret.TurretCryolator;
import de.sanandrew.mods.turretmod.registry.turret.TurretShotgun;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.ForcefieldHandler;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.smarttargeting.AdvTargetSettings;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TargetingEventHandler {
    @SubscribeEvent
    public void onProcessorTick(TargetingEvent.ProcessorTick event) {
        ITurretInst turretInst = event.processor.getTurretInst();
        if (turretInst.getTurret() instanceof TurretForcefield) {
            event.setCanceled(true);
            ForcefieldHandler.onTargeting(turretInst, event.processor);
        }
    }

    @SubscribeEvent
    public void onTargetCheck(TargetingEvent.TargetCheck event) {
        List<Entity> entities;
        AdvTargetSettings settings;
        ITurretInst turretInst = event.processor.getTurretInst();
        if (turretInst.getTurret() instanceof TurretCryolator && event.target instanceof EntityLivingBase && ((EntityLivingBase)event.target).func_70644_a(MobEffects.field_76421_d)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.processor.getTurretInst().getUpgradeProcessor().hasUpgrade(Upgrades.SMART_TGT) && (settings = (AdvTargetSettings)event.processor.getTurretInst().getUpgradeProcessor().getUpgradeInstance(Upgrades.SMART_TGT.getId())) != null && !settings.isTargetValid(event.target, turretInst, entities = turretInst.getTargetProcessor().getValidTargetList())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onShooting(TargetingEvent.Shooting event) {
        if (event.processor.getTurretInst().getTurret() instanceof TurretShotgun) {
            Entity projectile;
            boolean hadProjectile = false;
            for (int i = 0; i < 6 && (projectile = event.processor.getProjectile()) != null; ++i) {
                event.processor.getTurretInst().get().field_70170_p.func_72838_d(projectile);
                hadProjectile = true;
            }
            if (hadProjectile) {
                event.processor.playSound(event.processor.getTurretInst().getShootSound(), 1.8f);
                event.processor.getTurretInst().setShooting();
                event.processor.decrAmmo();
                event.setResult(Event.Result.ALLOW);
            } else {
                event.processor.playSound(event.processor.getTurretInst().getNoAmmoSound(), 1.0f);
                event.setResult(Event.Result.DENY);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAmmoConsumption(TargetingEvent.ConsumeAmmo event) {
        ITurretInst turret = event.processor.getTurretInst();
        if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_INF) && event.processor.getAmmoCount() == event.processor.getMaxAmmoCapacity()) {
            event.setResult(Event.Result.DENY);
        } else {
            if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_I) && MiscUtils.RNG.randomFloat() < 0.15f) {
                event.setResult(Event.Result.DENY);
            }
            if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_II) && MiscUtils.RNG.randomFloat() < 0.35f) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttackTarget(LivingSetAttackTargetEvent event) {
        Entity e = event.getEntity();
        if (event.getTarget() == null && !e.field_70170_p.field_72995_K) {
            PacketRegistry.sendToAllAround((IMessage)new PacketSyncAttackTarget(e, null), e.field_71093_bK, e.field_70165_t, e.field_70163_u, e.field_70161_v, 64.0);
        }
    }
}

