/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.init;

import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.ConfigUtils;
import de.sanandrew.mods.sanlib.lib.util.config.Init;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.turretmod.entity.turret.TargetList;
import de.sanandrew.mods.turretmod.registry.projectile.Bullet;
import de.sanandrew.mods.turretmod.registry.projectile.CrossbowBolt;
import de.sanandrew.mods.turretmod.registry.projectile.CryoBall;
import de.sanandrew.mods.turretmod.registry.projectile.Flame;
import de.sanandrew.mods.turretmod.registry.projectile.Harpoon;
import de.sanandrew.mods.turretmod.registry.projectile.Laser;
import de.sanandrew.mods.turretmod.registry.projectile.MinigunPebble;
import de.sanandrew.mods.turretmod.registry.projectile.ShotgunPebble;
import de.sanandrew.mods.turretmod.registry.turret.TurretCrossbow;
import de.sanandrew.mods.turretmod.registry.turret.TurretCryolator;
import de.sanandrew.mods.turretmod.registry.turret.TurretFlamethrower;
import de.sanandrew.mods.turretmod.registry.turret.TurretHarpoon;
import de.sanandrew.mods.turretmod.registry.turret.TurretLaser;
import de.sanandrew.mods.turretmod.registry.turret.TurretMinigun;
import de.sanandrew.mods.turretmod.registry.turret.TurretRevolver;
import de.sanandrew.mods.turretmod.registry.turret.TurretShotgun;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.LevelStorage;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="sapturretmod")
public final class TmrConfig {
    public static final String VERSION = "2.0";
    private static Configuration configGeneral;
    private static Configuration configTurrets;
    private static Configuration configProjectiles;
    private static Configuration configTargets;
    private static Configuration configUpgrades;
    @Value(comment="Whether or not progression based crafting is activated (not available yet)")
    public static boolean doProgression;

    public static void initConfiguration(FMLPreInitializationEvent event) {
        File modCfgDir = new File(event.getModConfigurationDirectory(), "sapturretmod");
        modCfgDir.mkdirs();
        configGeneral = ConfigUtils.loadConfigFile((File)new File(modCfgDir, "general.cfg"), (String)VERSION, (String)"Turret Mod Rebirth");
        configTurrets = ConfigUtils.loadConfigFile((File)new File(modCfgDir, "turrets.cfg"), (String)VERSION, (String)"Turret Mod Rebirth");
        configProjectiles = ConfigUtils.loadConfigFile((File)new File(modCfgDir, "projectiles.cfg"), (String)VERSION, (String)"Turret Mod Rebirth");
        configTargets = ConfigUtils.loadConfigFile((File)new File(modCfgDir, "targets.cfg"), (String)VERSION, (String)"Turret Mod Rebirth");
        configUpgrades = ConfigUtils.loadConfigFile((File)new File(modCfgDir, "upgrades.cfg"), (String)VERSION, (String)"Turret Mod Rebirth");
        TmrConfig.syncConfig();
    }

    public static void syncConfig() {
        ConfigUtils.loadCategories((Configuration)configGeneral, TmrConfig.class);
        ConfigUtils.loadCategories((Configuration)configTurrets, Turrets.class);
        ConfigUtils.loadCategories((Configuration)configProjectiles, Projectiles.class);
        ConfigUtils.loadCategories((Configuration)configTargets, Targets.class);
        ConfigUtils.loadCategories((Configuration)configUpgrades, Upgrades.class);
        if (configGeneral.hasChanged()) {
            configGeneral.save();
        }
        if (configTurrets.hasChanged()) {
            configTurrets.save();
        }
        if (configProjectiles.hasChanged()) {
            configProjectiles.save();
        }
        if (configTargets.hasChanged()) {
            configTargets.save();
        }
        if (configUpgrades.hasChanged()) {
            configUpgrades.save();
        }
    }

    public static Map<String, ConfigCategory[]> getCategoriesForGUI() {
        List<String> order = Arrays.asList("general", "turrets", "projectiles", "targets", "upgrades");
        TreeMap<String, ConfigCategory[]> cat = new TreeMap<String, ConfigCategory[]>(Comparator.comparingInt(order::indexOf));
        cat.put("general", (ConfigCategory[])configGeneral.getCategoryNames().stream().map(arg_0 -> ((Configuration)configGeneral).getCategory(arg_0)).filter(c -> c.size() > 0).toArray(ConfigCategory[]::new));
        cat.put("turrets", (ConfigCategory[])configTurrets.getCategoryNames().stream().map(arg_0 -> ((Configuration)configTurrets).getCategory(arg_0)).filter(c -> c.size() > 0).toArray(ConfigCategory[]::new));
        cat.put("projectiles", (ConfigCategory[])configProjectiles.getCategoryNames().stream().map(arg_0 -> ((Configuration)configProjectiles).getCategory(arg_0)).filter(c -> c.size() > 0).toArray(ConfigCategory[]::new));
        cat.put("targets", (ConfigCategory[])configTargets.getCategoryNames().stream().map(arg_0 -> ((Configuration)configTargets).getCategory(arg_0)).filter(c -> c.size() > 0).toArray(ConfigCategory[]::new));
        cat.put("upgrades", (ConfigCategory[])configUpgrades.getCategoryNames().stream().map(arg_0 -> ((Configuration)configUpgrades).getCategory(arg_0)).filter(c -> c.size() > 0).toArray(ConfigCategory[]::new));
        return cat;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("sapturretmod")) {
            TmrConfig.syncConfig();
            TargetList.initializePostInit();
        }
    }

    static {
        doProgression = true;
    }

    public static final class Upgrades {
        @Init
        public static void initialize() {
            ConfigUtils.loadCategory((Configuration)configUpgrades, LevelStorage.class, null);
        }
    }

    public static final class Targets {
        @Init
        public static void initialize() {
            ConfigUtils.loadCategory((Configuration)configTargets, TargetList.class, null);
        }

        public static void reset() {
            Property p = configTargets.getCategory("targets").get("groundRegenerate");
            p.set(false);
            p.setDefaultValue(false);
            p = configTargets.getCategory("targets").get("groundEntities");
            p.set(TargetList.groundEntities);
            p.setDefaultValues(TargetList.groundEntities);
            configTargets.save();
        }
    }

    public static final class Projectiles {
        @Init
        public static void initialize() {
            ConfigUtils.loadCategory((Configuration)configProjectiles, CrossbowBolt.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, Harpoon.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, ShotgunPebble.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, CryoBall.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, Bullet.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, MinigunPebble.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, Laser.class, null);
            ConfigUtils.loadCategory((Configuration)configProjectiles, Flame.class, null);
        }
    }

    public static final class Turrets {
        @Init
        public static void initialize() {
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretCrossbow.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretHarpoon.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretShotgun.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretCryolator.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretRevolver.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretMinigun.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretForcefield.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretLaser.class, null);
            ConfigUtils.loadCategory((Configuration)configTurrets, TurretFlamethrower.class, null);
        }
    }

    @Category(value="server")
    public static final class Server {
        @Value(comment="Whether or not an Operator can manipulate anyones turrets. When disabled, OPs can only edit their own turrets and are treated like everyone else\n(the playerCanEditAll option is checked instead).\nIgnored in singleplayer.")
        public static boolean opCanEditAll = true;
        @Value(comment="Whether or not any player can manipulate anyones turrets. When disabled, players can only edit their own turrets.\nIgnored in singleplayer.")
        public static boolean playerCanEditAll = false;
    }

    @Category(value="client")
    public static final class Client {
        @Value(comment="Render the upgrades on the turret_placer. Disable this for more performance.")
        public static boolean renderUpgrades = true;
        @Value(comment="Calculate Interceptions of adjacent forcefields. Disable this to gain a performance boost, but be aware it might clutter the screen if many forcefields are operating.")
        public static boolean calcForcefieldIntf = true;
    }
}

