/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.init;

import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.turretmod.api.ITmrPlugin;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.TmrPlugin;
import de.sanandrew.mods.turretmod.compat.crafttweaker.CTHandler;
import de.sanandrew.mods.turretmod.entity.turret.TargetList;
import de.sanandrew.mods.turretmod.init.CommonProxy;
import de.sanandrew.mods.turretmod.init.TmrConfig;
import de.sanandrew.mods.turretmod.init.TmrInternalPlugin;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteManager;
import de.sanandrew.mods.turretmod.registry.projectile.ProjectileRegistry;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.ForcefieldHandler;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

@Mod(modid="sapturretmod", version="4.0.0-beta.4.6", name="Turret Mod Rebirth", guiFactory="de.sanandrew.mods.turretmod.client.gui.config.TmrGuiFactory", dependencies="required-after:forge@[14.23.5.2847,];required-after:sanlib@[1.6.1,];after:patchouli", acceptedMinecraftVersions="[1.12.2]")
public class TurretModRebirth {
    public static final List<ITmrPlugin> PLUGINS = new ArrayList<ITmrPlugin>();
    static final String GUI_FACTORY = "de.sanandrew.mods.turretmod.client.gui.config.TmrGuiFactory";
    private static final String MOD_PROXY_CLIENT = "de.sanandrew.mods.turretmod.client.init.ClientProxy";
    private static final String MOD_PROXY_COMMON = "de.sanandrew.mods.turretmod.init.CommonProxy";
    public static SimpleNetworkWrapper network;
    @Mod.Instance(value="sapturretmod")
    public static TurretModRebirth instance;
    @SidedProxy(modId="sapturretmod", clientSide="de.sanandrew.mods.turretmod.client.init.ClientProxy", serverSide="de.sanandrew.mods.turretmod.init.CommonProxy")
    public static CommonProxy proxy;
    private boolean isDev;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        this.isDev = event.getSourceFile().isDirectory();
        TurretModRebirth.loadPlugins(event.getAsmData());
        TmrConfig.initConfiguration(event);
        network = NetworkRegistry.INSTANCE.newSimpleChannel("SapTurretModNWCH");
        PacketRegistry.initialize();
        PLUGINS.forEach(plugin -> plugin.preInit(TmrUtils.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerTurrets(TurretRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerAmmo(AmmunitionRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerRepairKits(RepairKitRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerUpgrades(UpgradeRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerProjectiles(ProjectileRegistry.INSTANCE));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.preInit(event);
    }

    private static void loadPlugins(ASMDataTable dataTable) {
        String annotationClassName = TmrPlugin.class.getCanonicalName();
        Set asmDatas = dataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<ITmrPlugin> asmInstanceClass = asmClass.asSubclass(ITmrPlugin.class);
                ITmrPlugin instance = asmInstanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                PLUGINS.add(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                TmrConstants.LOG.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        PLUGINS.sort((p1, p2) -> p1 instanceof TmrInternalPlugin ? -1 : (p2 instanceof TmrInternalPlugin ? 1 : 0));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PLUGINS.forEach(plugin -> {
            plugin.registerAssemblyRecipes(AssemblyManager.INSTANCE);
            plugin.registerElectrolyteRecipes(ElectrolyteManager.INSTANCE);
        });
        CTHandler.onInit();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PLUGINS.forEach(ITmrPlugin::postInit);
        proxy.postInit(event);
        AssemblyManager.INSTANCE.finalizeRegistry();
        TargetList.initializePostInit();
    }

    @Mod.EventHandler
    public void interModComm(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(message -> {
            if (message.key.equals("sapturretmod:checkProjForShield") && message.isFunctionMessage()) {
                message.getFunctionValue(Entity.class, Entity.class).ifPresent(ForcefieldHandler.PROJ_GET_OWNER::add);
            }
        });
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        if (this.isDev) {
            Function<Object, Long> gos = obj -> {
                try {
                    Class<?> cls = Class.forName("jdk.nashorn.internal.ir.debug.ObjectSizeCalculator");
                    return (Long)ReflectionUtils.invokeCachedMethod(cls, null, (String)"getObjectSize", (String)"getObjectSize", (Class[])new Class[]{Object.class}, (Object[])new Object[]{obj});
                }
                catch (ClassNotFoundException ex) {
                    return 0L;
                }
            };
            TmrConstants.LOG.log(Level.INFO, String.format("Memory used by turret registry: %d bytes", gos.apply(TurretRegistry.INSTANCE)));
            TmrConstants.LOG.log(Level.INFO, String.format("Memory used by ammo registry: %d bytes", gos.apply(AmmunitionRegistry.INSTANCE)));
            TmrConstants.LOG.log(Level.INFO, String.format("Memory used by upgrade registry: %d bytes", gos.apply(UpgradeRegistry.INSTANCE)));
            TmrConstants.LOG.log(Level.INFO, String.format("Memory used by repairkit registry: %d bytes", gos.apply(RepairKitRegistry.INSTANCE)));
        }
    }
}

