/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.inventory;

import com.google.common.base.Strings;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.IRegistryObject;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.item.ItemAmmo;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public final class AmmoCartridgeInventory
implements ICapabilityProvider,
IInventory {
    private final ItemStack holder;
    private static final int SIZE = 27;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private boolean loaded = false;

    public AmmoCartridgeInventory(ItemStack holder) {
        this.holder = holder;
    }

    public int func_70302_i_() {
        this.load();
        return 27;
    }

    public boolean func_191420_l() {
        this.load();
        return this.stacks.stream().filter(i -> AmmunitionRegistry.INSTANCE.getObject((ItemStack)i).isValid()).noneMatch(ItemStackUtils::isValid);
    }

    public ItemStack func_70301_a(int index) {
        this.load();
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.load();
        ItemStack removed = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        this.save();
        return removed;
    }

    public ItemStack func_70304_b(int index) {
        this.load();
        ItemStack orig = (ItemStack)this.stacks.get(index);
        this.stacks.set(index, (Object)ItemStack.field_190927_a);
        this.save();
        return ItemStackUtils.isValid((ItemStack)orig) ? orig : ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.load();
        this.stacks.set(index, (Object)stack);
        this.save();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.save();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        this.load();
        return ItemStackUtils.isValid((ItemStack)stack) && stack.func_77973_b() instanceof ItemAmmo && (this.func_191420_l() || this.isTypeEqual(stack));
    }

    private boolean isTypeEqual(ItemStack stack) {
        return AmmunitionRegistry.INSTANCE.isEqual(this.getAmmoType(), AmmunitionRegistry.INSTANCE.getObject(stack)) && ((String)MiscUtils.defIfNull((Object)this.getAmmoSubtype(), (Object)"")).equals(MiscUtils.defIfNull((Object)AmmunitionRegistry.INSTANCE.getSubtype(stack), (Object)""));
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.load();
        this.stacks.clear();
        this.save();
    }

    public String func_70005_c_() {
        return this.holder.func_82833_r();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.holder.func_82833_r());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? new InvWrapper((IInventory)this) : null);
    }

    public int getTotalAmmoCount() {
        this.load();
        return this.stacks.stream().map(ItemStack::func_190916_E).reduce(Integer::sum).orElse(0);
    }

    public IAmmunition getAmmoType() {
        this.load();
        return this.stacks.stream().map(AmmunitionRegistry.INSTANCE::getObject).filter(IRegistryObject::isValid).findFirst().orElse(AmmunitionRegistry.INSTANCE.getDefaultObject());
    }

    public String getAmmoSubtype() {
        this.load();
        return this.stacks.stream().map(AmmunitionRegistry.INSTANCE::getSubtype).filter(s -> !Strings.isNullOrEmpty((String)s)).findFirst().orElse(null);
    }

    public ItemStack getAmmoTypeItem() {
        this.load();
        return this.stacks.stream().filter(i -> AmmunitionRegistry.INSTANCE.getObject((ItemStack)i).isValid()).findFirst().orElse(ItemStack.field_190927_a).func_77946_l();
    }

    private void save() {
        NBTTagCompound nbt = this.holder.func_190925_c("Inventory");
        nbt.func_74782_a("Items", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.stacks, (int)this.func_70297_j_()));
    }

    private void load() {
        if (!this.loaded) {
            this.loaded = true;
            NBTTagCompound nbt = this.holder.func_179543_a("Inventory");
            if (nbt != null && nbt.func_150297_b("Items", 9)) {
                ItemStackUtils.readItemStacksFromTag(this.stacks, (NBTTagList)nbt.func_150295_c("Items", 10));
            }
        }
    }
}

