/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.inventory;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.item.ItemAssemblyUpgrade;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AssemblyInventory
implements ISidedInventory,
INBTSerializable<NBTTagCompound> {
    public static final int RESOURCE_SLOTS = 18;
    public static final int RESOURCE_SLOT_FIRST;
    public static final int SLOT_OUTPUT = 0;
    public static final int SLOT_OUTPUT_CARTRIDGE = 1;
    public static final int SLOT_UPGRADE_AUTO = 2;
    public static final int SLOT_UPGRADE_SPEED = 3;
    public static final int SLOT_UPGRADE_FILTER = 4;
    public static final int SLOT_UPGRADE_REDSTONE = 5;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)24, (Object)ItemStack.field_190927_a);
    private static final int[] SLOTS_INSERT;
    private static final int[] SLOTS_EXTRACT;
    private final TileEntityTurretAssembly tile;

    public AssemblyInventory(TileEntityTurretAssembly tile) {
        this.tile = tile;
    }

    private boolean isStackAcceptable(@Nonnull ItemStack stack, int insrtSlot) {
        if (this.hasFilterUpgrade()) {
            NonNullList<ItemStack> filter = this.getFilterStacks();
            if (ItemStackUtils.isStackInList((ItemStack)stack, filter)) {
                return ItemStackUtils.areEqual((ItemStack)stack, (ItemStack)((ItemStack)filter.get(insrtSlot)));
            }
            return !ItemStackUtils.isValid((ItemStack)((ItemStack)filter.get(insrtSlot)));
        }
        return true;
    }

    public NonNullList<ItemStack> getFilterStacks() {
        if (this.hasFilterUpgrade()) {
            return ItemAssemblyUpgrade.Filter.getFilterStacks((ItemStack)this.stacks.get(4));
        }
        return ItemAssemblyUpgrade.Filter.getEmptyInv();
    }

    public boolean hasAutoUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.stacks.get(2)), (Item)ItemRegistry.ASSEMBLY_UPG_AUTO);
    }

    public boolean hasSpeedUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.stacks.get(3)), (Item)ItemRegistry.ASSEMBLY_UPG_SPEED);
    }

    public boolean hasFilterUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.stacks.get(4)), (Item)ItemRegistry.ASSEMBLY_UPG_FILTER);
    }

    public boolean hasRedstoneUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.stacks.get(5)), (Item)ItemRegistry.ASSEMBLY_UPG_REDSTONE);
    }

    public boolean canFillOutput(ItemStack stack) {
        StackContainerSlotData ihm = this.getFirstItemContainer();
        if (ihm != null && AssemblyInventory.fillItemContainer(ihm.handler, stack, true)) {
            return true;
        }
        ItemStack invStack = (ItemStack)this.stacks.get(0);
        return !ItemStackUtils.isValid((ItemStack)invStack) || invStack.func_190916_E() < invStack.func_77976_d() && ItemStackUtils.canStack((ItemStack)invStack, (ItemStack)stack, (boolean)true);
    }

    public void fillOutput(ItemStack stack) {
        StackContainerSlotData ihm = this.getFirstItemContainer();
        if (ihm != null) {
            if (AssemblyInventory.fillItemContainer(ihm.handler, stack, false)) {
                this.tryPushOutputToItemContainer(ihm.handler);
                return;
            }
            this.pushItemContainerToOutput(ihm.slot);
        }
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.stacks.get(0)))) {
            ((ItemStack)this.stacks.get(0)).func_190917_f(stack.func_190916_E());
        } else {
            this.stacks.set(0, (Object)stack.func_77946_l());
            this.func_70296_d();
        }
    }

    private static boolean fillItemContainer(IItemHandler handler, ItemStack stack, boolean simulate) {
        int max = handler.getSlots();
        for (int i = 0; i < max; ++i) {
            if (ItemStackUtils.isValid((ItemStack)(stack = handler.insertItem(i, stack, simulate)))) continue;
            return true;
        }
        return false;
    }

    private void tryPushOutputToItemContainer(IItemHandler handler) {
        if (AssemblyInventory.fillItemContainer(handler, (ItemStack)this.stacks.get(0), true)) {
            AssemblyInventory.fillItemContainer(handler, (ItemStack)this.stacks.get(0), false);
            this.stacks.set(0, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
        }
    }

    private void pushItemContainerToOutput(int containerSlot) {
        if (!ItemStackUtils.isValid((ItemStack)((ItemStack)this.stacks.get(1)))) {
            this.stacks.set(1, (Object)((ItemStack)this.stacks.get(containerSlot)).func_77946_l());
            this.stacks.set(containerSlot, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
        }
    }

    private StackContainerSlotData getFirstItemContainer() {
        for (int slot : SLOTS_INSERT) {
            IItemHandler itemHandler;
            ItemStack stack = (ItemStack)this.stacks.get(slot);
            if (!ItemStackUtils.isValid((ItemStack)stack) || (itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
            return new StackContainerSlotData(itemHandler, slot);
        }
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_EXTRACT : (side == EnumFacing.UP ? new int[]{} : SLOTS_INSERT);
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack stack, EnumFacing side) {
        return IntStream.of(SLOTS_INSERT).anyMatch(s -> s == slot) && this.func_94041_b(slot, stack) && side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack stack, EnumFacing side) {
        return IntStream.of(SLOTS_EXTRACT).anyMatch(s -> s == slot) && side == EnumFacing.DOWN;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        return this.stacks.isEmpty() || this.stacks.stream().noneMatch(ItemStackUtils::isValid);
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (ItemStackUtils.isValid((ItemStack)stack)) {
            ItemStack newStack;
            if (stack.func_190916_E() <= size) {
                newStack = stack;
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            } else {
                newStack = stack.func_77979_a(size);
                if (stack.func_190916_E() == 0) {
                    this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                }
            }
            this.updateTile(slot);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.stacks.get(slot)))) {
            ItemStack itemstack = (ItemStack)this.stacks.get(slot);
            this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            this.updateTile(slot);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.updateTile(slot);
    }

    private void updateTile(int slot) {
        if (!this.tile.func_145831_w().field_72995_K && slot < RESOURCE_SLOT_FIRST) {
            if (slot == 2 && !this.hasAutoUpgrade()) {
                this.tile.setAutomated(false);
            }
            if (slot == 5) {
                IBlockState blockState = this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v());
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), blockState, blockState, 3);
            }
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.tile.getCustomName();
    }

    public boolean func_145818_k_() {
        return this.tile.hasCustomName();
    }

    public ITextComponent func_145748_c_() {
        return this.tile.func_145748_c_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.tile.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        BlockPos tilePos = this.tile.func_174877_v();
        return this.tile.func_145831_w().func_175625_s(tilePos) == this.tile && player.func_70092_e((double)tilePos.func_177958_n() + 0.5, (double)tilePos.func_177956_o() + 0.5, (double)tilePos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0 || slot == 1 || !ItemStackUtils.isValid((ItemStack)stack)) {
            return false;
        }
        if (slot == 2 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_AUTO) {
            return true;
        }
        if (slot == 3 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_SPEED) {
            return true;
        }
        if (slot == 4 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_FILTER) {
            return true;
        }
        if (slot == 5 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_REDSTONE) {
            return true;
        }
        return Arrays.binarySearch(SLOTS_INSERT, slot) >= 0 && this.isStackAcceptable(stack, slot - RESOURCE_SLOT_FIRST);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("inventory", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.stacks, (int)64));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList inventory = nbt.func_150295_c("inventory", 10);
        if (inventory.func_74745_c() == 23) {
            NonNullList oldStacks = NonNullList.func_191197_a((int)23, (Object)ItemStack.field_190927_a);
            ItemStackUtils.readItemStacksFromTag((List)oldStacks, (NBTTagList)inventory);
            this.stacks.set(0, oldStacks.get(0));
            this.stacks.set(2, oldStacks.get(1));
            this.stacks.set(3, oldStacks.get(2));
            this.stacks.set(4, oldStacks.get(3));
            this.stacks.set(1, oldStacks.get(4));
            int j = 5;
            for (int i = 0; i < SLOTS_INSERT.length; ++i) {
                this.stacks.set(SLOTS_INSERT[i], oldStacks.get(j++));
            }
        } else {
            ItemStackUtils.readItemStacksFromTag(this.stacks, (NBTTagList)inventory);
        }
    }

    static {
        SLOTS_INSERT = new int[18];
        SLOTS_EXTRACT = new int[]{0, 1};
        int slotId = 6;
        for (int i = 0; i < 18; ++i) {
            AssemblyInventory.SLOTS_INSERT[i] = slotId++;
        }
        RESOURCE_SLOT_FIRST = SLOTS_INSERT[0];
    }

    private static final class StackContainerSlotData {
        IItemHandler handler;
        int slot;

        StackContainerSlotData(IItemHandler itemHandler, int slot) {
            this.handler = itemHandler;
            this.slot = slot;
        }
    }
}

