/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.inventory;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.tileentity.TileEntityTurretCrate;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;

public class TurretCrateInventory
implements IInventory,
INBTSerializable<NBTTagCompound> {
    public static final int SIZE_UPGRADE_STORAGE = 36;
    public static final int SLOT_AMMO = 37;
    private final TileEntityTurretCrate tile;
    private final NonNullList<ItemStack> upgrades = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> ammo = NonNullList.func_191196_a();
    private ItemStack turretStack = ItemStack.field_190927_a;
    private int ammoCntCache = -1;

    public TurretCrateInventory(TileEntityTurretCrate tile) {
        this.tile = tile;
    }

    public int func_70302_i_() {
        return 38;
    }

    public boolean func_191420_l() {
        return !ItemStackUtils.isValid((ItemStack)this.turretStack) && (this.ammo.size() < 1 || this.ammo.stream().noneMatch(ItemStackUtils::isValid)) && this.upgrades.stream().noneMatch(ItemStackUtils::isValid);
    }

    public ItemStack func_70301_a(int index) {
        if (index == 0) {
            return this.turretStack;
        }
        if (index >= 1 && index <= 36) {
            return (ItemStack)this.upgrades.get(index - 1);
        }
        if (index > 36 && index - 36 <= this.ammo.size()) {
            return (ItemStack)this.ammo.get(index - 36 - 1);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (ItemStackUtils.isValid((ItemStack)stack)) {
            if (stack.func_190916_E() <= count) {
                ItemStack itemstack = stack;
                this.func_70304_b(index);
                return itemstack;
            }
            ItemStack itemstack = stack.func_77979_a(count);
            if (stack.func_190916_E() == 0) {
                this.func_70304_b(index);
            }
            if (index == 37) {
                this.reduceAmmoList();
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack stack = this.turretStack;
            this.turretStack = ItemStack.field_190927_a;
            return stack;
        }
        if (index >= 1 && index <= 36) {
            return (ItemStack)this.upgrades.set(index - 1, (Object)ItemStack.field_190927_a);
        }
        if (index == 37 && this.ammo.size() > 0) {
            ItemStack removed = (ItemStack)this.ammo.remove(0);
            this.reduceAmmoList();
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    private void reduceAmmoList() {
        NonNullList combinedList = ItemStackUtils.getCompactItems(this.ammo, (int)this.func_70297_j_());
        this.ammo.clear();
        this.ammo.addAll((Collection)combinedList);
        this.ammoCntCache = -1;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!ItemStackUtils.isValid((ItemStack)stack)) {
            this.func_70304_b(index);
            this.ammoCntCache = -1;
        }
    }

    public void replaceSafeUpgrade() {
        for (int i = 0; i < 36; ++i) {
            ItemStack upgStack = (ItemStack)this.upgrades.get(i);
            if (!UpgradeRegistry.INSTANCE.isType(upgStack, Upgrades.TURRET_SAFE)) continue;
            this.upgrades.set(i, (Object)UpgradeRegistry.INSTANCE.getItem(UpgradeRegistry.INSTANCE.getEmptyUpgrade().getId()));
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        BlockPos tilePos = this.tile.func_174877_v();
        return this.tile.func_145831_w().func_175625_s(tilePos) == this.tile && player.func_70092_e((double)tilePos.func_177958_n() + 0.5, (double)tilePos.func_177956_o() + 0.5, (double)tilePos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.turretStack = ItemStack.field_190927_a;
        this.upgrades.clear();
        this.ammo.clear();
        this.ammoCntCache = -1;
    }

    public String func_70005_c_() {
        return this.tile.getName();
    }

    public boolean func_145818_k_() {
        return this.tile.hasCustomName();
    }

    public ITextComponent func_145748_c_() {
        return this.tile.func_145748_c_();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStackUtils.writeStackToTag((ItemStack)this.turretStack, (NBTTagCompound)nbt, (String)"TurretItem");
        nbt.func_74782_a("InventoryUpgrades", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.upgrades, (int)64));
        nbt.func_74782_a("InventoryAmmo", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.ammo, (int)64));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.turretStack = new ItemStack(nbt.func_74775_l("TurretItem"));
        ItemStackUtils.readItemStacksFromTag(this.upgrades, (NBTTagList)nbt.func_150295_c("InventoryUpgrades", 10));
        NBTTagList ammoTag = nbt.func_150295_c("InventoryAmmo", 10);
        if (ammoTag.func_74745_c() > 0) {
            this.ammo.addAll((Collection)NonNullList.func_191197_a((int)ammoTag.func_74745_c(), (Object)ItemStack.field_190927_a));
            this.ammoCntCache = -1;
            ItemStackUtils.readItemStacksFromTag(this.ammo, (NBTTagList)ammoTag);
        }
    }

    public void insertTurret(ITurretInst turretInst) {
        this.turretStack = TurretRegistry.INSTANCE.getItem(turretInst);
        this.ammo.clear();
        this.ammo.addAll(((TargetProcessor)turretInst.getTargetProcessor()).extractAmmoItems());
        this.ammoCntCache = -1;
        this.upgrades.clear();
        NonNullList<ItemStack> tUpgrades = ((UpgradeProcessor)turretInst.getUpgradeProcessor()).extractUpgrades();
        int max = this.upgrades.size();
        for (int i = 0; i < max; ++i) {
            this.upgrades.set(i, tUpgrades.get(i));
        }
    }

    public int getAmmoCount() {
        if (this.ammoCntCache < 0) {
            this.ammoCntCache = 0;
            this.ammo.forEach(a -> this.ammoCntCache += a.func_190916_E());
        }
        return this.ammoCntCache;
    }
}

