/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.inventory.container;

import de.sanandrew.mods.sanlib.lib.util.InventoryUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.inventory.AmmoCartridgeInventory;
import de.sanandrew.mods.turretmod.inventory.container.SlotOutput;
import de.sanandrew.mods.turretmod.item.ItemAmmo;
import de.sanandrew.mods.turretmod.item.ItemAmmoCartridge;
import de.sanandrew.mods.turretmod.item.ItemRepairKit;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTurretRemoteAccess
extends Container {
    private static final int SLOT_INV_IN_REPAIR_KIT = 0;
    private static final int SLOT_CNT_IN_REPAIR_KIT = 0;
    private static final int SLOT_INV_IN_AMMO = 1;
    private static final int SLOT_CNT_IN_AMMO = 1;
    private static final int SLOT_INV_OUT_AMMO = 0;
    private static final int SLOT_CNT_OUT_AMMO = 2;
    private final ITurretInst turretInst;
    private final EntityPlayer player;
    private final IInventory invInput = new InventoryInput(this);
    private final IInventory invOutput = new InventoryOutput();

    public ContainerTurretRemoteAccess(InventoryPlayer playerInv, ITurretInst turretInst) {
        int i;
        this.turretInst = turretInst;
        this.player = playerInv.field_70458_d;
        this.func_75146_a(new SlotInput(this.invInput, 0, 26, 40, s -> s.func_77973_b() instanceof ItemRepairKit));
        this.func_75146_a(new SlotInput(this.invInput, 1, 134, 40, s -> s.func_77973_b() instanceof ItemAmmo || s.func_77973_b() instanceof ItemAmmoCartridge));
        this.func_75146_a(new SlotOutput(this.invOutput, 0, 134, 76));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 125 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInv, i, 8 + i * 18, 183));
        }
        this.func_75146_a(new SlotAmmo(116, 58));
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int beginSlot, int endSlot, boolean reverse) {
        return InventoryUtils.mergeItemStack((Container)this, (ItemStack)stack, (int)beginSlot, (int)endSlot, (boolean)reverse);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack origStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            origStack = slotStack.func_77946_l();
            if (slotId >= 3 ? !this.func_75135_a(slotStack, 0, 2, false) : (slotId == 2 ? !ItemAmmoCartridge.putAmmoInPlayerCartridge(slotStack, player) && !super.func_75135_a(slotStack, 3, 39, true) : !super.func_75135_a(slotStack, 3, 39, true))) {
                return ItemStack.field_190927_a;
            }
            if (InventoryUtils.finishTransfer((EntityPlayer)player, (ItemStack)origStack, (Slot)slot, (ItemStack)slotStack)) {
                return ItemStack.field_190927_a;
            }
        }
        return origStack;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack ammoInput;
        if (this.player.field_70170_p.field_72995_K) {
            super.func_75130_a(inventoryIn);
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
        ITurretInst turretInst = this.turretInst;
        boolean syncContainer = false;
        if (turretInst.applyRepairKit(this.invInput.func_70301_a(0))) {
            this.invInput.func_70298_a(0, 1);
            syncContainer = true;
        }
        if (ItemStackUtils.isValid((ItemStack)(ammoInput = this.invInput.func_70301_a(1).func_77946_l()))) {
            AmmoCartridgeInventory inv;
            ITargetProcessor processor = turretInst.getTargetProcessor();
            boolean syncTurret = false;
            if (ammoInput.func_77973_b() instanceof ItemAmmo) {
                ITargetProcessor.ApplyType ammoApplyType = processor.getAmmoApplyType(ammoInput);
                if (ammoApplyType == ITargetProcessor.ApplyType.REPLACE) {
                    if (this.extractAmmo(processor)) {
                        int amt = ammoInput.func_190916_E();
                        ammoInput.func_190920_e(1);
                        ((TargetProcessor)processor).setAmmoStackInternal(ammoInput, amt);
                        this.invInput.func_70299_a(1, ItemStack.field_190927_a);
                        syncTurret = true;
                        syncContainer = true;
                    }
                } else if (ammoApplyType == ITargetProcessor.ApplyType.ADD && processor.addAmmo(ammoInput)) {
                    this.invInput.func_70299_a(1, ammoInput);
                    syncTurret = true;
                    syncContainer = true;
                }
            } else if (ammoInput.func_77973_b() instanceof ItemAmmoCartridge && (inv = ItemAmmoCartridge.getInventory(ammoInput)) != null && !inv.func_191420_l()) {
                if (this.grabAmmo(processor, inv, ammoInput)) {
                    syncTurret = true;
                    syncContainer = true;
                } else if (processor.getAmmoApplyType(inv.getAmmoTypeItem()) == ITargetProcessor.ApplyType.REPLACE && this.extractAmmo(processor)) {
                    ((TargetProcessor)processor).setAmmoStackInternal(ItemStack.field_190927_a, 0);
                    this.grabAmmo(processor, inv, ammoInput);
                    syncTurret = true;
                    syncContainer = true;
                }
            }
            if (syncTurret) {
                this.turretInst.updateState();
            }
        }
        if (syncContainer) {
            playerMP.func_71111_a((Container)this, 0, this.invInput.func_70301_a(0));
            playerMP.func_71111_a((Container)this, 1, this.invInput.func_70301_a(1));
            playerMP.func_71111_a((Container)this, 2, this.invOutput.func_70301_a(0));
        }
        super.func_75130_a(inventoryIn);
    }

    private boolean extractAmmo(ITargetProcessor processor) {
        ItemStack ammoTurret = processor.getAmmoStack();
        ItemStack ammoOutput = this.invOutput.func_70301_a(0);
        IAmmunition type = AmmunitionRegistry.INSTANCE.getObject(ammoTurret);
        if (type.isValid()) {
            ammoTurret.func_190920_e(processor.getAmmoCount() / type.getAmmoCapacity());
            if (!ItemStackUtils.isValid((ItemStack)ammoOutput)) {
                this.invOutput.func_70299_a(0, ammoTurret);
                return true;
            }
            if (ItemStackUtils.areEqual((ItemStack)ammoTurret, (ItemStack)ammoOutput)) {
                ammoOutput.func_190917_f(ammoTurret.func_190916_E());
                this.invOutput.func_70299_a(0, ammoOutput);
                return true;
            }
        }
        return false;
    }

    private boolean grabAmmo(ITargetProcessor processor, AmmoCartridgeInventory cartridgeInv, ItemStack cartridge) {
        if (ItemAmmoCartridge.extractAmmoStacks(cartridge, processor, false)) {
            if (cartridgeInv.func_191420_l() && !ItemStackUtils.isValid((ItemStack)this.invOutput.func_70301_a(0))) {
                this.invOutput.func_70299_a(0, cartridge);
                this.invInput.func_70299_a(1, ItemStack.field_190927_a);
            } else {
                this.invInput.func_70299_a(1, cartridge);
            }
            return true;
        }
        return false;
    }

    public void func_75134_a(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ContainerTurretRemoteAccess.dropStacksOnClose(this.invInput, player);
            ContainerTurretRemoteAccess.dropStacksOnClose(this.invOutput, player);
        }
        super.func_75134_a(player);
    }

    private static void dropStacksOnClose(IInventory inv, EntityPlayer player) {
        int max = inv.func_70302_i_();
        for (int i = 0; i < max; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!ItemStackUtils.isValid((ItemStack)stack)) continue;
            player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack.func_77946_l()));
        }
    }

    private class SlotAmmo
    extends Slot {
        private SlotAmmo(int x, int y) {
            super(null, -1, x, y);
        }

        public ItemStack func_75211_c() {
            ITargetProcessor processor = ContainerTurretRemoteAccess.this.turretInst.getTargetProcessor();
            ItemStack stack = processor.getAmmoStack();
            IAmmunition type = AmmunitionRegistry.INSTANCE.getObject(stack);
            if (type.isValid()) {
                stack.func_190920_e(processor.getAmmoCount() / type.getAmmoCapacity());
                return stack;
            }
            return ItemStack.field_190927_a;
        }

        public void func_75215_d(ItemStack stack) {
        }

        public void func_75218_e() {
        }

        public int func_75219_a() {
            return this.func_75211_c().func_190916_E();
        }

        public ItemStack func_75209_a(int amount) {
            return ItemStack.field_190927_a;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    private static class SlotInput
    extends Slot {
        private final Function<ItemStack, Boolean> checker;

        private SlotInput(IInventory inv, int id, int x, int y, Function<ItemStack, Boolean> checker) {
            super(inv, id, x, y);
            this.checker = checker;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.checker.apply(stack);
        }
    }

    private static class InventoryOutput
    extends InventoryBasic {
        private InventoryOutput() {
            super("Remote Access Output", true, 1);
        }

        public int func_70297_j_() {
            return Integer.MAX_VALUE;
        }
    }

    private static class InventoryInput
    extends InventoryBasic {
        private final Container parent;

        private InventoryInput(Container parent) {
            super("Remote Access Input", true, 2);
            this.parent = parent;
        }

        public void func_70299_a(int index, ItemStack stack) {
            super.func_70299_a(index, stack);
            this.parent.func_75130_a((IInventory)this);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack remainder = super.func_70298_a(index, count);
            if (ItemStackUtils.isValid((ItemStack)remainder)) {
                this.parent.func_75130_a((IInventory)this);
            }
            return remainder;
        }
    }
}

