/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import de.sanandrew.mods.sanlib.lib.util.InventoryUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.inventory.AmmoCartridgeInventory;
import de.sanandrew.mods.turretmod.item.ItemAmmo;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.TmrCreativeTabs;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemAmmoCartridge
extends Item {
    ItemAmmoCartridge() {
        this.func_77637_a(TmrCreativeTabs.TURRETS);
        this.setRegistryName("sapturretmod", "ammo_cartridge");
        this.func_77655_b("sapturretmod:ammo_cartridge");
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            AmmunitionRegistry.INSTANCE.getObjects().forEach(t -> {
                if (t.isValid()) {
                    String[] subtypes = t.getSubtypes();
                    if (subtypes != null && subtypes.length > 0) {
                        for (String subtype : subtypes) {
                            ItemStack typeStack = AmmunitionRegistry.INSTANCE.getItem(t.getId(), subtype);
                            this.addItem(typeStack, list);
                        }
                    } else {
                        ItemStack typeStack = AmmunitionRegistry.INSTANCE.getItem(t.getId());
                        this.addItem(typeStack, list);
                    }
                }
            });
        }
    }

    private void addItem(ItemStack stack, NonNullList<ItemStack> list) {
        stack.func_190920_e(stack.func_77976_d());
        ItemStack filled = new ItemStack((Item)this, 1);
        AmmoCartridgeInventory inv = ItemAmmoCartridge.getInventory(filled);
        if (inv != null) {
            int max = inv.func_70302_i_();
            for (int i = 0; i < max; ++i) {
                inv.func_70299_a(i, stack.func_77946_l());
            }
            list.add((Object)filled);
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return target instanceof EntityTurret;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            TurretModRebirth.proxy.openGui(playerIn, EnumGui.CARTRIDGE, 0, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        AmmoCartridgeInventory inv = ItemAmmoCartridge.getInventory(stack);
        if (inv != null && !inv.func_191420_l()) {
            tooltip.add("Stored: " + inv.getTotalAmmoCount() + "x " + AmmunitionRegistry.INSTANCE.getItem(inv.getAmmoType().getId()).func_82833_r());
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static AmmoCartridgeInventory getInventory(ItemStack item) {
        IInventory inv;
        IItemHandler itemHandler = (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler instanceof InvWrapper && (inv = ((InvWrapper)itemHandler).getInv()) instanceof AmmoCartridgeInventory) {
            return (AmmoCartridgeInventory)inv;
        }
        return null;
    }

    public static boolean extractAmmoStacks(ItemStack item, ITargetProcessor processor, boolean replace) {
        boolean success = false;
        IItemHandler itemHandler = (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            int max = itemHandler.getSlots();
            for (int i = 0; i < max; ++i) {
                ItemStack copyInvStack;
                ITargetProcessor.ApplyType applyType;
                ItemStack invStack = itemHandler.getStackInSlot(i);
                if (!ItemStackUtils.isValid((ItemStack)invStack) || !(invStack.func_77973_b() instanceof ItemAmmo) || (applyType = processor.getAmmoApplyType(invStack)) != ITargetProcessor.ApplyType.ADD && (applyType != ITargetProcessor.ApplyType.REPLACE || !replace && processor.hasAmmo()) || !processor.addAmmo(copyInvStack = invStack.func_77946_l(), (ICapabilityProvider)item)) continue;
                success = true;
                itemHandler.extractItem(i, invStack.func_190916_E() - copyInvStack.func_190916_E(), false);
            }
        }
        return success;
    }

    public static boolean putAmmoInPlayerCartridge(ItemStack stack, EntityPlayer player) {
        int max = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < max; ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack.func_77973_b() != ItemRegistry.AMMO_CARTRIDGE) continue;
            AmmoCartridgeInventory cartridge = ItemAmmoCartridge.getInventory(invStack);
            ItemStack remain = InventoryUtils.addStackToCapability((ItemStack)stack, (ICapabilityProvider)cartridge, (EnumFacing)EnumFacing.UP, (boolean)false);
            stack.func_190920_e(remain.func_190916_E());
            if (ItemStackUtils.isValid((ItemStack)remain)) continue;
            return true;
        }
        return false;
    }
}

