/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.registry.TmrCreativeTabs;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemAssemblyUpgrade
extends Item {
    ItemAssemblyUpgrade() {
        this.func_77637_a(TmrCreativeTabs.UPGRADES);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LangUtils.translate((String)(this.func_77658_a() + ".ttip"), (Object[])new Object[0]));
    }

    public static class Filter
    extends ItemAssemblyUpgrade {
        Filter() {
            this.func_77655_b("sapturretmod:turret_assembly_filter");
            this.setRegistryName("sapturretmod", "assembly_upg_filter");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("filteredStacks")) {
                tooltip.add(TextFormatting.ITALIC + LangUtils.translate((String)(this.func_77658_a() + ".conf"), (Object[])new Object[0]));
            } else {
                tooltip.addAll(Arrays.asList(LangUtils.translate((String)(this.func_77658_a() + ".inst"), (Object[])new Object[0]).split("\\n")));
            }
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
            if (!world.field_72995_K) {
                if (player.func_70093_af()) {
                    Filter.setFilterStacks(player.func_184586_b(hand), null);
                    player.field_71069_bz.func_75142_b();
                } else {
                    TurretModRebirth.proxy.openGui(player, EnumGui.TASSEMBLY_FLT, 0, 0, 0);
                }
            }
            return super.func_77659_a(world, player, hand);
        }

        public static NonNullList<ItemStack> getFilterStacks(@Nonnull ItemStack stack) {
            NonNullList<ItemStack> stacks = Filter.getEmptyInv();
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("filteredStacks")) {
                ItemStackUtils.readItemStacksFromTag(stacks, (NBTTagList)nbt.func_150295_c("filteredStacks", 10));
            }
            return stacks;
        }

        public static void setFilterStacks(@Nonnull ItemStack stack, NonNullList<ItemStack> inv) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (inv == null || inv.size() < 1) {
                if (nbt.func_74764_b("filteredStacks")) {
                    nbt.func_82580_o("filteredStacks");
                }
            } else {
                NBTTagList list = ItemStackUtils.writeItemStacksToTag(inv, (int)1);
                nbt.func_74782_a("filteredStacks", (NBTBase)list);
            }
            stack.func_77982_d(nbt);
        }

        public static NonNullList<ItemStack> getEmptyInv() {
            return NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
        }
    }

    static class Redstone
    extends ItemAssemblyUpgrade {
        Redstone() {
            this.func_77655_b("sapturretmod:turret_assembly_redstone");
            this.setRegistryName("sapturretmod", "assembly_upg_redstone");
        }
    }

    static class Speed
    extends ItemAssemblyUpgrade {
        Speed() {
            this.func_77655_b("sapturretmod:turret_assembly_speed");
            this.setRegistryName("sapturretmod", "assembly_upg_speed");
        }
    }

    static class Automation
    extends ItemAssemblyUpgrade {
        Automation() {
            this.func_77655_b("sapturretmod:turret_assembly_auto");
            this.setRegistryName("sapturretmod", "assembly_upg_auto");
        }
    }
}

