/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import com.google.common.collect.ImmutableList;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.repairkit.IRepairKit;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.item.ItemAmmo;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.item.ItemRepairKit;
import de.sanandrew.mods.turretmod.item.ItemTurret;
import de.sanandrew.mods.turretmod.item.ItemUpgrade;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKits;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="sapturretmod")
public class ItemRemapper {
    private static final ResourceLocation OLD_AMMO_ID = new ResourceLocation("sapturretmod", "turret_ammo");
    private static final Map<UUID, ResourceLocation> OLD_AMMO_MAPPINGS = new HashMap<UUID, ResourceLocation>(){
        {
            this.put(UUID.fromString("7B497E61-4E8D-4E49-AC71-414751E399E8"), Ammunitions.BOLT.getId());
            this.put(UUID.fromString("3B3AA3F7-DA37-4B92-8F18-53694361447F"), Ammunitions.SGSHELL.getId());
            this.put(UUID.fromString("0B567594-E5CA-48B5-A538-E87C213F439C"), Ammunitions.CRYOCELL_MK1.getId());
            this.put(UUID.fromString("CB5BE826-0480-4D30-AF1F-23BE19329B37"), Ammunitions.CRYOCELL_MK2.getId());
            this.put(UUID.fromString("3181E328-0151-44E0-ADD2-5FCB6B724AEC"), Ammunitions.CRYOCELL_MK3.getId());
            this.put(UUID.fromString("E8CB6C41-00FE-4FA0-AD98-FC8DAD6609AC"), Ammunitions.BULLET.getId());
            this.put(UUID.fromString("3851173D-3AC3-4F17-A488-68C33716AF26"), Ammunitions.MGSHELL.getId());
            this.put(UUID.fromString("E9B4AEDF-AA9C-4041-9C1E-24B20E4D48CD"), Ammunitions.ELECTROLYTECELL.getId());
            this.put(UUID.fromString("48800C6A-9A31-4F45-8AD5-DD02B8B18BCB"), Ammunitions.FLUXCELL.getId());
            this.put(UUID.fromString("0CA51FA8-FD33-4C3D-A9AB-BA29DFFF4ABA"), Ammunitions.FUELTANK.getId());
        }
    };
    private static final Map<ResourceLocation, ResourceLocation> OLD_AMMO_ID_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>(){
        {
            this.put(new ResourceLocation("sapturretmod", "ammo.arrow"), Ammunitions.BOLT.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.tipped_bolt"), Ammunitions.TIPPED_BOLT.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.cryocell.1"), Ammunitions.CRYOCELL_MK1.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.cryocell.2"), Ammunitions.CRYOCELL_MK2.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.cryocell.3"), Ammunitions.CRYOCELL_MK3.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.shotgunshell"), Ammunitions.SGSHELL.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.harpoon"), Ammunitions.HARPOON.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.bullet"), Ammunitions.BULLET.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.minigunshell"), Ammunitions.MGSHELL.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.eleccell"), Ammunitions.ELECTROLYTECELL.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.fluxcell"), Ammunitions.FLUXCELL.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.fueltank"), Ammunitions.FUELTANK.getId());
            this.put(new ResourceLocation("sapturretmod", "ammo.cartridge"), ItemRegistry.AMMO_CARTRIDGE.getRegistryName());
        }
    };
    private static final ResourceLocation OLD_TURRET_ID = new ResourceLocation("sapturretmod", "turret_placer");
    public static final Map<UUID, ResourceLocation> OLD_TURRET_MAPPINGS = Collections.unmodifiableMap(new HashMap<UUID, ResourceLocation>(){
        {
            this.put(UUID.fromString("50E1E69C-395C-486C-BB9D-41E82C8B22E2"), Turrets.CROSSBOW.getId());
            this.put(UUID.fromString("F7991EC5-2A89-49A6-B8EA-80775973C4C5"), Turrets.SHOTGUN.getId());
            this.put(UUID.fromString("3AF4D8C3-FCFC-42B0-98A3-BFB669AA7CE6"), Turrets.CRYOLATOR.getId());
            this.put(UUID.fromString("4449D836-F122-409A-8E6C-D7B7438FD08C"), Turrets.REVOLVER.getId());
            this.put(UUID.fromString("97E1FB65-EE36-43BA-A900-583B4BD7973A"), Turrets.MINIGUN.getId());
            this.put(UUID.fromString("95C3D0DC-000E-4E2D-9551-C9C897E072DC"), Turrets.FORCEFIELD.getId());
            this.put(UUID.fromString("F6196022-3F9D-4D3F-B3C1-9ED644DB436B"), Turrets.LASER.getId());
            this.put(UUID.fromString("0C61E401-A5F9-44E9-8B29-3A3DC7762C73"), Turrets.FLAMETHROWER.getId());
        }
    });
    public static final Map<ResourceLocation, ResourceLocation> OLD_TURRET_ID_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>(){
        {
            this.put(new ResourceLocation("sapturretmod", "turret.crossbow"), Turrets.CROSSBOW.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.shotgun"), Turrets.SHOTGUN.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.cryolator"), Turrets.CRYOLATOR.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.harpoon"), Turrets.HARPOON.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.revolver"), Turrets.REVOLVER.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.minigun"), Turrets.MINIGUN.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.forcefield"), Turrets.FORCEFIELD.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.laser"), Turrets.LASER.getId());
            this.put(new ResourceLocation("sapturretmod", "turret.flamethrower"), Turrets.FLAMETHROWER.getId());
        }
    };
    private static final ResourceLocation OLD_UPGRADE_ID = new ResourceLocation("sapturretmod", "turret_upgrade");
    private static final Map<UUID, ResourceLocation> OLD_UPGRADE_MAPPINGS = new HashMap<UUID, ResourceLocation>(){
        {
            this.put(UUID.fromString("1749478F-2A8E-4C56-BC03-6C76CB5DE921"), Upgrades.UPG_STORAGE_I.getId());
            this.put(UUID.fromString("DEFFE281-A2F5-488A-95C1-E9A3BB6E0DD1"), Upgrades.UPG_STORAGE_II.getId());
            this.put(UUID.fromString("50DB1AC3-1CCD-4CB0-AD5A-0777C548655D"), Upgrades.UPG_STORAGE_III.getId());
            this.put(UUID.fromString("2C850D81-0C01-47EA-B3AD-86E4FF523521"), Upgrades.AMMO_STORAGE.getId());
            this.put(UUID.fromString("13218AB7-3DA6-461D-9882-13482291164B"), Upgrades.HEALTH_I.getId());
            this.put(UUID.fromString("612A78CB-ED0C-4990-B1F3-041BE8171B1A"), Upgrades.HEALTH_II.getId());
            this.put(UUID.fromString("2239A7BB-DD38-4764-9FFC-6E04934F9B3C"), Upgrades.HEALTH_III.getId());
            this.put(UUID.fromString("FF6CC60F-EEC7-40C5-92D8-A614DFA06777"), Upgrades.HEALTH_IV.getId());
            this.put(UUID.fromString("4ED4E813-E2D8-43E9-B499-9911E214C5E9"), Upgrades.RELOAD_I.getId());
            this.put(UUID.fromString("80877F84-F03D-4ED8-A9D3-BAF6DF4F3BF1"), Upgrades.RELOAD_II.getId());
            this.put(UUID.fromString("12435AB9-5AA3-4DB9-9B76-7943BA71597A"), Upgrades.SMART_TGT.getId());
            this.put(UUID.fromString("A8F29058-C8B7-400D-A7F4-4CEDE627A7E8"), Upgrades.ECONOMY_I.getId());
            this.put(UUID.fromString("2A76A2EB-0EA3-4EB0-9EC2-61E579361306"), Upgrades.ECONOMY_II.getId());
            this.put(UUID.fromString("C3CF3EE9-8314-4766-A5E0-6033DB3EE9DB"), Upgrades.ECONOMY_INF.getId());
            this.put(UUID.fromString("0ED3D861-F11D-4F6B-B9FC-67E22C8EB538"), Upgrades.ENDER_MEDIUM.getId());
            this.put(UUID.fromString("677FA826-DA2D-40E9-9D86-7FAD7DE398CC"), Upgrades.FUEL_PURIFY.getId());
            this.put(UUID.fromString("90F61412-4ECC-431B-A6AC-288F26C37608"), Upgrades.SHIELD_PERSONAL.getId());
            this.put(UUID.fromString("AB5E19F9-C241-4F3C-B04E-6C276369B0CF"), Upgrades.SHIELD_PROJECTILE.getId());
            this.put(UUID.fromString("853DB6B1-EAEF-4175-B1EE-02F765D24D25"), Upgrades.SHIELD_EXPLOSIVE.getId());
            this.put(UUID.fromString("C03BFDDA-1415-4519-BE59-61C568B6345E"), Upgrades.SHIELD_STRENGTH_I.getId());
            this.put(UUID.fromString("EF8BF1BB-437E-491D-AD6A-03F807987FAE"), Upgrades.SHIELD_STRENGTH_II.getId());
            this.put(UUID.fromString("320F0103-BA1B-4DA6-9ABA-211A1EF84F12"), Upgrades.ENDER_TOXIN_I.getId());
            this.put(UUID.fromString("6A68C909-D73D-49A7-AF71-5366BCEFBB37"), Upgrades.ENDER_TOXIN_II.getId());
        }
    };
    private static final Map<ResourceLocation, ResourceLocation> OLD_UPGRADE_ID_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>(){
        {
            this.put(new ResourceLocation("sapturretmod", "upgrade.upgstorage.1"), Upgrades.UPG_STORAGE_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.upgstorage.2"), Upgrades.UPG_STORAGE_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.upgstorage.3"), Upgrades.UPG_STORAGE_III.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.ammostorage"), Upgrades.AMMO_STORAGE.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.health.1"), Upgrades.HEALTH_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.health.2"), Upgrades.HEALTH_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.health.3"), Upgrades.HEALTH_III.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.health.4"), Upgrades.HEALTH_IV.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.reload.1"), Upgrades.RELOAD_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.reload.2"), Upgrades.RELOAD_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.smarttgt"), Upgrades.SMART_TGT.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.ammousage.1"), Upgrades.ECONOMY_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.ammousage.2"), Upgrades.ECONOMY_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.ammousage.inf"), Upgrades.ECONOMY_INF.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.endermedium"), Upgrades.ENDER_MEDIUM.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.fuelpurifier"), Upgrades.FUEL_PURIFY.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.personal"), Upgrades.SHIELD_PERSONAL.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.projectile"), Upgrades.SHIELD_PROJECTILE.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.explosive"), Upgrades.SHIELD_EXPLOSIVE.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.strength.1"), Upgrades.SHIELD_STRENGTH_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.strength.2"), Upgrades.SHIELD_STRENGTH_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.shield.colorizer"), Upgrades.SHIELD_COLORIZER.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.endertoxin.1"), Upgrades.ENDER_TOXIN_I.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.endertoxin.2"), Upgrades.ENDER_TOXIN_II.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.leveling"), Upgrades.LEVELING.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.turretsafe"), Upgrades.TURRET_SAFE.getId());
            this.put(new ResourceLocation("sapturretmod", "upgrade.empty"), UpgradeRegistry.EMPTY_UPGRADE.getId());
        }
    };
    private static final ResourceLocation OLD_REPKIT_ID = new ResourceLocation("sapturretmod", "repair_kit");
    private static final Map<UUID, IRepairKit> OLD_REPKIT_MAPPINGS = new HashMap<UUID, IRepairKit>(){
        {
            this.put(UUID.fromString("89db7dd5-2ded-4e58-96dd-07e47bffa919"), RepairKits.STANDARD_MK1);
            this.put(UUID.fromString("36477c40-3eb3-4997-a2ec-3a9a37be86d5"), RepairKits.STANDARD_MK2);
            this.put(UUID.fromString("c9ecc3ea-8bfa-4e42-b401-e0475a23d7f6"), RepairKits.STANDARD_MK3);
            this.put(UUID.fromString("6b3cbd27-1efa-4ee2-b8c8-35d2988361b9"), RepairKits.STANDARD_MK4);
            this.put(UUID.fromString("4c44ca3d-4f32-44e6-bf2e-11189ec88a73"), RepairKits.REGEN_MK1);
        }
    };
    private static final Map<ResourceLocation, ResourceLocation> OLD_REPKIT_ID_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>(){
        {
            this.put(new ResourceLocation("sapturretmod", "repkit.standard.1"), RepairKits.STANDARD_MK1.getId());
            this.put(new ResourceLocation("sapturretmod", "repkit.standard.2"), RepairKits.STANDARD_MK2.getId());
            this.put(new ResourceLocation("sapturretmod", "repkit.standard.3"), RepairKits.STANDARD_MK3.getId());
            this.put(new ResourceLocation("sapturretmod", "repkit.standard.4"), RepairKits.STANDARD_MK4.getId());
            this.put(new ResourceLocation("sapturretmod", "repkit.regen.1"), RepairKits.REGEN_MK1.getId());
        }
    };
    private static boolean activated = false;

    @SubscribeEvent
    public static void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList list = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping map : list) {
            if (map.key.equals((Object)OLD_AMMO_ID)) {
                activated = true;
                map.remap((IForgeRegistryEntry)ItemRegistry.TURRET_AMMO.get(Ammunitions.BOLT.getId()));
                continue;
            }
            if (map.key.equals((Object)OLD_TURRET_ID)) {
                activated = true;
                map.remap((IForgeRegistryEntry)ItemRegistry.TURRET_PLACERS.get(Turrets.CROSSBOW.getId()));
                continue;
            }
            if (map.key.equals((Object)OLD_UPGRADE_ID)) {
                activated = true;
                map.remap((IForgeRegistryEntry)ItemRegistry.TURRET_UPGRADES.get(UpgradeRegistry.EMPTY_UPGRADE.getId()));
                continue;
            }
            if (map.key.equals((Object)OLD_REPKIT_ID)) {
                activated = true;
                map.remap((IForgeRegistryEntry)ItemRegistry.TURRET_REPAIRKITS.get(RepairKits.STANDARD_MK1.getId()));
                continue;
            }
            if (OLD_UPGRADE_ID_MAPPINGS.containsKey(map.key)) {
                activated = true;
                map.remap((IForgeRegistryEntry)Item.func_111206_d((String)OLD_UPGRADE_ID_MAPPINGS.get(map.key).toString()));
                continue;
            }
            if (OLD_AMMO_ID_MAPPINGS.containsKey(map.key)) {
                activated = true;
                map.remap((IForgeRegistryEntry)Item.func_111206_d((String)OLD_AMMO_ID_MAPPINGS.get(map.key).toString()));
                continue;
            }
            if (OLD_TURRET_ID_MAPPINGS.containsKey(map.key)) {
                activated = true;
                map.remap((IForgeRegistryEntry)Item.func_111206_d((String)OLD_TURRET_ID_MAPPINGS.get(map.key).toString()));
                continue;
            }
            if (!OLD_REPKIT_ID_MAPPINGS.containsKey(map.key)) continue;
            activated = true;
            map.remap((IForgeRegistryEntry)Item.func_111206_d((String)OLD_REPKIT_ID_MAPPINGS.get(map.key).toString()));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            activated = false;
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (activated) {
            try {
                Chunk chunk = event.getChunk();
                chunk.func_177434_r().values().forEach(te -> Arrays.stream(EnumFacing.field_82609_l).forEach(f -> {
                    IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f);
                    if (handler instanceof IItemHandlerModifiable) {
                        ItemRemapper.replaceOldItems((IItemHandlerModifiable)handler);
                    }
                }));
                Arrays.stream(chunk.func_177429_s()).forEach(cimm -> cimm.forEach(e -> {
                    IItemHandler handler = (IItemHandler)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                    if (handler instanceof IItemHandlerModifiable) {
                        ItemRemapper.replaceOldItems((IItemHandlerModifiable)handler);
                    }
                    if (e instanceof EntityTurret) {
                        ItemStack newAmmoStack;
                        EntityTurret turret = (EntityTurret)e;
                        ItemStack oldStack = turret.getTargetProcessor().getAmmoStack();
                        if (ItemStackUtils.isValid((ItemStack)oldStack) && oldStack.func_77973_b() instanceof ItemAmmo && ItemStackUtils.isValid((ItemStack)(newAmmoStack = ItemRemapper.getNewAmmoStack(oldStack)))) {
                            ((TargetProcessor)turret.getTargetProcessor()).setAmmoStackInternal(newAmmoStack);
                        }
                        IUpgradeProcessor uProc = turret.getUpgradeProcessor();
                        int max = uProc.func_70302_i_();
                        for (int i = 0; i < max; ++i) {
                            ItemStack newUpgradeStack;
                            oldStack = uProc.func_70301_a(i);
                            if (!ItemStackUtils.isValid((ItemStack)oldStack) || !(oldStack.func_77973_b() instanceof ItemUpgrade) || !ItemStackUtils.isValid((ItemStack)(newUpgradeStack = ItemRemapper.getNewUpgradeStack(oldStack)))) continue;
                            uProc.func_70299_a(i, newUpgradeStack);
                        }
                    }
                }));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (activated && event.getEntity() instanceof EntityPlayer) {
            IItemHandler handler;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.field_72995_K && (handler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) instanceof IItemHandlerModifiable) {
                ItemRemapper.replaceOldItems((IItemHandlerModifiable)handler);
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    private static void replaceOldItems(IItemHandlerModifiable handler) {
        int max = handler.getSlots();
        for (int i = 0; i < max; ++i) {
            ItemStack oldStack = handler.getStackInSlot(i);
            if (!ItemStackUtils.isValid((ItemStack)oldStack)) continue;
            ItemStack stack = ItemStack.field_190927_a;
            if (oldStack.func_77973_b() instanceof ItemAmmo) {
                stack = ItemRemapper.getNewAmmoStack(oldStack);
            } else if (oldStack.func_77973_b() instanceof ItemTurret) {
                stack = ItemRemapper.getNewTurretStack(oldStack);
            } else if (oldStack.func_77973_b() instanceof ItemUpgrade) {
                stack = ItemRemapper.getNewUpgradeStack(oldStack);
            } else if (oldStack.func_77973_b() instanceof ItemRepairKit) {
                stack = ItemRemapper.getNewRepkitStack(oldStack);
            }
            if (!ItemStackUtils.isValid((ItemStack)stack)) continue;
            stack.func_190920_e(oldStack.func_190916_E());
            handler.setStackInSlot(i, stack);
        }
    }

    private static ItemStack getNewRepkitStack(ItemStack oldStack) {
        NBTTagCompound nbt = oldStack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("repKitType", 8)) {
            UUID oldRepkitId;
            String oldRepkitIdStr = nbt.func_74779_i("repKitType");
            UUID uUID = oldRepkitId = UuidUtils.isStringUuid((String)oldRepkitIdStr) ? UUID.fromString(oldRepkitIdStr) : null;
            if (OLD_REPKIT_MAPPINGS.containsKey(oldRepkitId)) {
                ItemStack stack = RepairKitRegistry.INSTANCE.getItem(OLD_REPKIT_MAPPINGS.get(oldRepkitId).getId());
                stack.func_190920_e(oldStack.func_190916_E());
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getNewUpgradeStack(ItemStack oldStack) {
        NBTTagCompound nbt = oldStack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("upgradeId", 8)) {
            UUID oldUpgradeId;
            String oldUpgradeIdStr = nbt.func_74779_i("upgradeId");
            UUID uUID = oldUpgradeId = UuidUtils.isStringUuid((String)oldUpgradeIdStr) ? UUID.fromString(oldUpgradeIdStr) : null;
            if (OLD_UPGRADE_MAPPINGS.containsKey(oldUpgradeId)) {
                ItemStack stack = UpgradeRegistry.INSTANCE.getItem(OLD_UPGRADE_MAPPINGS.get(oldUpgradeId));
                stack.func_190920_e(oldStack.func_190916_E());
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getNewAmmoStack(ItemStack oldStack) {
        NBTTagCompound nbt = oldStack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("ammoType", 8)) {
            UUID oldAmmoType;
            String oldAmmoTypeStr = nbt.func_74779_i("ammoType");
            UUID uUID = oldAmmoType = UuidUtils.isStringUuid((String)oldAmmoTypeStr) ? UUID.fromString(oldAmmoTypeStr) : null;
            if (OLD_AMMO_MAPPINGS.containsKey(oldAmmoType)) {
                ItemStack stack = AmmunitionRegistry.INSTANCE.getItem(OLD_AMMO_MAPPINGS.get(oldAmmoType));
                stack.func_190920_e(oldStack.func_190916_E());
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getNewTurretStack(ItemStack oldStack) {
        NBTTagCompound nbt = oldStack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("turretUUID", 8)) {
            UUID oldTurretType;
            String oldTurretTypeStr = nbt.func_74779_i("turretUUID");
            UUID uUID = oldTurretType = UuidUtils.isStringUuid((String)oldTurretTypeStr) ? UUID.fromString(oldTurretTypeStr) : null;
            if (OLD_TURRET_MAPPINGS.containsKey(oldTurretType)) {
                ItemStack stack = TurretRegistry.INSTANCE.getItem(OLD_TURRET_MAPPINGS.get(oldTurretType));
                stack.func_190920_e(oldStack.func_190916_E());
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

