/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IVariant;
import de.sanandrew.mods.turretmod.api.turret.IVariantHolder;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.Lang;
import de.sanandrew.mods.turretmod.registry.TmrCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTurret
extends Item {
    public final ITurret turret;

    public ItemTurret(ITurret turret) {
        this.turret = turret;
        ResourceLocation id = turret.getId();
        this.func_77637_a(TmrCreativeTabs.TURRETS);
        this.setRegistryName(id);
        this.func_77655_b(id.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TurretStats stats = new TurretStats(stack.func_77978_p());
        if (stats.variant != null && this.turret instanceof IVariantHolder) {
            IVariant variant = ((IVariantHolder)((Object)this.turret)).getVariant(stats.variant);
            tooltip.add(LangUtils.translate((String)Lang.ITEM_TURRET_PLACER.get(new Object[]{"variant"}), (Object[])new Object[]{variant.getTranslatedName()}));
        }
        if (stats.name != null) {
            tooltip.add(LangUtils.translate((String)Lang.ITEM_TURRET_PLACER.get(new Object[]{"customname"}), (Object[])new Object[]{stats.name}));
        }
        if (stats.health != null) {
            tooltip.add(LangUtils.translate((String)Lang.ITEM_TURRET_PLACER.get(new Object[]{"health"}), (Object[])new Object[]{stats.health}));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            BlockPos placingOn = pos.func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e());
            if (facing.func_96559_d() == 0) {
                placingOn = placingOn.func_177972_a(EnumFacing.DOWN);
            }
            ItemStack stack = player.func_184586_b(hand);
            if (!this.turret.isBuoy() && EntityTurret.canTurretBePlaced(this.turret, world, placingOn, false)) {
                EntityTurret bob = ItemTurret.spawnTurret(world, this.turret, (double)placingOn.func_177958_n() + 0.5, placingOn.func_177956_o() + 1, (double)placingOn.func_177952_p() + 0.5, player);
                new TurretStats(stack.func_77978_p()).apply(bob);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult traceResult;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (traceResult = this.func_77621_a(world, player, true)) != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityTurret susan;
            BlockPos blockPos = traceResult.func_178782_a();
            if (!world.func_175660_a(player, blockPos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!player.func_175151_a(blockPos, traceResult.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            BlockPos lowerPos = blockPos.func_177977_b();
            if (this.turret.isBuoy() && ItemTurret.isBlockLiquid(world, blockPos) && ItemTurret.isBlockLiquid(world, lowerPos) && EntityTurret.canTurretBePlaced(this.turret, world, lowerPos, false) && (susan = ItemTurret.spawnTurret(world, this.turret, lowerPos, player)) != null) {
                new TurretStats(stack.func_77978_p()).apply(susan);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static boolean isBlockLiquid(World world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        return b instanceof BlockLiquid || b instanceof IFluidBlock;
    }

    private static EntityTurret spawnTurret(World world, ITurret turret, BlockPos pos, EntityPlayer owner) {
        return ItemTurret.spawnTurret(world, turret, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, owner);
    }

    private static EntityTurret spawnTurret(World world, ITurret turret, double x, double y, double z, EntityPlayer owner) {
        EntityTurret turretE = new EntityTurret(world, owner, turret);
        turretE.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        turretE.field_70759_as = turretE.field_70177_z;
        turretE.field_70761_aq = turretE.field_70177_z;
        world.func_72838_d((Entity)turretE);
        turretE.func_70642_aH();
        return turretE;
    }

    public static final class TurretStats {
        public final Float health;
        public final String name;
        public final ResourceLocation variant;

        public TurretStats(ITurretInst turretInst) {
            EntityLiving bob = turretInst.get();
            this.health = Float.valueOf(bob.func_110143_aJ());
            this.name = bob.func_145818_k_() ? bob.func_95999_t() : null;
            IVariant variant = turretInst.getVariant();
            this.variant = variant != null ? variant.getId() : null;
        }

        public TurretStats(Float health, String name, IVariant variant) {
            this.health = health;
            this.name = name;
            this.variant = variant.getId();
        }

        public TurretStats(NBTTagCompound nbt) {
            if (nbt != null && nbt.func_150297_b("TurretStats", 10)) {
                this.health = (nbt = nbt.func_74775_l("TurretStats")).func_150297_b("Health", 99) ? Float.valueOf(nbt.func_74760_g("Health")) : null;
                this.name = nbt.func_150297_b("Name", 8) ? nbt.func_74779_i("Name") : null;
                this.variant = nbt.func_150297_b("Variant", 8) ? new ResourceLocation(nbt.func_74779_i("Variant")) : null;
            } else {
                this.health = null;
                this.name = null;
                this.variant = null;
            }
        }

        public void apply(ITurretInst turretInst) {
            EntityLiving bob = turretInst.get();
            if (this.health != null) {
                bob.func_70606_j(this.health.floatValue());
            }
            if (this.name != null) {
                bob.func_96094_a(this.name);
            }
            if (this.variant != null) {
                turretInst.setVariant(this.variant);
            }
        }

        public NBTTagCompound updateData(ItemStack stack) {
            return this.serialize(stack.func_190925_c("TurretStats"));
        }

        public NBTTagCompound serialize(NBTTagCompound nbt) {
            if (this.health != null) {
                nbt.func_74776_a("Health", this.health.floatValue());
            }
            if (this.name != null) {
                nbt.func_74778_a("Name", this.name);
            }
            if (this.variant != null) {
                nbt.func_74778_a("Variant", this.variant.toString());
            }
            return nbt;
        }
    }
}

