/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.TmrCreativeTabs;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemTurretControlUnit
extends Item {
    private static final String NBT_BOUND_TURRET = "sapturretmod.bound_turret";
    private static final int EE_NAME_COUNT = 5;
    private long prevDisplayNameTime = 0L;
    private int nameId = 0;

    ItemTurretControlUnit() {
        this.func_77637_a(TmrCreativeTabs.MISC);
        this.func_77655_b("sapturretmod:turret_control_unit");
        this.setRegistryName("sapturretmod", "turret_control_unit");
    }

    public String func_77653_i(@Nonnull ItemStack stack) {
        long currDisplayNameTime = System.currentTimeMillis();
        if (this.prevDisplayNameTime + 1000L < currDisplayNameTime) {
            this.nameId = MiscUtils.RNG.randomInt(1000) != 0 ? 0 : MiscUtils.RNG.randomInt(4) + 1;
        }
        this.prevDisplayNameTime = currDisplayNameTime;
        if (this.nameId < 1) {
            return super.func_77653_i(stack);
        }
        return LangUtils.translate((String)String.format("%s.name_%d", this.func_77658_a(), this.nameId), (Object[])new Object[0]);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        if (ItemTurretControlUnit.getBoundID(stack) != null) {
            tooltip.add(ChatFormatting.GRAY + LangUtils.translate((String)String.format("%s.bound", this.func_77658_a()), (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ITurretInst turretInst;
        ItemStack heldStack = player.func_184586_b(hand);
        if (ItemStackUtils.isItem((ItemStack)heldStack, (Item)ItemRegistry.TURRET_CONTROL_UNIT) && (turretInst = ItemTurretControlUnit.getBoundTurret(heldStack, world)) != null) {
            if (!world.field_72995_K) {
                if (player.func_70093_af()) {
                    ItemTurretControlUnit.bindTurret(heldStack, null);
                } else {
                    TurretModRebirth.proxy.openGui(player, EnumGui.TCU, turretInst.get().func_145782_y(), 0, 1);
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    private static UUID getBoundID(ItemStack stack) {
        NBTTagCompound boundTurret = stack.func_179543_a(NBT_BOUND_TURRET);
        if (boundTurret != null && boundTurret.func_150297_b("id_low", 4) && boundTurret.func_150297_b("id_high", 4)) {
            return new UUID(boundTurret.func_74763_f("id_high"), boundTurret.func_74763_f("id_low"));
        }
        return null;
    }

    public static boolean isHeldTcuBoundToTurret(EntityPlayer player, ITurretInst turretInst) {
        if (player == null) {
            return false;
        }
        ItemStack mh = player.func_184614_ca();
        ItemStack oh = player.func_184592_cb();
        return ItemTurretControlUnit.getBoundTurret(mh, player.field_70170_p) == turretInst || ItemTurretControlUnit.getBoundTurret(oh, player.field_70170_p) == turretInst;
    }

    public static ITurretInst getBoundTurret(ItemStack stack, World world) {
        Entity entity;
        if (!ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT)) {
            return null;
        }
        UUID id = ItemTurretControlUnit.getBoundID(stack);
        if (id != null && (entity = EntityUtils.getEntityByUUID((World)world, (UUID)id)) instanceof EntityTurret) {
            return (EntityTurret)entity;
        }
        return null;
    }

    public static void bindTurret(ItemStack stack, ITurretInst turretInst) {
        if (!ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT)) {
            return;
        }
        NBTTagCompound boundTurret = stack.func_179543_a(NBT_BOUND_TURRET);
        if (turretInst != null) {
            if (boundTurret == null) {
                boundTurret = stack.func_190925_c(NBT_BOUND_TURRET);
            }
            UUID persistentId = turretInst.get().getPersistentID();
            boundTurret.func_74772_a("id_low", persistentId.getLeastSignificantBits());
            boundTurret.func_74772_a("id_high", persistentId.getMostSignificantBits());
        } else {
            stack.func_190919_e(NBT_BOUND_TURRET);
            NBTTagCompound cmp = stack.func_77978_p();
            if (cmp != null && cmp.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }
}

