/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.init.TurretModRebirth;
import de.sanandrew.mods.turretmod.registry.Lang;
import de.sanandrew.mods.turretmod.registry.TmrCreativeTabs;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.Range;

public class ItemUpgrade
extends Item {
    public final IUpgrade upgrade;

    public ItemUpgrade(IUpgrade upgrade) {
        this.upgrade = upgrade;
        this.func_77637_a(TmrCreativeTabs.UPGRADES);
        this.setRegistryName(upgrade.getId());
        this.func_77655_b(upgrade.getId().toString());
        this.func_185043_a(new ResourceLocation("onTurret"), (stack, world, entity) -> entity instanceof EntityTurret ? 1.0f : 0.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean hasRng;
        IUpgrade prereq = this.upgrade.getDependantOn();
        ITurret[] turretWL = this.upgrade.getApplicableTurrets();
        Range<Integer> rng = this.upgrade.getTierRange();
        boolean hasPrereq = prereq != null && prereq.isValid();
        boolean hasTurretWL = turretWL != null && turretWL.length > 0;
        boolean bl = hasRng = rng != null && (Integer)rng.getMinimum() > 0;
        if (TurretModRebirth.proxy.isPlayerPressingShift()) {
            if (hasPrereq) {
                tooltip.add(LangUtils.translate((String)Lang.ITEM_UPGRADE.get(new Object[]{"requires"}), (Object[])new Object[0]));
                tooltip.add(ChatFormatting.GOLD + String.format("  %s", UpgradeRegistry.INSTANCE.getItem(prereq.getId()).func_82833_r()));
            }
            if (hasTurretWL) {
                tooltip.add(LangUtils.translate((String)Lang.ITEM_UPGRADE.get(new Object[]{"applicable_to"}), (Object[])new Object[0]));
                for (ITurret t : turretWL) {
                    tooltip.add(ChatFormatting.GOLD + String.format("  %s", TurretRegistry.INSTANCE.getItem(t.getId()).func_82833_r()));
                }
            }
            if (hasRng) {
                int to;
                int from = (Integer)rng.getMinimum();
                if (from == (to = ((Integer)rng.getMaximum()).intValue())) {
                    tooltip.add(LangUtils.translate((String)Lang.ITEM_UPGRADE.get(new Object[]{"tier_range_single"}), (Object[])new Object[0]));
                    tooltip.add(ChatFormatting.GOLD + String.format("  %d", from));
                } else {
                    tooltip.add(LangUtils.translate((String)Lang.ITEM_UPGRADE.get(new Object[]{"tier_range_multiple"}), (Object[])new Object[0]));
                    tooltip.add(ChatFormatting.GOLD + String.format("  %d - %d", from, to));
                }
            }
        } else if (hasPrereq || hasTurretWL || hasRng) {
            tooltip.add(ChatFormatting.ITALIC + LangUtils.translate((String)Lang.ITEM_UPGRADE.get(new Object[]{"shift_details"}), (Object[])new Object[0]));
        }
    }
}

