/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketInitAssemblyCrafting
extends AbstractMessage<PacketInitAssemblyCrafting> {
    private BlockPos pos;
    private String crfId;
    private int count;

    public PacketInitAssemblyCrafting() {
    }

    public PacketInitAssemblyCrafting(TileEntityTurretAssembly assembly, ResourceLocation id, int count) {
        this.pos = assembly.func_174877_v();
        this.crfId = id == null ? null : id.toString();
        this.count = count;
    }

    public PacketInitAssemblyCrafting(TileEntityTurretAssembly assembly) {
        this.pos = assembly.func_174877_v();
        this.crfId = null;
        this.count = 0;
    }

    public void handleClientMessage(PacketInitAssemblyCrafting packet, EntityPlayer player) {
    }

    public void handleServerMessage(PacketInitAssemblyCrafting packet, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_175625_s(packet.pos);
        if (te instanceof TileEntityTurretAssembly) {
            if (packet.crfId == null) {
                ((TileEntityTurretAssembly)te).cancelCrafting();
            } else {
                ((TileEntityTurretAssembly)te).beginCrafting(AssemblyManager.INSTANCE.getRecipe(new ResourceLocation(packet.crfId)), packet.count);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        if (buf.readBoolean()) {
            this.crfId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.count = buf.readByte();
        } else {
            this.crfId = null;
            this.count = 0;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        if (this.crfId == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.crfId);
            buf.writeByte(this.count);
        }
    }
}

