/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.world.PlayerList;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSyncPlayerList
extends AbstractMessage<PacketSyncPlayerList> {
    private Map<UUID, String> players;

    public PacketSyncPlayerList() {
    }

    public PacketSyncPlayerList(PlayerList pList) {
        this.players = pList.getPlayerMap();
    }

    public void handleClientMessage(PacketSyncPlayerList packet, EntityPlayer player) {
        PlayerList.INSTANCE.putPlayersClient(packet.players);
    }

    public void handleServerMessage(PacketSyncPlayerList packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.players = new HashMap<UUID, String>(size);
        for (int i = 0; i < size; ++i) {
            this.players.put(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.players.size());
        for (Map.Entry<UUID, String> player : this.players.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.getKey().toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)player.getValue());
        }
    }
}

