/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.registry.turret.GuiTcuRegistry;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSyncTcuGuis
extends AbstractMessage<PacketSyncTcuGuis> {
    private Map<Integer, ResourceLocation> pageIds = new TreeMap<Integer, ResourceLocation>();

    public PacketSyncTcuGuis() {
        int max = GuiTcuRegistry.PAGE_KEYS.size();
        for (int i = 0; i < max; ++i) {
            this.pageIds.put(i, GuiTcuRegistry.PAGE_KEYS.get(i));
        }
    }

    public void handleClientMessage(PacketSyncTcuGuis packet, EntityPlayer player) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuiTcuRegistry.PAGE_KEYS.clear();
            packet.pageIds.forEach((pos, key) -> {
                if (GuiTcuRegistry.PAGE_KEYS.size() >= pos) {
                    GuiTcuRegistry.PAGE_KEYS.add((ResourceLocation)key);
                } else {
                    GuiTcuRegistry.PAGE_KEYS.set((int)pos, (ResourceLocation)key);
                }
            });
        }
    }

    public void handleServerMessage(PacketSyncTcuGuis packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.pageIds = new HashMap<Integer, ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            this.pageIds.put(i, new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pageIds.size());
        this.pageIds.forEach((pos, key) -> {
            buf.writeInt(pos.intValue());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)key.toString());
        });
    }
}

