/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class PacketSyncUpgradeInst
extends AbstractMessage<PacketSyncUpgradeInst> {
    private int turretId;
    private ResourceLocation upgradeId;
    private byte[] instData;

    public PacketSyncUpgradeInst() {
    }

    public PacketSyncUpgradeInst(ITurretInst turret, ResourceLocation upgradeId) {
        this.turretId = turret.get().func_145782_y();
        this.upgradeId = upgradeId;
        Object upgInstance = turret.getUpgradeProcessor().getUpgradeInstance(upgradeId);
        if (upgInstance != null) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(bos);){
                upgInstance.toBytes(oos);
                oos.close();
                this.instData = bos.toByteArray();
            }
            catch (IOException e) {
                TmrConstants.LOG.log(Level.ERROR, "Cannot sync upgrade instance", (Throwable)e);
            }
        }
    }

    public void handleClientMessage(PacketSyncUpgradeInst packet, EntityPlayer player) {
        PacketSyncUpgradeInst.handleMessage(packet, player, Side.CLIENT);
    }

    public void handleServerMessage(PacketSyncUpgradeInst packet, EntityPlayer player) {
        PacketSyncUpgradeInst.handleMessage(packet, player, Side.SERVER);
    }

    private static void handleMessage(PacketSyncUpgradeInst packet, EntityPlayer player, Side side) {
        Entity e;
        if (packet.instData.length > 0 && (e = player.field_70170_p.func_73045_a(packet.turretId)) instanceof ITurretInst) {
            IUpgradeProcessor processor = ((ITurretInst)e).getUpgradeProcessor();
            Object upgInstance = processor.getUpgradeInstance(packet.upgradeId);
            if (upgInstance != null) {
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet.instData));){
                    upgInstance.fromBytes(ois);
                }
                catch (IOException ex) {
                    TmrConstants.LOG.log(Level.ERROR, String.format("Cannot sync upgrade instance on side %s.", side), (Throwable)ex);
                }
            } else {
                TmrConstants.LOG.log(Level.ERROR, String.format("Cannot sync upgrade instance on side %s from upgrade ID %s; it has no default instance available!", side, packet.upgradeId), (Throwable)new Exception("No upgrade instance"));
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.turretId = buf.readInt();
        this.upgradeId = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int lng = buf.readInt();
        this.instData = new byte[lng];
        if (lng > 0) {
            buf.readBytes(this.instData);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.upgradeId.toString());
        buf.writeInt(this.instData.length);
        buf.writeBytes(this.instData);
    }
}

