/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public class PacketUpdateTurretState
extends AbstractMessage<PacketUpdateTurretState> {
    private int turretId;
    private int entityToAttackId;
    private int currAmmoCap;
    @Nonnull
    private ItemStack ammoStack;
    private boolean isShooting;
    private byte[] delegateData;

    public PacketUpdateTurretState() {
    }

    public PacketUpdateTurretState(ITurretInst turret) {
        this.turretId = turret.get().func_145782_y();
        ITargetProcessor tgtProc = turret.getTargetProcessor();
        this.entityToAttackId = tgtProc.hasTarget() ? tgtProc.getTarget().func_145782_y() : -1;
        this.currAmmoCap = tgtProc.getAmmoCount();
        this.ammoStack = tgtProc.getAmmoStack();
        this.isShooting = tgtProc.isShooting();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            turret.getTurret().writeSyncData(turret, oos);
            oos.close();
            this.delegateData = bos.toByteArray();
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot sync turret instance", (Throwable)e);
        }
    }

    public void handleClientMessage(PacketUpdateTurretState packet, EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(packet.turretId);
        if (e instanceof ITurretInst) {
            ITurretInst turret = (ITurretInst)e;
            ((TargetProcessor)turret.getTargetProcessor()).updateClientState(packet.entityToAttackId, packet.currAmmoCap, packet.ammoStack, packet.isShooting);
            if (packet.delegateData.length > 0) {
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet.delegateData));){
                    turret.getTurret().readSyncData(turret, ois);
                }
                catch (IOException ex) {
                    TmrConstants.LOG.log(Level.ERROR, "Cannot sync turret instance", (Throwable)ex);
                }
            }
        }
    }

    public void handleServerMessage(PacketUpdateTurretState packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        this.turretId = buf.readInt();
        this.entityToAttackId = buf.readInt();
        this.currAmmoCap = buf.readInt();
        this.isShooting = buf.readBoolean();
        this.ammoStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        int lng = buf.readInt();
        this.delegateData = new byte[lng];
        if (lng > 0) {
            buf.readBytes(this.delegateData);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretId);
        buf.writeInt(this.entityToAttackId);
        buf.writeInt(this.currAmmoCap);
        buf.writeBoolean(this.isShooting);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.ammoStack);
        buf.writeInt(this.delegateData.length);
        buf.writeBytes(this.delegateData);
    }
}

