/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import com.google.common.base.Strings;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunitionRegistry;
import de.sanandrew.mods.turretmod.api.ammo.IProjectile;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.item.ItemAmmo;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;
import org.apache.logging.log4j.Level;

public final class AmmunitionRegistry
implements IAmmunitionRegistry {
    public static final AmmunitionRegistry INSTANCE = new AmmunitionRegistry();
    private final Map<ResourceLocation, IAmmunition> ammoTypes = new HashMap<ResourceLocation, IAmmunition>();
    private final Map<ITurret, UModList<IAmmunition>> ammoTypesFromTurret = new HashMap<ITurret, UModList<IAmmunition>>();
    private final Collection<IAmmunition> uAmmoTypes = Collections.unmodifiableCollection(this.ammoTypes.values());
    private static final IAmmunition NULL_TYPE = new IAmmunition(){
        private final ResourceLocation id = new ResourceLocation("null");

        @Override
        @Nonnull
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        @Nonnull
        public ITurret getTurret() {
            return TurretRegistry.INSTANCE.getDefaultObject();
        }

        @Override
        @Nonnull
        public Range<Float> getDamageInfo() {
            return Range.is((Comparable)Float.valueOf(0.0f));
        }

        @Override
        public int getAmmoCapacity() {
            return 0;
        }

        @Override
        public IProjectile getProjectile(ITurretInst turretInst) {
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };

    private AmmunitionRegistry() {
    }

    @Override
    @Nonnull
    public Collection<IAmmunition> getObjects() {
        return this.uAmmoTypes;
    }

    @Override
    @Nonnull
    public IAmmunition getObject(ResourceLocation id) {
        return this.ammoTypes.getOrDefault(id, NULL_TYPE);
    }

    @Override
    @Nonnull
    public IAmmunition getObject(@Nonnull ItemStack stack) {
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_77973_b() instanceof ItemAmmo) {
            return ((ItemAmmo)stack.func_77973_b()).ammo;
        }
        return NULL_TYPE;
    }

    @Override
    @Nonnull
    public Collection<IAmmunition> getObjects(ITurret turret) {
        return ((UModList)this.ammoTypesFromTurret.get(turret)).umList;
    }

    @Override
    public void register(@Nonnull IAmmunition obj) {
        if (this.ammoTypes.containsKey(obj.getId())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The ammo ID %s is already registered!", obj.getId()), (Throwable)new InvalidParameterException());
            return;
        }
        if (obj.getAmmoCapacity() < 1) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Ammo ID %s provides less than 1 round!", obj.getId()), (Throwable)new InvalidParameterException());
            return;
        }
        this.ammoTypes.put(obj.getId(), obj);
        this.ammoTypesFromTurret.computeIfAbsent(obj.getTurret(), t -> new UModList()).mList.add(obj);
        ItemRegistry.TURRET_AMMO.put(obj.getId(), new ItemAmmo(obj));
    }

    @Override
    public String getSubtype(ItemStack stack) {
        NBTTagCompound tmrStack;
        if (stack.func_77973_b() instanceof ItemAmmo && (tmrStack = stack.func_179543_a("sapturretmod")) != null && tmrStack.func_150297_b("Subtype", 8)) {
            return tmrStack.func_74779_i("Subtype");
        }
        return null;
    }

    @Override
    public ItemStack setSubtype(ItemStack stack, String type) {
        String[] subtypes;
        Item item;
        if (!Strings.isNullOrEmpty((String)type) && (item = stack.func_77973_b()) instanceof ItemAmmo && (subtypes = ((ItemAmmo)item).ammo.getSubtypes()) != null && Arrays.asList(subtypes).contains(type)) {
            stack.func_190925_c("sapturretmod").func_74778_a("Subtype", type);
        }
        return stack;
    }

    @Override
    @Nonnull
    public IAmmunition getDefaultObject() {
        return NULL_TYPE;
    }

    @Override
    @Nonnull
    public ItemStack getItem(ResourceLocation id) {
        return this.getItem(id, null);
    }

    @Override
    @Nonnull
    public ItemStack getItem(ResourceLocation id, String subtype) {
        if (!this.getObject(id).isValid()) {
            throw new IllegalArgumentException("Cannot get turret ammo item with invalid type!");
        }
        return this.setSubtype(new ItemStack((Item)ItemRegistry.TURRET_AMMO.get(id), 1), subtype);
    }

    private static class UModList<T> {
        private final ArrayList<T> mList = new ArrayList();
        private final Collection<T> umList = Collections.unmodifiableList(this.mList);

        private UModList() {
        }
    }
}

