/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.assembly.AssemblyIngredient;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyManager;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public final class AssemblyManager
implements IAssemblyManager {
    public static final AssemblyManager INSTANCE = new AssemblyManager();
    private final Map<ResourceLocation, IAssemblyRecipe> recipes = new LinkedHashMap<ResourceLocation, IAssemblyRecipe>();
    private final Map<String, List<ResourceLocation>> groups = new HashMap<String, List<ResourceLocation>>();
    private final Map<String, ItemStack> groupIcons = new HashMap<String, ItemStack>();
    private final Map<String, Integer> groupOrders = new HashMap<String, Integer>();
    private String[] cacheGroupNames;
    private List<IAssemblyRecipe> cacheRecipes;
    private Map<String, List<IAssemblyRecipe>> cacheGroupToRecipes;

    @Override
    public boolean registerRecipe(@Nonnull IAssemblyRecipe recipe) {
        return this.registerRecipe(recipe, false);
    }

    public boolean registerRecipe(@Nonnull IAssemblyRecipe recipe, boolean throwException) {
        Consumer<String> exc = throwException ? s -> {
            throw new RuntimeException((String)s);
        } : s -> TmrConstants.LOG.log(Level.ERROR, s, (Throwable)new InvalidParameterException());
        ResourceLocation id = recipe.getId();
        if (id == null) {
            exc.accept("ID for assembly recipe cannot be null!");
            return false;
        }
        if (recipe.getFluxPerTick() < 0) {
            exc.accept(String.format("Flux usage cannot be smaller than 0 for assembly recipe %s!", id));
            return false;
        }
        if (recipe.getProcessTime() < 0) {
            exc.accept(String.format("Processing time cannot be smaller than 0 for assembly recipe %s!", id));
            return false;
        }
        if (this.recipes.containsKey(id)) {
            this.removeRecipe(id);
        }
        this.recipes.put(id, recipe);
        this.groups.computeIfAbsent(recipe.getGroup(), k -> new ArrayList()).add(id);
        this.groupOrders.putIfAbsent(recipe.getGroup(), 0);
        this.invalidateCaches();
        return true;
    }

    @Override
    public void removeRecipe(ResourceLocation id) {
        IAssemblyRecipe recipe = this.recipes.remove(id);
        String recipeGroup = recipe.getGroup();
        this.groups.get(recipeGroup).removeIf(r -> r.equals((Object)id));
        if (this.groups.get(recipeGroup).size() < 1) {
            this.groups.remove(recipeGroup);
        }
        this.invalidateCaches();
    }

    @Override
    public void setGroupIcon(String group, ItemStack icon) {
        this.groupIcons.put(group, icon);
    }

    @Override
    public ItemStack getGroupIcon(String group) {
        return this.groupIcons.getOrDefault(group, ItemStack.field_190927_a);
    }

    @Override
    public void setGroupOrder(String group, int ordinal) {
        this.cacheGroupNames = null;
        this.groupOrders.put(group, ordinal);
    }

    @Override
    public String[] getGroups() {
        if (this.cacheGroupNames == null) {
            this.cacheGroupNames = (String[])this.groups.keySet().stream().sorted(Comparator.comparingInt(g -> this.groupOrders.getOrDefault(g, 0))).toArray(String[]::new);
        }
        return this.cacheGroupNames;
    }

    @Override
    public List<IAssemblyRecipe> getRecipes(String groupName) {
        if (this.cacheGroupToRecipes == null) {
            this.cacheGroupToRecipes = this.groups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(this::getRecipe).collect(Collectors.toList())));
        }
        return this.cacheGroupToRecipes.get(groupName);
    }

    @Override
    public IAssemblyRecipe getRecipe(ResourceLocation id) {
        return this.recipes.get(id);
    }

    public IAssemblyRecipe findRecipe(ItemStack output) {
        for (IAssemblyRecipe recipe : this.recipes.values()) {
            if (!ItemStackUtils.areEqual((ItemStack)output, (ItemStack)recipe.getRecipeOutput(), (boolean)false, (boolean)true, (boolean)true)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<IAssemblyRecipe> getRecipes() {
        if (this.cacheRecipes == null) {
            this.cacheRecipes = Collections.unmodifiableList(new ArrayList<IAssemblyRecipe>(this.recipes.values()));
        }
        return this.cacheRecipes;
    }

    public void clearRecipes() {
        this.recipes.clear();
        this.groups.clear();
        this.invalidateCaches();
    }

    public void clearRecipesByGroup(String group) {
        new ArrayList<ResourceLocation>(this.recipes.keySet()).forEach(id -> {
            if (this.recipes.get(id).getGroup().equals(group)) {
                this.removeRecipe((ResourceLocation)id);
            }
        });
    }

    public void finalizeRegistry() {
        LinkedHashMap<ResourceLocation, IAssemblyRecipe> recipeOrdered = new LinkedHashMap<ResourceLocation, IAssemblyRecipe>(this.recipes);
        this.recipes.clear();
        this.recipes.putAll(recipeOrdered.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, AssemblyManager.throwingMerger(), () -> new LinkedHashMap())));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    @Nullable
    public List<ItemStack> checkAndConsumeResources(IInventory inv, World world, IAssemblyRecipe recipe) {
        if (recipe.canFit(9, 2) && recipe.matches(inv, world)) {
            ArrayList<ItemStack> removedStacks = new ArrayList<ItemStack>();
            Map<AssemblyIngredient, Integer> ingredients = recipe.getIngredients().stream().collect(Collectors.toMap(a -> (AssemblyIngredient)((Object)a), a -> ((AssemblyIngredient)((Object)a)).getCount()));
            for (int slot = inv.func_70302_i_() - 1; slot > 3; --slot) {
                ItemStack slotStack = inv.func_70301_a(slot);
                ingredients.entrySet().forEach(e -> {
                    int v = (Integer)e.getValue();
                    AssemblyIngredient ingredient = (AssemblyIngredient)((Object)((Object)e.getKey()));
                    ItemStack slotStackMatch = slotStack.func_77946_l();
                    slotStackMatch.func_190920_e(ingredient.getCount());
                    if (v > 0 && ((AssemblyIngredient)((Object)((Object)e.getKey()))).apply(slotStackMatch)) {
                        int extractAmount = Math.min(slotStack.func_190916_E(), v);
                        ItemStack removed = slotStack.func_77946_l();
                        removed.func_190920_e(extractAmount);
                        slotStack.func_190918_g(extractAmount);
                        removedStacks.add(removed);
                        e.setValue(v - extractAmount);
                    }
                });
                ingredients.entrySet().removeIf(e -> (Integer)e.getValue() < 1);
            }
            return removedStacks;
        }
        return null;
    }

    private void invalidateCaches() {
        this.cacheGroupNames = null;
        this.cacheRecipes = null;
        this.cacheGroupToRecipes = null;
    }
}

