/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AssemblyRecipe
implements IAssemblyRecipe {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> ingredients;
    private final int fluxPerTick;
    private final int processTime;
    private final ItemStack result;
    private final String group;

    public AssemblyRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, int fluxPerTick, int processTime, ItemStack result) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.fluxPerTick = fluxPerTick;
        this.processTime = processTime;
        this.result = result;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public int getFluxPerTick() {
        return this.fluxPerTick;
    }

    @Override
    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public boolean matches(IInventory inv, World worldIn) {
        NonNullList<ItemStack> cmpInv = AssemblyRecipe.getCompactInventory(inv);
        return this.ingredients.stream().allMatch(i -> {
            for (ItemStack invStack : cmpInv) {
                if (!i.apply(invStack)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public ItemStack getCraftingResult(IInventory inv) {
        return this.result.func_77946_l();
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    private static NonNullList<ItemStack> getCompactInventory(IInventory inv) {
        NonNullList items = NonNullList.func_191196_a();
        int max = inv.func_70302_i_();
        for (int slot = 0; slot < max; ++slot) {
            items.add((Object)inv.func_70301_a(slot));
        }
        return ItemStackUtils.getCompactItems((NonNullList)items, (int)Integer.MAX_VALUE, (Integer)Integer.MAX_VALUE);
    }
}

