/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.assembly.AssemblyIngredient;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyManager;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyRecipe;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

public final class AssemblyRecipeLoader {
    public static void initialize(IAssemblyManager registry) {
        TmrConstants.LOG.log(Level.INFO, "Initializing Turret Assembly recipes...");
        long prevTime = System.nanoTime();
        Loader.instance().getActiveModList().forEach(mod -> AssemblyRecipeLoader.loadJsonRecipes(mod, registry));
        long timeDelta = (System.nanoTime() - prevTime) / 1000000L;
        TmrConstants.LOG.log(Level.INFO, String.format("Initializing Turret Assembly recipes done in %d ms. Found %d recipes.", timeDelta, registry.getRecipes().size()));
    }

    private static void loadJsonRecipes(ModContainer mod, IAssemblyManager registry) {
        String modId = mod.getModId();
        MiscUtils.findFiles((ModContainer)mod, (String)("assets/" + modId + '/' + "sapturretmod" + "/recipes/assembly/"), null, (root, file) -> AssemblyRecipeLoader.processJson(modId, root, file, registry));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static boolean processJson(String modId, Path root, Path file, IAssemblyManager registry) {
        block31: {
            if (!file.toString().endsWith(".json")) {
                return true;
            }
            try {
                reader = Files.newBufferedReader(file);
                var5_7 = null;
                try {
                    json = AssemblyRecipeLoader.fromJson(reader, JsonObject.class);
                    id = MiscUtils.getPathedRL((String)modId, (Path)root, (Path)file);
                    if (json == null) {
                        throw new JsonSyntaxException("Cannot read valid JSON");
                    }
                    if (json.isJsonNull()) {
                        registry.removeRecipe(id);
                        var8_12 = true;
                        return var8_12;
                    }
                    type = JsonUtils.getStringVal((JsonElement)json.get("type"));
                    if (type.equals("sapturretmod:assembly.tabs")) {
                        for (JsonElement tab : json.getAsJsonArray("tabs")) {
                            if (tab.isJsonObject()) {
                                tabObj = tab.getAsJsonObject();
                                grpName = JsonUtils.getStringVal((JsonElement)tabObj.get("name"));
                                registry.setGroupIcon(grpName, JsonUtils.getItemStack((JsonElement)tabObj.get("icon")));
                                registry.setGroupOrder(grpName, JsonUtils.getIntVal((JsonElement)tabObj.get("order"), (int)0));
                                continue;
                            }
                            throw new JsonSyntaxException("A group definition needs to be an object");
                        }
                        break block31;
                    }
                    if (!type.equals("sapturretmod:assembly.recipe")) break block31;
                    ingredients = NonNullList.func_191196_a();
                    context = new JsonContext(modId);
                    for (JsonElement jobj : json.getAsJsonArray("ingredients")) {
                        if (jobj.isJsonObject()) {
                            ingredients.add((Object)AssemblyIngredient.fromJson(jobj, context));
                            continue;
                        }
                        throw new JsonSyntaxException("An ingredient needs to be an object");
                    }
                    cstRecipeClassPath = JsonUtils.getStringVal((JsonElement)json.get("recipeClass"), null);
                    if (cstRecipeClassPath == null) ** GOTO lbl46
                    try {
                        cls = Class.forName(cstRecipeClassPath);
                        registry.registerRecipe((IAssemblyRecipe)cls.getConstructor(new Class[]{ResourceLocation.class, String.class, NonNullList.class, Integer.TYPE, Integer.TYPE, ItemStack.class}).newInstance(new Object[]{id, JsonUtils.getStringVal((JsonElement)json.get("group")), ingredients, JsonUtils.getIntVal((JsonElement)json.get("fluxPerTick")), JsonUtils.getIntVal((JsonElement)json.get("ticksProcessing")), JsonUtils.getItemStack((JsonElement)json.get("result"))}));
                        var13_24 = true;
                        return var13_24;
                    }
                    catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        try {
                            TmrConstants.LOG.log(Level.ERROR, "Cannot load recipe class, defaulting to AssemblyRecipe.", (Throwable)e);
lbl46:
                            // 2 sources

                            registry.registerRecipe(new AssemblyRecipe(id, JsonUtils.getStringVal((JsonElement)json.get("group")), (NonNullList<Ingredient>)ingredients, JsonUtils.getIntVal((JsonElement)json.get("fluxPerTick")), JsonUtils.getIntVal((JsonElement)json.get("ticksProcessing")), JsonUtils.getItemStack((JsonElement)json.get("result"))));
                        }
                        catch (Throwable var6_10) {
                            var5_7 = var6_10;
                            throw var6_10;
                        }
                        catch (Throwable var15_26) {
                            throw var15_26;
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        if (var5_7 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable var9_14) {
                                var5_7.addSuppressed(var9_14);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (JsonParseException e) {
                TmrConstants.LOG.log(Level.WARN, String.format("Malformed recipe JSON from %s", new Object[]{file}), (Throwable)e);
            }
            catch (IOException e) {
                TmrConstants.LOG.log(Level.WARN, String.format("Couldn't read recipe from %s", new Object[]{file}), (Throwable)e);
            }
        }
        return true;
    }

    public static <T> T fromJson(Reader reader, Class<T> clazz) {
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(true);
        try {
            return (T)JsonUtils.GSON.getAdapter(clazz).read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

