/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteManager;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class ElectrolyteManager
implements IElectrolyteManager {
    public static final ElectrolyteManager INSTANCE = new ElectrolyteManager();
    private final Map<ResourceLocation, IElectrolyteRecipe> fuels = new HashMap<ResourceLocation, IElectrolyteRecipe>();
    private List<IElectrolyteRecipe> cacheFuels;

    @Override
    public List<IElectrolyteRecipe> getFuels() {
        if (this.cacheFuels == null) {
            this.cacheFuels = Collections.unmodifiableList(new ArrayList<IElectrolyteRecipe>(this.fuels.values()));
        }
        return this.cacheFuels;
    }

    @Override
    public IElectrolyteRecipe getFuel(ResourceLocation id) {
        return this.fuels.get(id);
    }

    @Override
    public IElectrolyteRecipe getFuel(ItemStack stack) {
        if (!ItemStackUtils.isValid((ItemStack)stack)) {
            return null;
        }
        for (IElectrolyteRecipe recipe : this.fuels.values()) {
            for (ItemStack key : ((Ingredient)recipe.getIngredients().get(0)).func_193365_a()) {
                if (!ItemStackUtils.areEqual((ItemStack)key, (ItemStack)stack, (boolean)key.func_77942_o(), (boolean)false, (key.func_77952_i() == Short.MAX_VALUE ? 1 : 0) != 0)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public boolean registerFuel(IElectrolyteRecipe recipe) {
        ResourceLocation id = recipe.getId();
        if (id == null) {
            TmrConstants.LOG.log(Level.ERROR, "ID for electrolyte recipe cannot be null!", (Throwable)new InvalidParameterException());
            return false;
        }
        if (recipe.getEfficiency() < 1.0f) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Efficiency cannot be less than 1.0 for electrolyte recipe %s!", id), (Throwable)new InvalidParameterException());
            return false;
        }
        if (recipe.getProcessTime() < 0) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Processing time cannot be less than 0 for electrolyte recipe %s!", id), (Throwable)new InvalidParameterException());
            return false;
        }
        this.fuels.put(id, recipe);
        this.cacheFuels = null;
        return true;
    }

    @Override
    public void removeFuel(ResourceLocation id) {
        this.fuels.remove(id);
        this.cacheFuels = null;
    }

    public void clearFuels() {
        this.fuels.clear();
        this.cacheFuels = null;
    }
}

