/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ElectrolyteProcess {
    public final IElectrolyteRecipe recipe;
    public final ItemStack processStack;
    private ItemStack trashStack = null;
    private ItemStack treasureStack = null;
    private short progress = 0;

    public ElectrolyteProcess(IElectrolyteRecipe recipe, ItemStack stack) {
        this.recipe = (IElectrolyteRecipe)MiscUtils.defIfNull((Object)recipe, (Object)InvalidRecipe.INSTANCE);
        this.processStack = stack;
    }

    public ElectrolyteProcess(ByteBuf buf) {
        this.processStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.progress = buf.readShort();
        this.recipe = (IElectrolyteRecipe)MiscUtils.defIfNull((Object)ElectrolyteManager.INSTANCE.getFuel(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf))), (Object)InvalidRecipe.INSTANCE);
    }

    public ElectrolyteProcess(NBTTagCompound nbt) {
        this.processStack = new ItemStack(nbt.func_74775_l("ProgressItem"));
        this.progress = nbt.func_74765_d("Progress");
        this.recipe = (IElectrolyteRecipe)MiscUtils.defIfNull((Object)ElectrolyteManager.INSTANCE.getFuel(new ResourceLocation(nbt.func_74779_i("Recipe"))), (Object)InvalidRecipe.INSTANCE);
    }

    public void writeToByteBuf(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.processStack);
        buf.writeShort((int)this.progress);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.recipe != null ? this.recipe.getId().toString() : ""));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        ItemStackUtils.writeStackToTag((ItemStack)this.processStack, (NBTTagCompound)nbt, (String)"ProgressItem");
        nbt.func_74777_a("Progress", this.progress);
        nbt.func_74778_a("Recipe", this.recipe != null ? this.recipe.getId().toString() : "");
    }

    public int getProgress() {
        return this.progress;
    }

    public ItemStack getTrashStack(IInventory inv) {
        if (this.trashStack == null) {
            this.trashStack = MiscUtils.RNG.randomFloat() < this.recipe.getTrashChance() ? this.recipe.getCraftingResult(inv) : ItemStack.field_190927_a;
        }
        return this.trashStack;
    }

    public ItemStack getTreasureStack(IInventory inv) {
        if (this.treasureStack == null) {
            this.treasureStack = MiscUtils.RNG.randomFloat() < this.recipe.getTreasureChance() ? this.recipe.getTreasureResult(inv) : ItemStack.field_190927_a;
        }
        return this.treasureStack;
    }

    public void incrProgress() {
        this.progress = (short)(this.progress + 1);
    }

    public boolean hasFinished() {
        return this.progress >= this.recipe.getProcessTime();
    }

    private static final class InvalidRecipe
    implements IElectrolyteRecipe {
        public static final InvalidRecipe INSTANCE = new InvalidRecipe();
        private static final ResourceLocation ID = new ResourceLocation("null", "null");

        private InvalidRecipe() {
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public float getEfficiency() {
            return 0.0f;
        }

        @Override
        public int getProcessTime() {
            return 0;
        }

        @Override
        public boolean matches(IInventory inv, World worldIn) {
            return false;
        }

        @Override
        public ItemStack getCraftingResult(IInventory inv) {
            return null;
        }

        @Override
        public ItemStack getTreasureResult(IInventory inv) {
            return null;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return null;
        }

        @Override
        public NonNullList<Ingredient> getIngredients() {
            return null;
        }

        @Override
        public String getGroup() {
            return null;
        }

        @Override
        public float getTrashChance() {
            return 0.0f;
        }

        @Override
        public float getTreasureChance() {
            return 0.0f;
        }
    }
}

